/*
 * Decompiled with CFR 0.152.
 */
package elte.community;

import elte.community.DirnameLooksLikePerKResultsDir;
import elte.community.OutParams;
import elte.community.visual.URLLabel;
import java.awt.Color;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jfree.ExceptionDialog;

public class ExternalCalls {
    private JOptionPane pane;
    private JDialog dialog;
    private Timer timer;

    public native OutParams Find_coms(String var1, String var2, boolean var3, boolean var4, double var5, boolean var7, double var8, boolean var10, double var11, boolean var13, int var14, boolean var15, double var16);

    public OutParams loadComs(String dir) {
        boolean loadWeighted;
        boolean loadDirected;
        String directedTestFileName = dir + "/directed_cliques";
        File directedtestFile = new File(directedTestFileName);
        File undirectedtestFile = new File(dir + "/cliques");
        if (directedtestFile.exists()) {
            loadDirected = true;
            loadWeighted = false;
        } else if (undirectedtestFile.exists()) {
            loadDirected = false;
            File mydir = new File(dir);
            String[] candidates = mydir.list(new DirnameLooksLikePerKResultsDir());
            if (0 < candidates.length) {
                loadWeighted = new File(dir + "/" + candidates[0] + "/intensity_communities").exists();
            } else {
                System.out.println("No candidate directories found! This can't happen!");
                loadWeighted = false;
            }
        } else {
            String error = "The specified directory does not contain a CFinder community structure, either because it is not a CFinder result directory, or because the network it was generated from does not contain communities";
            ExceptionDialog.showExceptionDialog("Input directory format problem", error, new RuntimeException(error));
            return null;
        }
        return this.loadComs(dir, loadDirected, loadWeighted);
    }

    public native OutParams loadComs(String var1, boolean var2, boolean var3);

    public native OutParams findAndLoadComs(String var1, String var2, boolean var3, boolean var4, double var5, boolean var7, double var8, boolean var10, double var11, boolean var13, int var14, boolean var15, double var16);

    public native void Stop_process();

    public native String Read_state_report();

    public native String Read_error_message();

    public ExternalCalls(String libraryName) {
        try {
            System.loadLibrary(this.getLibraryName(libraryName));
        }
        catch (UnsatisfiedLinkError e) {
            ExceptionDialog.showExceptionDialog("Internal Error", "C++ library not found or other library path problem.", e);
        }
        catch (Exception e) {
            if (e.getMessage() == "invalid licence!") {
                System.out.println("licence problem!");
            }
            ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured while loading library: " + e.getMessage(), e);
        }
    }

    public String getLibraryName(String libName) {
        Properties p = System.getProperties();
        System.out.println("os.arch: " + p.getProperty("os.arch"));
        if (p.getProperty("os.arch").equals("amd64")) {
            return libName + "64";
        }
        return libName;
    }

    public native int getLicenceRemainingDays();

    public void checkLicence(boolean startup) {
        int days = this.getLicenceRemainingDays();
        System.out.println("Licence key expires in " + days + " days.");
        JPanel panel = new JPanel();
        final JCheckBox show = new JCheckBox("Only show at startup");
        final File showFile = new File("./show.conf");
        if (showFile.exists()) {
            show.setSelected(true);
        }
        String title = "Licence information";
        if (days == -2) {
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("No licence file found."));
            panel.add(new JLabel("Please copy the file \"licence.txt\" into the current directory from the directory into which you extracted CFinder after downloading it."));
        } else if (days == -1) {
            title = "30-day license key expired";
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("Licence key expired"));
            panel.add(new JLabel("For an unlimited key visit "));
            panel.add(new URLLabel("http://CFinder.org/key", "http://CFinder.org/key"));
        } else if (days >= 15) {
            title = "Licence key OK";
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("Licence key OK"));
            panel.add(new JLabel("Thank you for using CFinder"));
            panel.add(new JLabel("Support (software, data processing, etc):"));
            panel.add(new URLLabel("http://CFinder.org/manual", "http://CFinder.org/manual"));
            panel.add(new URLLabel("http://CFinder.org/faq", "http://CFinder.org/faq"));
        } else if (days < 15) {
            title = "30-day license key will expire in " + days + " days";
            panel.setLayout(new BoxLayout(panel, 1));
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.add(new JLabel("30-day license key will expire in "));
            JLabel dayLabel = new JLabel("" + days);
            dayLabel.setForeground(Color.red);
            panel2.add(dayLabel);
            panel2.add(new JLabel(" days"));
            panel.add(panel2);
            panel.add(new JLabel("For an unlimited key visit "));
            panel.add(new URLLabel("http://CFinder.org/key", "http://CFinder.org/key"));
        }
        panel.add(show);
        if (days >= 15 && (!show.isSelected() || startup)) {
            this.pane = new JOptionPane(panel, 1, -1);
            this.dialog = new JDialog((Frame)null, title, false);
            this.dialog.add(this.pane);
            this.dialog.setDefaultCloseOperation(1);
            this.dialog.pack();
            this.dialog.setVisible(true);
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                public void run() {
                    if (ExternalCalls.this.dialog.isShowing()) {
                        ExternalCalls.this.dialog.hide();
                    }
                }
            }, 30000L);
            this.pane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("value")) {
                        ExternalCalls.this.dialog.hide();
                    }
                    if (show.isSelected() && !showFile.exists()) {
                        try {
                            showFile.createNewFile();
                        }
                        catch (Exception ex) {
                            System.out.println("Could not create show.conf.");
                        }
                    } else if (!show.isSelected() && showFile.exists()) {
                        showFile.delete();
                    }
                }
            });
        } else if (days < 15) {
            JOptionPane.showMessageDialog(null, panel, title, 1);
            if (show.isSelected() && !showFile.exists()) {
                try {
                    showFile.createNewFile();
                }
                catch (Exception e) {
                    System.out.println("Could not create show.conf.");
                }
            } else if (!show.isSelected() && showFile.exists()) {
                showFile.delete();
            }
        }
    }
}

