/*
 * Decompiled with CFR 0.152.
 */
package elte.community;

import elte.community.Clique;
import elte.community.Community;
import elte.community.CommunityGrafEdge;
import elte.community.CommunityGrafNode;
import elte.community.InParams;
import elte.community.ParamsException;
import elte.community.visual.ProgressBar;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import jfree.ExceptionDialog;

public class OutParams {
    private Vector cliques = new Vector();
    private Hashtable communities = new Hashtable();
    private Hashtable communitiesByVertex = new Hashtable();
    private Hashtable communitiesByCliques = new Hashtable();
    private Hashtable communityGrafEdges = new Hashtable();
    private Hashtable communityGrafNodes = new Hashtable();
    public Hashtable sizeDist = new Hashtable();
    public Hashtable degreeDist = new Hashtable();
    public Hashtable overlapDist = new Hashtable();
    public Hashtable membershipDist = new Hashtable();
    public InParams inParams;

    public Hashtable getDegreeDistForKey(Integer key) {
        return (Hashtable)this.degreeDist.get(key);
    }

    public Hashtable getMembershipDistForKey(Integer key) {
        return (Hashtable)this.membershipDist.get(key);
    }

    public Hashtable getOverlapDistForKey(Integer key) {
        return (Hashtable)this.overlapDist.get(key);
    }

    public Hashtable getSizeDistForKey(Integer key) {
        return (Hashtable)this.sizeDist.get(key);
    }

    public void addClique(Clique c, int idx) {
        c.setIndex(idx);
        this.cliques.add(c);
    }

    public Vector getCliques() {
        return this.cliques;
    }

    public Vector getCommunityForVertex(String s) {
        return (Vector)this.communitiesByVertex.get(s);
    }

    public Vector getCommunityForClique(Clique c) {
        if (this.communitiesByCliques == null) {
            return null;
        }
        return (Vector)this.communitiesByCliques.get(c);
    }

    public void addDistribution(int key, int x, int y, String distName) {
        try {
            Field f = this.getClass().getField(distName);
            Hashtable d = (Hashtable)f.get(this);
            Integer keyI = new Integer(key);
            if (d.get(keyI) == null) {
                d.put(keyI, new Hashtable());
            }
            ((Hashtable)d.get(keyI)).put(new Integer(x), new Integer(y));
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
        }
    }

    public void addCommunity(Community c) {
        Integer key = new Integer(c.getSize());
        if (!this.communities.containsKey(key)) {
            this.communities.put(key, new Vector());
        }
        c.setIndex(((Vector)this.communities.get(key)).size());
        ((Vector)this.communities.get(key)).add(c);
    }

    public void addCommunityGrafEdge(int k, int c1, int c2, int w) {
        try {
            CommunityGrafNode cgn2;
            Hashtable cgns;
            CommunityGrafNode cgn1;
            Integer key = new Integer(k);
            if (!this.communityGrafEdges.containsKey(key)) {
                this.communityGrafEdges.put(key, new Vector());
                this.communityGrafNodes.put(key, new Hashtable());
            }
            if ((cgn1 = (CommunityGrafNode)(cgns = (Hashtable)this.communityGrafNodes.get(key)).get(new Integer(c1))) == null) {
                cgn1 = new CommunityGrafNode((Community)((Vector)this.communities.get(key)).get(c1));
                cgns.put(new Integer(c1), cgn1);
            }
            if ((cgn2 = (CommunityGrafNode)cgns.get(new Integer(c2))) == null) {
                cgn2 = new CommunityGrafNode((Community)((Vector)this.communities.get(key)).get(c2));
                cgns.put(new Integer(c2), cgn2);
            }
            cgn1.addNode(cgn2, w);
            cgn2.addNode(cgn1, w);
            CommunityGrafEdge cge = new CommunityGrafEdge();
            cge.setC1(cgn1);
            cge.setC2(cgn2);
            cge.setW(w);
            ((Vector)this.communityGrafEdges.get(key)).add(cge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCliqueToCommunity(Community c, int i) {
        Clique clq = (Clique)this.cliques.get(i);
        c.addClique(clq);
        if (!this.communitiesByCliques.containsKey(clq)) {
            this.communitiesByCliques.put(clq, new Vector());
        }
        Vector v = (Vector)this.communitiesByCliques.get(clq);
        v.add(c);
    }

    public void addVertexToCommunity(Community c, String vertex) {
        c.addVertex(vertex);
        if (!this.communitiesByVertex.containsKey(vertex)) {
            this.communitiesByVertex.put(vertex, new Vector());
        }
        Vector v = (Vector)this.communitiesByVertex.get(vertex);
        v.add(c);
    }

    public void setInParams(InParams inParams) {
        this.inParams = inParams;
    }

    public Hashtable getCommunityGrafEdges() {
        return this.communityGrafEdges;
    }

    public Hashtable getCommunityGrafNodes() {
        return this.communityGrafNodes;
    }

    public Hashtable getCommunities() {
        return this.communities;
    }

    public void readFile(String s) throws ParamsException {
    }

    public void writeFile(String s, ProgressBar pb) throws ParamsException {
    }
}

