/*
 * Decompiled with CFR 0.152.
 */
package elte.community;

import elte.community.ExternalCalls;
import elte.community.visual.ProgressFrame;
import javax.swing.SwingUtilities;
import jfree.ExceptionDialog;

public class StateReportPinger
implements Runnable {
    public static long PING_PERIOD = 1000L;
    public boolean isRunning;
    private String state = "";
    private String error = "";
    private ProgressFrame main;
    private ExternalCalls externalCalls;

    public StateReportPinger(ProgressFrame main, ExternalCalls externalCalls) {
        this.main = main;
        this.externalCalls = externalCalls;
    }

    public void run() {
        this.isRunning = true;
        this.main.log("Started...");
        while (this.isRunning) {
            String sr;
            this.state = sr = this.externalCalls.Read_state_report();
            String[] lines = this.state.split("\n");
            if (lines.length <= 0) {
                System.out.println("too short state");
            } else if (lines[0].startsWith("_")) {
                double p;
                if (lines[1].startsWith(" Locating")) {
                    String[] first_line = lines[1].split("max. allowed time");
                    lines[1] = first_line[0];
                    final String message = lines[1] + lines[2];
                    int a = lines[2].lastIndexOf("(");
                    int b = lines[2].lastIndexOf("%");
                    String percentage = lines[2].substring(a + 1, b);
                    p = Double.valueOf(percentage);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((StateReportPinger)StateReportPinger.this).main.readingInput.setIndeterminate(false);
                            ((StateReportPinger)StateReportPinger.this).main.readingInput.setProgressRatio(100.0);
                            ((StateReportPinger)StateReportPinger.this).main.readingInput.setString("Reading input... finished.");
                            ((StateReportPinger)StateReportPinger.this).main.locatingCliques.setString(message);
                            ((StateReportPinger)StateReportPinger.this).main.locatingCliques.setProgressRatio(p);
                        }
                    });
                } else if (lines[1].startsWith(" Extracting")) {
                    String percentage;
                    String our_line = lines[1];
                    int a = our_line.lastIndexOf("(completed ");
                    int b = our_line.lastIndexOf("%");
                    if (a == -1 || b == -1) {
                        our_line = lines[3];
                        a = our_line.lastIndexOf("(");
                        b = our_line.lastIndexOf("%");
                        percentage = our_line.substring(a + 1, b);
                    } else {
                        percentage = our_line.substring(a + 11, b);
                    }
                    final String message = our_line;
                    p = Double.valueOf(percentage);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((StateReportPinger)StateReportPinger.this).main.readingInput.setString("Reading input... finished.");
                            ((StateReportPinger)StateReportPinger.this).main.readingInput.setProgressRatio(100.0);
                            ((StateReportPinger)StateReportPinger.this).main.locatingCliques.setString("Locating cliques done");
                            ((StateReportPinger)StateReportPinger.this).main.locatingCliques.setProgressRatio(100.0);
                            ((StateReportPinger)StateReportPinger.this).main.extractingCommunitites.setString(message);
                            ((StateReportPinger)StateReportPinger.this).main.extractingCommunitites.setProgressRatio(p);
                        }
                    });
                } else {
                    System.out.println("StateReportPinger: no action:" + this.state);
                }
            } else if (lines[0].startsWith(" Loading")) {
                String message = lines[0];
                this.main.readingInput.setString("Reading input... finished.");
                this.main.readingInput.setProgressRatio(100.0);
                this.main.locatingCliques.setString("Locating cliques done");
                this.main.locatingCliques.setProgressRatio(100.0);
                this.main.extractingCommunitites.setString("Extracting Communities done");
                this.main.extractingCommunitites.setProgressRatio(100.0);
                this.main.loadingResults.setString(message);
                this.main.loadingResults.setIndeterminate(true);
            } else {
                System.out.println("StateReportPinger current progress message:" + this.state);
            }
            sr = this.externalCalls.Read_error_message();
            if (!sr.equals(this.error)) {
                this.error = sr;
                this.main.log("WARNING!: " + this.error);
            }
            try {
                Thread.sleep(PING_PERIOD);
            }
            catch (InterruptedException e) {
                ExceptionDialog.showExceptionDialog("Interrupted", "pinger thread interrupted: " + e.getMessage(), e);
            }
        }
        this.main.loadingResults.setIndeterminate(false);
        this.main.log("Stopped.");
    }
}

