/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Clique;
import elte.community.Community;
import elte.community.OutParams;
import elte.community.visual.FinishedListener;
import elte.community.visual.GraphPanel;
import elte.community.visual.LabelPanel;
import elte.community.visual.MainFrame;
import elte.community.visual.VisualJPanel;
import elte.community.visual.graph.GraphLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.ui.JForcePanel;

public class CommunitiesPanel
extends JSplitPane
implements VisualJPanel,
ChangeListener,
FinishedListener {
    GraphPanel graphPanel;
    JTabbedPane tabbedPanel;

    public CommunitiesPanel(MainFrame m) {
        this.graphPanel = new GraphPanel(m);
        this.graphPanel.setMinimumSize(new Dimension(100, 100));
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.addChangeListener(this);
        this.tabbedPanel.setMinimumSize(new Dimension(100, 150));
        this.setOrientation(0);
        this.setTopComponent(this.tabbedPanel);
        this.setBottomComponent(this.graphPanel);
    }

    public void repaintGraph(Community c) {
        this.graphPanel.repaintGraph(c);
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            this.tabbedPanel.setForegroundAt(i, ((LabelPanel)this.tabbedPanel.getComponentAt(i)).getCommunity().getColor());
        }
    }

    public void setCliques(Vector v) {
        Iterator i = v.iterator();
        while (i.hasNext()) {
            Clique c = (Clique)i.next();
            LabelPanel labelPanel = new LabelPanel(this);
            labelPanel.setClique(c);
            this.tabbedPanel.addTab("", labelPanel);
        }
    }

    public void setCommunities(Vector v) {
        this.tabbedPanel.removeAll();
        this.graphPanel.setNew();
        Vector<Color> usedColors = new Vector<Color>();
        Iterator i = v.iterator();
        while (i.hasNext()) {
            Community c = (Community)i.next();
            LabelPanel labelPanel = new LabelPanel(this);
            labelPanel.setCommunity(c);
            if (c.approximated) {
                this.tabbedPanel.addTab(c.getTempLabel() + "*", labelPanel);
            } else {
                this.tabbedPanel.addTab(c.getTempLabel(), labelPanel);
            }
            while (usedColors.contains(c.getColor()) && usedColors.size() + 1 < Community.colors.length) {
                c.setNewRandomColor();
            }
            usedColors.add(c.getColor());
            this.tabbedPanel.setForegroundAt(this.tabbedPanel.getTabCount() - 1, c.getColor());
            this.graphPanel.setCommunity(c);
        }
    }

    public void setDummyEdges(Community c, String centerNode) {
        this.graphPanel.setView(c.getEdges(), this, null, null, centerNode);
    }

    public void setNew(OutParams op) {
        this.tabbedPanel.removeAll();
        this.graphPanel.setNew();
    }

    public void setKeys(Vector v) {
    }

    public void setSelectedVertices(Object[] s) {
        this.graphPanel.vertexValueChanged(s);
    }

    public void stateChanged(ChangeEvent arg0) {
        GraphLayout.IS_STOP = true;
        LabelPanel lp = (LabelPanel)this.tabbedPanel.getSelectedComponent();
        if (lp != null) {
            this.graphPanel.communityValueChanged(lp.getCommunity());
        }
    }

    public void capture() {
        this.graphPanel.capture();
    }

    public void finishedEvent() {
        this.graphPanel.finished();
        this.stateChanged(new ChangeEvent(new Object()));
    }

    public TreeSet getSelectedNodes() {
        return this.graphPanel.getSelectedNodes();
    }

    public boolean maybeWidgetChange() {
        return this.graphPanel.maybeWidgetChange();
    }

    public JForcePanel getPrefuseSettings() {
        return this.graphPanel.getPrefuseSettings();
    }

    public void stopContinousLayout() {
        this.graphPanel.stopContinousLayout();
    }
}

