/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Community;
import elte.community.CommunityGrafNode;
import elte.community.Edge;
import elte.community.OutParams;
import elte.community.visual.FinishedListener;
import elte.community.visual.GraphPanel;
import elte.community.visual.MainFrame;
import elte.community.visual.Text;
import elte.community.visual.VisualJPanel;
import elte.community.visual.graph.GraphLayout;
import elte.community.visual.settings.Parameters;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class CommunityGrafPanel
extends GraphPanel
implements VisualJPanel,
FinishedListener {
    private OutParams outParam;
    private int selectedKey;
    private CommunityGrafNode centerNode;
    private Object[] selectedVertices;

    public CommunityGrafPanel(MainFrame m) {
        super(m);
    }

    public Vector getSelectedCommunities() {
        Vector<Community> v = new Vector<Community>();
        if (Parameters.USE_PREFUSE.booleanValue()) {
            TreeSet selected = this.getSelectedNodes();
            this.selectedVertices = selected.toArray();
        } else {
            this.selectedVertices = this.gl.getSelectedNodes().toArray();
        }
        if (this.selectedVertices != null) {
            for (int i = 0; i < this.selectedVertices.length; ++i) {
                v.add(((CommunityGrafNode)((Hashtable)this.outParam.getCommunityGrafNodes().get(new Integer(this.selectedKey))).get(Integer.valueOf((String)this.selectedVertices[i]))).getCommunity());
            }
        }
        return v;
    }

    public void setCliques(Vector v) {
    }

    public void setCommunities(Vector v) {
        this.setNew();
        if (v != null && v.size() > 0) {
            TreeSet edges = new TreeSet();
            TreeSet vertices = new TreeSet();
            Hashtable weights = new Hashtable();
            Hashtable sizes = new Hashtable();
            Iterator i = v.iterator();
            while (i.hasNext()) {
                Community c = (Community)i.next();
                this.selectedKey = c.getSize();
                Hashtable forKey = (Hashtable)this.outParam.getCommunityGrafNodes().get(new Integer(c.getSize()));
                if (forKey == null) continue;
                this.centerNode = (CommunityGrafNode)forKey.get(new Integer(c.getIndex()));
                if (this.centerNode == null) continue;
                this.addPartialGraph(0, null, this.centerNode, edges, vertices, weights, sizes);
            }
            if (vertices.size() > 0) {
                this.setVerticesAndEdges(vertices, edges, null, null);
                this.setView(new TreeSet(), this, weights, sizes, null);
            } else {
                this.main.status(Text.COMMUNITYGRAPH_NO_OVERLAP);
            }
        }
    }

    public void setKeys(Vector v) {
    }

    private void addPartialGraph(int depth, CommunityGrafNode prev, CommunityGrafNode node, TreeSet edges, TreeSet vertices, Hashtable weights, Hashtable sizes) {
        if (depth < Parameters.COMMGRAF_DEPTH) {
            Enumeration e = node.getNodes().keys();
            String nodeIndex = Integer.toString(node.getCommunity().getIndex());
            vertices.remove(nodeIndex);
            vertices.add(nodeIndex);
            sizes.remove(nodeIndex);
            sizes.put(nodeIndex, new Integer(Math.round((float)Math.sqrt((double)node.getCommunity().getVertices().size() * Parameters.RECT_SIZE_MULT))));
            while (e.hasMoreElements()) {
                CommunityGrafNode next = (CommunityGrafNode)e.nextElement();
                if (next.equals(prev)) continue;
                String nextIndex = Integer.toString(next.getCommunity().getIndex());
                vertices.remove(nextIndex);
                vertices.add(nextIndex);
                sizes.remove(nextIndex);
                sizes.put(nextIndex, new Integer(Math.round((float)Math.sqrt((double)next.getCommunity().getVertices().size() * Parameters.RECT_SIZE_MULT))));
                Edge eg = new Edge(nodeIndex, nextIndex);
                edges.add(eg);
                weights.put(eg, (Integer)node.getNodes().get(next));
                this.addPartialGraph(depth + 1, node, next, edges, vertices, weights, sizes);
            }
        }
    }

    public void setSelectedEdges(Object[] s) {
    }

    public void setSelectedVertices(Object[] s) {
    }

    public void setNew(OutParams op) {
        this.outParam = op;
        this.setNew();
    }

    public void finishedEvent() {
        this.finished();
        GraphLayout.IS_STOP = true;
        if (this.centerNode != null && !Parameters.USE_PREFUSE.booleanValue()) {
            this.gl.centerVertex(Integer.toString(this.centerNode.getCommunity().getIndex()));
            this.gl.repaint();
        }
    }
}

