/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.visual.MainFrame;
import elte.community.visual.StdProgressFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindingFrame
extends JFrame
implements ActionListener {
    static int undirectedAlgo = 1;
    static int directedAlgo = 2;
    static int weightedAlgo = 3;
    JTextField inFileField = new JTextField();
    JTextField lower = new JTextField();
    JTextField upper = new JTextField();
    JTextField timeLimitTextField = new JTextField();
    JTextField intensTh = new JTextField();
    JTextField exactKLevelTextField = new JTextField();
    JLabel stateLabel = new JLabel();
    JLabel intensLabel = new JLabel(" intensity threshold:");
    JLabel weightLabel = new JLabel("< weight <", 0);
    JButton inFileButton = new JButton("browse...");
    JButton runButton = new JButton("run");
    JButton exitButton = new JButton("cancel");
    JCheckBox useFilterChkBox = new JCheckBox("Filter edges");
    JCheckBox useTimeLimitChkBox = new JCheckBox("time limit (seconds per node)");
    JCheckBox setKLevelChkBox = new JCheckBox("only at k=");
    JRadioButton rb1 = new JRadioButton("undirected (CPM)");
    JRadioButton rb2 = new JRadioButton("directed (CPMd)");
    JRadioButton rb3 = new JRadioButton("weighted (CPMw)");
    private MainFrame main;
    private int selected_algorithm = 0;
    private boolean useFilter = false;
    private boolean useTimeLimit = false;

    public FindingFrame(MainFrame m) {
        this.makeGUI();
        this.main = m;
    }

    private void makeGUI() {
        this.setTitle("New Community Finding");
        this.inFileButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        this.rb1.addActionListener(this);
        this.rb2.addActionListener(this);
        this.rb3.addActionListener(this);
        this.useFilterChkBox.addActionListener(this);
        this.useTimeLimitChkBox.addActionListener(this);
        this.setKLevelChkBox.addActionListener(this);
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        JPanel filePanel = new JPanel();
        filePanel.setBorder(BorderFactory.createTitledBorder("Input File"));
        filePanel.setLayout(new GridBagLayout());
        GridBagConstraints fpc = new GridBagConstraints();
        fpc.fill = 1;
        fpc.weightx = 1.0;
        fpc.weighty = 1.0;
        fpc.gridx = 0;
        fpc.gridy = 0;
        filePanel.add((Component)new JLabel("Filename: ", 0), fpc);
        fpc.gridx = 1;
        fpc.gridy = 0;
        filePanel.add((Component)this.inFileField, fpc);
        fpc.gridx = 2;
        fpc.gridy = 0;
        filePanel.add((Component)this.inFileButton, fpc);
        fpc.gridx = 0;
        fpc.gridy = 1;
        fpc.gridwidth = 3;
        filePanel.add((Component)this.useFilterChkBox, fpc);
        this.lower.setEnabled(false);
        this.upper.setEnabled(false);
        this.weightLabel.setEnabled(false);
        fpc.gridwidth = 1;
        fpc.gridx = 0;
        fpc.gridy = 2;
        filePanel.add((Component)this.lower, fpc);
        fpc.gridx = 1;
        fpc.gridy = 2;
        filePanel.add((Component)this.weightLabel, fpc);
        fpc.gridx = 2;
        fpc.gridy = 2;
        filePanel.add((Component)this.upper, fpc);
        JPanel algorithmPanel = new JPanel();
        algorithmPanel.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        algorithmPanel.setLayout(new GridBagLayout());
        GridBagConstraints apc = new GridBagConstraints();
        apc.fill = 1;
        apc.weightx = 1.0;
        apc.weighty = 1.0;
        apc.gridwidth = 2;
        ButtonGroup algorithmButtonGroup = new ButtonGroup();
        algorithmButtonGroup.add(this.rb1);
        algorithmButtonGroup.add(this.rb2);
        algorithmButtonGroup.add(this.rb3);
        apc.gridx = 0;
        apc.gridy = 0;
        algorithmPanel.add((Component)this.rb1, apc);
        apc.gridx = 0;
        apc.gridy = 1;
        algorithmPanel.add((Component)this.rb2, apc);
        apc.gridx = 0;
        apc.gridy = 2;
        algorithmPanel.add((Component)this.rb3, apc);
        apc.gridx = 0;
        apc.gridy = 3;
        apc.gridwidth = 1;
        apc.anchor = 13;
        algorithmPanel.add((Component)this.intensLabel, apc);
        apc.gridx = 1;
        apc.gridy = 3;
        apc.anchor = 17;
        algorithmPanel.add((Component)this.intensTh, apc);
        apc.gridx = 0;
        apc.gridy = 4;
        apc.anchor = 13;
        algorithmPanel.add((Component)this.setKLevelChkBox, apc);
        apc.gridx = 1;
        apc.gridy = 4;
        apc.anchor = 17;
        algorithmPanel.add((Component)this.exactKLevelTextField, apc);
        apc.anchor = 10;
        apc.gridwidth = 2;
        this.intensTh.setEnabled(false);
        this.intensLabel.setEnabled(false);
        this.setKLevelChkBox.setEnabled(false);
        this.setKLevelChkBox.setSelected(false);
        this.exactKLevelTextField.setEnabled(false);
        this.rb1.setSelected(true);
        this.selected_algorithm = undirectedAlgo;
        JPanel approxPanel = new JPanel();
        approxPanel.setBorder(BorderFactory.createTitledBorder("Approximation"));
        approxPanel.setLayout(new GridBagLayout());
        GridBagConstraints appc = new GridBagConstraints();
        appc.weightx = 1.0;
        appc.weighty = 1.0;
        appc.fill = 1;
        appc.gridx = 0;
        appc.gridy = 5;
        appc.gridwidth = 1;
        approxPanel.add((Component)this.useTimeLimitChkBox, appc);
        appc.gridx = 1;
        appc.gridy = 5;
        approxPanel.add((Component)this.timeLimitTextField, appc);
        this.timeLimitTextField.setEnabled(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints bpc = new GridBagConstraints();
        bpc.gridx = 0;
        bpc.gridy = 2;
        buttonsPanel.add((Component)this.runButton, bpc);
        bpc.gridx = 1;
        bpc.gridy = 2;
        buttonsPanel.add((Component)this.exitButton, bpc);
        GridBagConstraints cpc = new GridBagConstraints();
        cpc.fill = 1;
        cpc.weightx = 1.0;
        cpc.weighty = 1.0;
        cpc.gridx = 0;
        cpc.gridy = 0;
        cp.add((Component)filePanel, cpc);
        cpc.gridx = 0;
        cpc.gridy = 1;
        cp.add((Component)algorithmPanel, cpc);
        cpc.gridx = 0;
        cpc.gridy = 2;
        cp.add((Component)approxPanel, cpc);
        cpc.gridx = 0;
        cpc.gridy = 3;
        cp.add((Component)buttonsPanel, cpc);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.inFileButton)) {
            if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                FileDialog f = new FileDialog((Frame)this, "select file", 0);
                f.show();
                String dir = f.getDirectory();
                String file = f.getFile();
                if (dir != null && file != null) {
                    this.inFileField.setText(dir + file);
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(this.main.lastPath));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    String tmpPath = chooser.getSelectedFile().getPath();
                    this.main.lastPath = tmpPath.substring(0, tmpPath.lastIndexOf(File.separator));
                    this.inFileField.setText(chooser.getSelectedFile().getPath());
                }
            }
        } else if (e.getSource().equals(this.runButton)) {
            this.runButton.setEnabled(false);
            this.startFinding();
        } else if (e.getSource().equals(this.exitButton)) {
            this.setVisible(false);
        } else if (e.getSource().equals(this.rb1)) {
            this.intensTh.setEnabled(false);
            this.intensLabel.setEnabled(false);
            this.setKLevelChkBox.setEnabled(false);
            this.exactKLevelTextField.setEnabled(false);
            this.selected_algorithm = undirectedAlgo;
        } else if (e.getSource().equals(this.rb2)) {
            this.intensTh.setEnabled(false);
            this.intensLabel.setEnabled(false);
            this.setKLevelChkBox.setEnabled(false);
            this.exactKLevelTextField.setEnabled(false);
            this.selected_algorithm = directedAlgo;
        } else if (e.getSource().equals(this.rb3)) {
            this.intensTh.setEnabled(true);
            this.intensLabel.setEnabled(true);
            this.setKLevelChkBox.setEnabled(true);
            if (this.setKLevelChkBox.isSelected()) {
                this.exactKLevelTextField.setEnabled(true);
            } else {
                this.exactKLevelTextField.setEnabled(false);
            }
            this.selected_algorithm = weightedAlgo;
        } else if (e.getSource().equals(this.useFilterChkBox)) {
            this.useFilter = this.useFilterChkBox.isSelected();
            if (this.useFilter) {
                this.lower.setEnabled(true);
                this.upper.setEnabled(true);
                this.weightLabel.setEnabled(true);
            } else {
                this.lower.setEnabled(false);
                this.upper.setEnabled(false);
                this.weightLabel.setEnabled(false);
            }
        } else if (e.getSource().equals(this.useTimeLimitChkBox)) {
            this.useTimeLimit = this.useTimeLimitChkBox.isSelected();
            if (this.useTimeLimit) {
                this.timeLimitTextField.setEnabled(true);
            } else {
                this.timeLimitTextField.setEnabled(false);
            }
        } else if (e.getSource().equals(this.setKLevelChkBox)) {
            if (this.setKLevelChkBox.isSelected()) {
                this.exactKLevelTextField.setEnabled(true);
            } else {
                this.exactKLevelTextField.setEnabled(false);
            }
        }
    }

    public void startFinding() {
        boolean useU;
        boolean useL;
        double timeLimit = 0.0;
        if (this.useTimeLimit) {
            try {
                timeLimit = Double.valueOf(this.timeLimitTextField.getText());
            }
            catch (NumberFormatException e) {
                this.main.showWarningDialog("<html><center>Wrong number format in time-limit setting!<br> Please enter an integer or real number as noted in the documentation.</center></html>");
                this.runButton.setEnabled(true);
                return;
            }
        }
        double l = 0.0;
        if (!this.lower.getText().equals("")) {
            useL = true;
            try {
                l = Double.valueOf(this.lower.getText());
            }
            catch (NumberFormatException e) {
                this.main.showWarningDialog("<html><center>Wrong number format in lower edge-weight filter setting!<br> Please enter an integer or real number as noted in the documentation.</center></html>");
                this.runButton.setEnabled(true);
                return;
            }
        } else {
            useL = false;
        }
        double u = 0.0;
        if (!this.upper.getText().equals("")) {
            useU = true;
            try {
                u = Double.valueOf(this.upper.getText());
            }
            catch (NumberFormatException e) {
                this.main.showWarningDialog("<html><center>Wrong number format in upper edge-weight filter setting!<br> Please enter an integer or real number as noted in the documentation.</center></html>");
                this.runButton.setEnabled(true);
                return;
            }
        } else {
            useU = false;
        }
        if (useL && useU && l > u) {
            this.main.showWarningDialog("<html><center>Lower threshold is greater than upper threshold</center></html>");
        } else {
            boolean useDirected;
            if (!this.useFilter) {
                useL = false;
                useU = false;
            }
            boolean useWeighted = false;
            boolean useKLevel = false;
            int kLevel = 0;
            double weightTh = 0.0;
            if (this.selected_algorithm == undirectedAlgo) {
                useDirected = false;
            } else if (this.selected_algorithm == directedAlgo) {
                useDirected = true;
            } else if (this.selected_algorithm == weightedAlgo) {
                useWeighted = true;
                useDirected = false;
                try {
                    weightTh = Double.valueOf(this.intensTh.getText());
                }
                catch (NumberFormatException e) {
                    this.main.showWarningDialog("<html><center>Wrong number format in intensity threshold setting!<br> Note that when using CPMw, an intensity threshold MUST be set!</center></html>");
                    this.runButton.setEnabled(true);
                    return;
                }
                useKLevel = this.setKLevelChkBox.isSelected();
                if (useKLevel) {
                    try {
                        kLevel = Integer.valueOf(this.exactKLevelTextField.getText());
                    }
                    catch (NumberFormatException e) {
                        this.main.showWarningDialog("<html><center>Wrong number format in k-level setting!<br> Note that when selecting 'only at k=', the value of k must be specified!</center></html>");
                        this.runButton.setEnabled(true);
                        return;
                    }
                }
            } else {
                System.out.println("not selected");
                this.runButton.setEnabled(true);
                return;
            }
            new StdProgressFrame(this.main, this.inFileField.getText(), useDirected, useWeighted, weightTh, useL, useU, l, u, useKLevel, kLevel, this.useTimeLimit, timeLimit).setVisible(true);
            System.out.println("started");
            this.setVisible(false);
        }
    }
}

