/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Community;
import elte.community.Edge;
import elte.community.visual.ExportFileFilter;
import elte.community.visual.FinishedListener;
import elte.community.visual.MainFrame;
import elte.community.visual.PrefuseWidget;
import elte.community.visual.graph.GraphFRLayout;
import elte.community.visual.graph.GraphLayout;
import elte.community.visual.settings.Parameters;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Scrollbar;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jfree.ExceptionDialog;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import prefuse.util.ui.JForcePanel;

public class GraphPanel
extends JPanel {
    protected GraphLayout gl;
    private JPanel zoomPanel;
    private Scrollbar sb;
    private TreeSet vertices = new TreeSet();
    private TreeSet edges = new TreeSet();
    private TreeSet overlap = new TreeSet();
    private TreeSet overlapE = new TreeSet();
    private HashSet communities = new HashSet();
    private Community selected_comm;
    private Hashtable vertexColors = new Hashtable();
    private Hashtable fontColors = new Hashtable();
    private Hashtable edgeColors = new Hashtable();
    private Hashtable lastEdgeWeights = null;
    private Hashtable lastVertexSizes = null;
    private TreeSet dummyEdges;
    protected MainFrame main;
    private String centerNode;
    public boolean usingPrefuse = true;
    private PrefuseWidget prefuseWidget = null;
    private HashMap commsToVertices = new HashMap();

    public GraphPanel(MainFrame m) {
        this.main = m;
        this.setLayout(new BorderLayout());
        this.usingPrefuse = Parameters.USE_PREFUSE;
        this.prefuseWidget = new PrefuseWidget();
        if (Parameters.USE_PREFUSE.booleanValue()) {
            this.add((Component)this.prefuseWidget, "Center");
        }
        this.gl = new GraphFRLayout(m);
        this.sb = new Scrollbar();
        this.sb.addAdjustmentListener(this.gl);
        this.sb.setVisible(true);
        this.sb.setEnabled(true);
        this.sb.setMinimum(0);
        this.sb.setMaximum(100);
        this.sb.setVisibleAmount(5);
        this.sb.setValue(50);
        this.sb.setOrientation(0);
        this.zoomPanel = new JPanel();
        this.zoomPanel.setLayout(new BorderLayout());
        this.zoomPanel.add((Component)new JLabel("  zoom  "), "West");
        this.zoomPanel.add((Component)this.sb, "Center");
    }

    public void repaintGraph(Community c) {
        boolean directed = this.edges.size() > 0 && ((Edge)this.edges.first()).isDirected;
        Map idToLabelMap = directed && (Parameters.SHOW_REL_INDEGREE != false || Parameters.SHOW_REL_OUTDEGREE != false) ? this.getRelativeDegree(Parameters.SHOW_REL_INDEGREE, Parameters.SHOW_REL_OUTDEGREE) : null;
        if (Parameters.USE_PREFUSE.booleanValue()) {
            if (this.lastEdgeWeights == null) {
                this.prefuseWidget.setItemAttributes(this.vertices, this.commsToVertices, idToLabelMap, true, this.lastEdgeWeights, directed, null);
            } else {
                this.prefuseWidget.setItemAttributes(this.vertices, this.commsToVertices, idToLabelMap, false, this.lastEdgeWeights, directed, this.lastVertexSizes);
            }
            this.prefuseWidget.startViz();
        } else {
            if (c != null) {
                Iterator i = c.getEdges().iterator();
                while (i.hasNext()) {
                    Edge e = (Edge)i.next();
                    this.edgeColors.remove(e);
                    this.edgeColors.put(e, c.getColor());
                }
                i = c.getVertices().iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    this.vertexColors.remove(v);
                    this.fontColors.remove(v);
                    this.vertexColors.put(v, c.getColor());
                    this.fontColors.put(v, c.getColor());
                }
                this.gl.refreshLabels(idToLabelMap);
            }
            this.gl.repaint();
        }
    }

    public void setCommunity(Community c) {
        this.communities.add(c);
        this.setVerticesAndEdges(c);
    }

    public void setVerticesAndEdges(Community c) {
        this.setVerticesAndEdges(c.getVertices(), c.getEdges(), c.getColor(), c);
    }

    public void setVerticesAndEdges(TreeSet vertices, TreeSet edges, Color color, Community community) {
        Edge e;
        Set<String> comm;
        if (this.commsToVertices.containsKey(community)) {
            comm = (Set)this.commsToVertices.get(community);
        } else {
            comm = new HashSet();
            this.commsToVertices.put(community, comm);
        }
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            String v = (String)i.next();
            if (Parameters.USE_PREFUSE.booleanValue()) {
                comm.add(v);
                this.vertices.add(v);
                continue;
            }
            if (this.vertices.remove(v)) {
                this.overlap.add(v);
            }
            this.vertices.add(v);
            if (color == null) continue;
            this.vertexColors.put(v, color);
            this.fontColors.put(v, color);
        }
        if (color != null) {
            i = edges.iterator();
            while (i.hasNext()) {
                e = (Edge)i.next();
                this.edgeColors.put(e, color);
            }
        }
        i = edges.iterator();
        while (i.hasNext()) {
            e = (Edge)i.next();
            if (this.edges.remove(e)) {
                this.overlapE.add(e);
            }
            this.edges.add(e);
        }
        if (Parameters.USE_PREFUSE.booleanValue()) {
            // empty if block
        }
    }

    public Map getRelativeDegree(boolean show_in, boolean show_out) {
        HashMap idToLabelMap = new HashMap();
        Iterator i = this.communities.iterator();
        while (i.hasNext()) {
            Community c = (Community)i.next();
            this.relativeDegreeInComm(c, idToLabelMap, show_in, show_out);
        }
        this.relativeDegreeInComm(this.selected_comm, idToLabelMap, show_in, show_out);
        return idToLabelMap;
    }

    public void relativeDegreeInComm(Community c, Map idToLabelMap, boolean show_in, boolean show_out) {
        String n;
        HashMap<String, Integer> nodeToInDegree = new HashMap<String, Integer>();
        HashMap<String, Integer> nodeToOutDegree = new HashMap<String, Integer>();
        Iterator j = c.getVertices().iterator();
        while (j.hasNext()) {
            n = (String)j.next();
            nodeToInDegree.put(n, new Integer(0));
            nodeToOutDegree.put(n, new Integer(0));
        }
        j = c.getEdges().iterator();
        while (j.hasNext()) {
            Edge e = (Edge)j.next();
            String v1 = e.getVertex1();
            String v2 = e.getVertex2();
            nodeToOutDegree.put(v1, new Integer((Integer)nodeToOutDegree.get(v1) + 1));
            nodeToInDegree.put(v2, new Integer((Integer)nodeToInDegree.get(v2) + 1));
        }
        j = c.getVertices().iterator();
        while (j.hasNext()) {
            n = (String)j.next();
            int in = (Integer)nodeToInDegree.get(n);
            int out = (Integer)nodeToOutDegree.get(n);
            double relative_in = (double)in / (double)(in + out);
            relative_in = (double)((int)(relative_in * 100.0)) / 100.0;
            double relative_out = (double)out / (double)(in + out);
            relative_out = (double)((int)(relative_out * 100.0)) / 100.0;
            String val = "";
            if (show_in) {
                val = val + Double.toString(relative_in);
            }
            if (show_in && show_out) {
                val = val + "; ";
            }
            if (show_out) {
                val = val + Double.toString(relative_out);
            }
            idToLabelMap.put(n, n + "( " + val + " )");
        }
    }

    public Map getTestAnnotation() {
        HashMap<String, String> idToLabelMap = new HashMap<String, String>();
        Iterator i = this.vertices.iterator();
        while (i.hasNext()) {
            String n = (String)i.next();
            idToLabelMap.put(n, "(" + n + ")");
        }
        return idToLabelMap;
    }

    public void dumpAnnotation(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            System.out.println(s + " -- " + map.get(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(TreeSet dummy, FinishedListener listener, Hashtable edgeWeights, Hashtable vertexSizes, String centerNode) {
        this.lastEdgeWeights = edgeWeights;
        this.lastVertexSizes = vertexSizes;
        Map idToLabelMap = ((Edge)this.edges.first()).isDirected && (Parameters.SHOW_REL_INDEGREE != false || Parameters.SHOW_REL_OUTDEGREE != false) ? this.getRelativeDegree(Parameters.SHOW_REL_INDEGREE, Parameters.SHOW_REL_OUTDEGREE) : null;
        if (Parameters.USE_PREFUSE.booleanValue()) {
            if (edgeWeights == null) {
                this.prefuseWidget.addData(this.vertices, this.edges, this.commsToVertices, idToLabelMap, true);
            } else {
                this.prefuseWidget.addData(this.vertices, this.edges, this.commsToVertices, idToLabelMap, false, edgeWeights, vertexSizes);
            }
            this.main.setCaptureButton(true);
            this.main.setZoomAndWalk(true, true);
        } else {
            this.centerNode = centerNode;
            this.removeAll();
            GraphLayout.IS_STOP = true;
            Object object = this.gl.lock;
            synchronized (object) {
                if (Parameters.IS_DRAW_GRAPH.booleanValue()) {
                    this.edges.addAll(dummy);
                    this.gl.set(this.vertices, this.edges, this.overlap, this.overlapE, edgeWeights, vertexSizes, this.edgeColors, this.vertexColors, this.fontColors, idToLabelMap, listener);
                    this.edges.removeAll(dummy);
                    this.dummyEdges = dummy;
                    this.add((Component)new JLabel("<html><center>Calculating Graph Layout...</center></html>", 0), "Center");
                    new Thread(this.gl).start();
                } else {
                    this.add((Component)new JLabel("<html><center>If you want the graph layout to be drawn,<br>please go to the Tools menu, select Settings and check Draw Graph.<br>The graph will be displayed only if you select the communities again.</center></html>", 0), "Center");
                }
                this.validate();
            }
        }
    }

    public void repaint() {
        if (!Parameters.USE_PREFUSE.booleanValue() && this.gl != null) {
            this.gl.setSize(this.getSize());
        }
        super.repaint();
    }

    public void setNew() {
        this.vertices = new TreeSet();
        this.edges = new TreeSet();
        this.overlap = new TreeSet();
        this.overlapE = new TreeSet();
        this.communities = new HashSet();
        if (Parameters.USE_PREFUSE.booleanValue()) {
            this.commsToVertices.clear();
            this.prefuseWidget.clearGraph();
        } else {
            this.removeAll();
            GraphLayout.IS_STOP = true;
            this.validate();
            this.repaint();
        }
    }

    public TreeSet getSelectedNodes() {
        if (Parameters.USE_PREFUSE.booleanValue()) {
            return this.prefuseWidget.getSelectedNodeIds();
        }
        return this.gl.getSelectedNodes();
    }

    public void vertexValueChanged(Object[] s) {
        if (Parameters.USE_PREFUSE.booleanValue()) {
            this.prefuseWidget.selectVertex(s, true);
        } else {
            this.gl.selectVertex(s, true);
            this.gl.repaint();
        }
    }

    public void communityValueChanged(Community c) {
        this.selected_comm = c;
        Map idToLabelMap = this.edges.size() > 0 && ((Edge)this.edges.first()).isDirected && (Parameters.SHOW_REL_INDEGREE != false || Parameters.SHOW_REL_OUTDEGREE != false) ? this.getRelativeDegree(Parameters.SHOW_REL_INDEGREE, Parameters.SHOW_REL_OUTDEGREE) : null;
        if (Parameters.USE_PREFUSE.booleanValue()) {
            this.prefuseWidget.refreshLabels(idToLabelMap);
        } else {
            this.gl.selectCommunity(c);
            this.gl.refreshLabels(idToLabelMap);
            this.gl.repaint();
        }
    }

    public void capture() {
        block14: {
            if (Parameters.USE_PREFUSE.booleanValue()) {
                try {
                    JFileChooser chooser = new JFileChooser(".");
                    ExportFileFilter filterPNG = new ExportFileFilter("png", "PNG files");
                    chooser.addChoosableFileFilter(filterPNG);
                    ExportFileFilter filterEPS = new ExportFileFilter("ps", "Postscript files");
                    chooser.addChoosableFileFilter(filterEPS);
                    ExportFileFilter filterPDF = new ExportFileFilter("pdf", "PDF files");
                    chooser.addChoosableFileFilter(filterPDF);
                    ExportFileFilter filterSVG = new ExportFileFilter("svg", "SVG files");
                    chooser.addChoosableFileFilter(filterSVG);
                    chooser.setFileSelectionMode(0);
                    int returnVal = chooser.showSaveDialog(this);
                    if (returnVal != 0) break block14;
                    String fileName = chooser.getSelectedFile().getName() + "." + ((ExportFileFilter)chooser.getFileFilter()).getExtension();
                    String filePath = chooser.getSelectedFile().getPath() + "." + ((ExportFileFilter)chooser.getFileFilter()).getExtension();
                    System.out.println("filename: " + fileName);
                    System.out.println("filePath: " + filePath);
                    File file = new File(filePath);
                    Dimension d = new Dimension(this.prefuseWidget.display.getWidth(), this.prefuseWidget.display.getHeight());
                    if (filePath.endsWith("svg") || filePath.endsWith("pdf") || filePath.endsWith("ps")) {
                        SVGGraphics2D imageExportGraphics2D = null;
                        if (filePath.endsWith("svg")) {
                            imageExportGraphics2D = new SVGGraphics2D(file, d);
                        } else if (filePath.endsWith("pdf")) {
                            imageExportGraphics2D = new PDFGraphics2D(file, d);
                        } else if (filePath.endsWith("ps")) {
                            imageExportGraphics2D = new PSGraphics2D(file, d);
                        }
                        if (imageExportGraphics2D != null) {
                            imageExportGraphics2D.startExport();
                            this.prefuseWidget.display.damageReport();
                            this.prefuseWidget.display.paintDisplay((Graphics2D)imageExportGraphics2D, d);
                            imageExportGraphics2D.endExport();
                        }
                        break block14;
                    }
                    BufferedImage bufferedImage = new BufferedImage(this.prefuseWidget.display.getWidth(), this.prefuseWidget.display.getHeight(), 6);
                    Graphics2D g2d = bufferedImage.createGraphics();
                    this.prefuseWidget.display.damageReport();
                    this.prefuseWidget.display.paintDisplay(g2d, d);
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                }
                catch (IOException e) {
                    ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
                    e.printStackTrace();
                }
            } else {
                try {
                    JFileChooser chooser = new JFileChooser(".");
                    ExportFileFilter filterJPG = new ExportFileFilter("jpg", "JPEG files");
                    chooser.addChoosableFileFilter(filterJPG);
                    ExportFileFilter filterPNG = new ExportFileFilter("png", "PNG files");
                    chooser.addChoosableFileFilter(filterPNG);
                    ExportFileFilter filterEPS = new ExportFileFilter("eps", "Encapsulated Postscript files");
                    chooser.addChoosableFileFilter(filterEPS);
                    chooser.setFileSelectionMode(0);
                    int returnVal = chooser.showSaveDialog(this);
                    if (returnVal == 0) {
                        String fileName = chooser.getSelectedFile().getName() + "." + ((ExportFileFilter)chooser.getFileFilter()).getExtension();
                        String filePath = chooser.getSelectedFile().getPath() + "." + ((ExportFileFilter)chooser.getFileFilter()).getExtension();
                        this.gl.capture(filePath);
                        this.gl.repaint();
                    }
                }
                catch (IOException e) {
                    ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        }
    }

    public void startEvent() {
    }

    public void finished() {
        if (!Parameters.USE_PREFUSE.booleanValue()) {
            this.removeAll();
            if (!GraphLayout.IS_STOP) {
                this.gl.removeEdges(this.dummyEdges);
                this.gl.setSize(this.getSize());
                this.add((Component)this.gl, "Center");
                this.add((Component)this.zoomPanel, "South");
                this.main.setCaptureButton(true);
                this.main.setZoomAndWalk(true, true);
                this.gl.repaint();
            }
            if (this.centerNode != null) {
                this.gl.centerVertex(this.centerNode);
            }
            this.repaint();
            this.validate();
        }
    }

    public boolean maybeWidgetChange() {
        if (Parameters.USE_PREFUSE != this.usingPrefuse) {
            this.removeAll();
            if (Parameters.USE_PREFUSE.booleanValue()) {
                this.prefuseWidget.startViz();
                this.add((Component)this.prefuseWidget, "Center");
            } else {
                this.main.outParamsPanel.showPrefusePanel(false);
                this.prefuseWidget.stopViz();
            }
            this.usingPrefuse = Parameters.USE_PREFUSE;
            return true;
        }
        return false;
    }

    public void stopContinousLayout() {
        this.prefuseWidget.setContinousLayout(false);
    }

    public JForcePanel getPrefuseSettings() {
        return this.prefuseWidget.getPrefuseSettings();
    }
}

