/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.visual.settings.Parameters;
import java.util.LinkedList;

public class History {
    public static int VERTICES_VIEW = 0;
    public static int COMMUNITIES_VIEW = 1;
    public static int COMMGRAPH_VIEW = 2;
    public static int STATS_VIEW = 3;
    public static int CLIQUES_VIEW = 4;
    private LinkedList history = new LinkedList();
    private int current = 0;

    public void addElementToHistory(Object[] o) {
        this.history.addLast(o);
        if (this.history.size() > Parameters.HISTORY_LENGTH) {
            this.history.removeFirst();
        }
        this.current = this.history.size();
    }

    public void changePreviousElement(Object[] o) {
        int i = (Integer)((Object[])this.history.get(this.current - 1))[0];
        this.history.remove(this.current - 1);
        this.history.add(this.current - 1, new Object[]{new Integer(i), o});
    }

    public void clearHistoryAboveCurrent() {
        while (this.history.size() > this.current) {
            this.history.removeLast();
        }
    }

    public Object[] getPreviousElement() {
        return (Object[])this.history.get(this.current - 1);
    }

    public void back() {
        if (this.current > 0) {
            --this.current;
        }
    }

    public void forward() {
        if (this.current < this.history.size()) {
            ++this.current;
        }
    }

    public boolean getBack() {
        return this.current > 1;
    }

    public boolean getForward() {
        return this.current < this.history.size();
    }

    public void print() {
        System.out.println("current: " + this.current);
        System.out.println("length: " + this.history.size());
    }
}

