/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.visual.IntroIcon;
import elte.community.visual.MainFrame;
import elte.community.visual.Text;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class IntroCanvas
extends JComponent
implements MouseListener,
MouseMotionListener {
    private MainFrame main;
    private ArrayList icons;
    private IntroIcon selected;

    public IntroCanvas(MainFrame m) {
        this.main = m;
        this.icons = new ArrayList();
        ImageIcon ii = new ImageIcon("OpenNewBig.gif");
        this.icons.add(new IntroIcon(50, 50, ii.getIconWidth(), ii.getIconHeight(), ii, IntroIcon.NEW_ICON, "open new network", Text.NEW_ITEM_TIP));
        ImageIcon ij = new ImageIcon("OpenDirBig.gif");
        this.icons.add(new IntroIcon(50, 150, ij.getIconWidth(), ij.getIconHeight(), ij, IntroIcon.OPEN_ICON, "open communities", Text.OPEN_ITEM_TIP));
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        Iterator i = this.icons.iterator();
        g.setFont(new Font("Serif", 1, 14));
        while (i.hasNext()) {
            IntroIcon ii = (IntroIcon)i.next();
            g.setColor(Color.BLACK);
            if (this.selected == ii) {
                ii.getImage().paintIcon(this, g, ii.getX() + 2, ii.getY() + 2);
                g.setColor(Color.RED);
                ((Graphics2D)g).drawRect(ii.getX() + 2, ii.getY() + 2, ii.getW(), ii.getH());
                ((Graphics2D)g).drawString(ii.getSelectedText(), ii.getX() + 7, ii.getY() + ii.getH() + 17);
                continue;
            }
            ii.getImage().paintIcon(this, g, ii.getX(), ii.getY());
            ((Graphics2D)g).drawString(ii.getText(), ii.getX() + 5, ii.getY() + ii.getH() + 15);
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        int x = arg0.getX();
        int y = arg0.getY();
        Iterator i = this.icons.iterator();
        while (i.hasNext()) {
            IntroIcon ii = (IntroIcon)i.next();
            if (x <= ii.getX() || x >= ii.getX() + ii.getW() || y <= ii.getY() || y >= ii.getY() + ii.getH()) continue;
            this.main.introCallback(ii.getNumber());
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
        int x = arg0.getX();
        int y = arg0.getY();
        Iterator i = this.icons.iterator();
        this.selected = null;
        while (i.hasNext()) {
            IntroIcon ii = (IntroIcon)i.next();
            if (x <= ii.getX() || x >= ii.getX() + ii.getW() || y <= ii.getY() || y >= ii.getY() + ii.getH()) continue;
            this.selected = ii;
        }
        this.repaint();
    }
}

