/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Clique;
import elte.community.Community;
import elte.community.Edge;
import elte.community.visual.CommunitiesPanel;
import elte.community.visual.ListWithLabel;
import elte.community.visual.graph.GraphLayout;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LabelPanel
extends JSplitPane
implements ListSelectionListener {
    ListWithLabel vertices;
    ListWithLabel edges;
    ListWithLabel cliques;
    CommunitiesPanel cPanel;
    Community community;

    public LabelPanel(CommunitiesPanel c) {
        this.cPanel = c;
        this.vertices = new ListWithLabel(new JList(), "Vertices", 2, false);
        this.vertices.addListSelectionListener(this);
        this.vertices.setMinimumSize(new Dimension(150, 100));
        this.edges = new ListWithLabel(new JList(), "Edges", 2, false);
        this.edges.addListSelectionListener(this);
        this.edges.setMinimumSize(new Dimension(150, 100));
        this.cliques = new ListWithLabel(new JList(), "Cliques", 2, false, true);
        this.cliques.addListSelectionListener(this);
        this.cliques.setMinimumSize(new Dimension(150, 100));
        this.setLeftComponent(this.vertices);
        JSplitPane rightPanel = new JSplitPane();
        rightPanel.setLeftComponent(this.edges);
        rightPanel.setRightComponent(this.cliques);
        this.setRightComponent(rightPanel);
    }

    public void setClique(Clique c) {
        this.vertices.setListData(c.getVertices());
        this.edges.setListData(new Vector());
    }

    public void setCommunity(Community c) {
        this.community = c;
        this.vertices.setListData(new Vector(c.getVertices()));
        this.edges.setListData(new Vector(c.getEdges()));
        this.cliques.setListData(new Vector(c.getCliques()));
    }

    public Community getCommunity() {
        return this.community;
    }

    public void setNew() {
        this.community = null;
        this.vertices.setListData(new Vector());
        this.edges.setListData(new Vector());
        this.cliques.setListData(new Vector());
    }

    public void valueChanged(ListSelectionEvent arg0) {
        int i;
        Object[] o;
        Vector<String> v;
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        GraphLayout.IS_STOP = true;
        if (arg0.getSource().equals(this.vertices.list)) {
            this.cPanel.setSelectedVertices(this.vertices.list.getSelectedValues());
        }
        if (arg0.getSource().equals(this.edges.list)) {
            v = new Vector<String>();
            o = this.edges.list.getSelectedValues();
            for (i = 0; i < o.length; ++i) {
                v.add(((Edge)o[i]).getVertex1());
                v.add(((Edge)o[i]).getVertex2());
            }
            this.cPanel.setSelectedVertices(v.toArray());
        }
        if (arg0.getSource().equals(this.cliques.list)) {
            v = new Vector();
            o = this.cliques.list.getSelectedValues();
            for (i = 0; i < o.length; ++i) {
                v.addAll(((Clique)o[i]).getVertices());
            }
            this.cPanel.setSelectedVertices(v.toArray());
        }
    }
}

