/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.VertexWithCommunity;
import elte.community.visual.MyListCellRenderer;
import elte.community.visual.graph.GraphLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class ListWithLabel
extends JPanel
implements ActionListener {
    JList list;
    JLabel lab;
    JLabel labUnder;
    String label;
    JTextField field;
    JToggleButton sortButton;
    Vector data;

    public ListWithLabel(JList list, String label, int selectionMode, boolean searchField) {
        this.list = list;
        this.label = label;
        list.setSelectionMode(selectionMode);
        this.setLayout(new BorderLayout());
        JPanel labels = new JPanel(new BorderLayout());
        this.lab = new JLabel(label);
        this.labUnder = new JLabel(" ");
        this.labUnder.setForeground(Color.GRAY);
        labels.add((Component)this.lab, "North");
        labels.add((Component)this.labUnder, "South");
        this.add((Component)labels, "North");
        if (searchField) {
            JPanel searchPanel = new JPanel();
            searchPanel.setLayout(new BorderLayout());
            searchPanel.add((Component)new JLabel(" search "), "West");
            this.field = new JTextField();
            this.field.addActionListener(this);
            searchPanel.add((Component)this.field, "Center");
            this.sortButton = new JToggleButton("sort");
            this.sortButton.addActionListener(this);
            searchPanel.add((Component)this.sortButton, "East");
            this.add((Component)searchPanel, "South");
        }
        this.add((Component)new JScrollPane(list), "Center");
    }

    public ListWithLabel(JList list, String label, int selectionMode, boolean searchField, boolean markupApproximated) {
        this(list, label, selectionMode, searchField);
        if (markupApproximated) {
            list.setCellRenderer(new MyListCellRenderer());
        }
    }

    public void setListData(Vector v) {
        this.data = v;
        this.list.setListData(this.data);
        this.labUnder.setText("Total: " + v.size() + " items");
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.field)) {
            GraphLayout.IS_STOP = true;
            String s = this.field.getText();
            int i = this.list.getNextMatch(s, 0, Position.Bias.Forward);
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
        }
        if (arg0.getSource().equals(this.sortButton)) {
            if (this.sortButton.isSelected()) {
                Collections.sort(this.data, VertexWithCommunity.getCommunityNumberComparator());
            } else {
                Collections.sort(this.data, VertexWithCommunity.getVertexComparator());
            }
            this.list.setListData(this.data);
        }
    }
}

