/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.ExternalCalls;
import elte.community.InParams;
import elte.community.OutParams;
import elte.community.StateReportPinger;
import elte.community.visual.MainFrame;
import elte.community.visual.ProgressFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import jfree.ExceptionDialog;

public class LoadingProgressFrame
extends ProgressFrame {
    protected String outDir;

    public LoadingProgressFrame(MainFrame m, String filename) {
        super(m, "Loading communities");
        this.outDir = filename;
        this.log("loading c++ library");
        this.externalCalls = new ExternalCalls("commfind");
        this.log("loaded c++ library");
        this.makeProgressBars();
        String algo = "Loading from directory:";
        GridBagLayout gln = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.paramPanel.setLayout(gln);
        c.gridx = 0;
        c.ipady = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        this.paramPanel.add((Component)new JLabel(algo), c);
        c.gridy = 1;
        this.paramPanel.add((Component)new JLabel(filename), c);
        this.pack();
        this.validate();
        this.repaint();
        this.setVisible(true);
        this.srPinger = new StateReportPinger(this, this.externalCalls);
        this.start();
    }

    protected void makeProgressBars() {
        GridBagLayout gln = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.progressBarPanel.setLayout(gln);
        this.loadingResults.setPreferredSize(new Dimension(500, 25));
        c.gridx = 0;
        c.ipady = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        this.progressBarPanel.add((Component)this.loadingResults, c);
    }

    public void run() {
        InParams ip = null;
        OutParams op = null;
        try {
            this.externalCalls.checkLicence(false);
            this.loadingResults.setIndeterminate(false);
            this.loadingResults.setString("Loading Communitites");
            op = this.externalCalls.loadComs(this.outDir);
            ip = op.inParams;
            this.loadingResults.setIndeterminate(false);
            this.loadingResults.setProgressRatio(100.0);
            this.log("OK");
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Licence file not found or invalid licence key")) {
                String errorMessage = "<html>" + e.getMessage() + "<p>Please check that the directory you are running CFinder from contains a licence.txt file which includes a valid licence key.";
                ExceptionDialog.showExceptionDialog("Licence key error", errorMessage, e);
            }
            ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
            e.printStackTrace();
        }
        this.findingFinished(ip, op);
    }
}

