/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.ExternalCalls;
import elte.community.InParams;
import elte.community.OutParams;
import elte.community.visual.FindingFrame;
import elte.community.visual.InfoDialog;
import elte.community.visual.IntroIcon;
import elte.community.visual.IntroPanel;
import elte.community.visual.LoadingProgressFrame;
import elte.community.visual.OutParamsPanel;
import elte.community.visual.StatusBarTimer;
import elte.community.visual.Text;
import elte.community.visual.URLPanel;
import elte.community.visual.WarningDialog;
import elte.community.visual.graph.GraphLayout;
import elte.community.visual.settings.Parameters;
import elte.community.visual.settings.SettingsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class MainFrame
extends JFrame
implements ActionListener {
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenuItem newItem = new JMenuItem("Open new network...");
    JMenuItem openInItem = new JMenuItem("Open communities...");
    JMenuItem exitItem = new JMenuItem("Exit");
    JMenu viewMenu = new JMenu("View");
    JRadioButtonMenuItem verticesItem = new JRadioButtonMenuItem("Vertices");
    JRadioButtonMenuItem communitiesItem = new JRadioButtonMenuItem("Communities");
    JRadioButtonMenuItem cliquesItem = new JRadioButtonMenuItem("Cliques");
    JRadioButtonMenuItem statsItem = new JRadioButtonMenuItem("Stats");
    JRadioButtonMenuItem commGrafItem = new JRadioButtonMenuItem("Graph of Communities");
    JMenuItem settingsItem = new JMenuItem("Settings...");
    JMenuItem showPefusePanel = new JMenuItem("Prefuse settings...");
    JMenu toolMenu = new JMenu("Tools");
    JMenuItem captureItem = new JMenuItem("Export graph...");
    JMenuItem stopItem = new JMenuItem("Stop calculation!");
    JMenu helpMenu = new JMenu("Help");
    JMenuItem aboutItem = new JMenuItem("About");
    JToolBar toolBar = new JToolBar();
    JButton backButton = new JButton();
    JButton forwardButton = new JButton();
    JButton openNewButton = new JButton();
    JButton openDirButton = new JButton();
    JButton exportButton = new JButton();
    JButton zoomButton = new JButton("zoom");
    JButton walkButton = new JButton("walk");
    JButton stopButton = new JButton("stop layout");
    JToggleButton loglogButton = new JToggleButton("log-log plot");
    JToggleButton cumulativeButton = new JToggleButton("cumulative distribution");
    JLabel statusBar = new JLabel();
    URLPanel urls;
    public OutParamsPanel outParamsPanel;
    SettingsDialog settingsDialog;
    JFrame graphFrame;
    StatusBarTimer timer = new StatusBarTimer(this.statusBar);
    IntroPanel intro;
    public boolean notIntroPanel = false;
    String lastPath = ".";

    public MainFrame() {
        this.setTitle("CFinder");
        this.outParamsPanel = new OutParamsPanel(this);
        this.settingsDialog = new SettingsDialog(this.outParamsPanel);
        this.intro = new IntroPanel(this);
        JPanel contentP = new JPanel(new BorderLayout());
        contentP.setOpaque(true);
        contentP.add((Component)this.intro, "Center");
        this.newItem.addActionListener(this);
        this.newItem.setToolTipText(Text.NEW_ITEM_TIP);
        this.fileMenu.add(this.newItem);
        this.openInItem.addActionListener(this);
        this.openInItem.setToolTipText(Text.OPEN_ITEM_TIP);
        this.fileMenu.add(this.openInItem);
        this.captureItem.addActionListener(this);
        this.captureItem.setToolTipText(Text.EXPORT_TIP);
        this.fileMenu.add(this.captureItem);
        this.exitItem.addActionListener(this);
        this.fileMenu.add(this.exitItem);
        this.menuBar.add(this.fileMenu);
        ButtonGroup group = new ButtonGroup();
        this.communitiesItem.addActionListener(this);
        this.communitiesItem.setEnabled(false);
        this.communitiesItem.setToolTipText(Text.COMMUNITIES_VIEW);
        this.viewMenu.add(this.communitiesItem);
        group.add(this.communitiesItem);
        this.verticesItem.addActionListener(this);
        this.verticesItem.setEnabled(false);
        this.verticesItem.setToolTipText(Text.VERTICES_VIEW);
        this.viewMenu.add(this.verticesItem);
        group.add(this.verticesItem);
        this.cliquesItem.addActionListener(this);
        this.cliquesItem.setEnabled(false);
        this.cliquesItem.setToolTipText(Text.CLIQUES_VIEW);
        this.viewMenu.add(this.cliquesItem);
        group.add(this.cliquesItem);
        this.statsItem.addActionListener(this);
        this.statsItem.setEnabled(false);
        this.statsItem.setToolTipText(Text.STATS_VIEW);
        this.viewMenu.add(this.statsItem);
        group.add(this.statsItem);
        this.commGrafItem.addActionListener(this);
        this.commGrafItem.setEnabled(false);
        this.commGrafItem.setToolTipText(Text.COMMUNITY_GRAPH_VIEW);
        this.viewMenu.add(this.commGrafItem);
        group.add(this.commGrafItem);
        this.stopItem.addActionListener(this);
        this.stopItem.setToolTipText(Text.STOP_TIP);
        this.toolMenu.add(this.stopItem);
        this.settingsItem.addActionListener(this);
        this.settingsItem.setToolTipText(Text.SETTINGS_TIP);
        this.toolMenu.add(this.settingsItem);
        this.showPefusePanel.addActionListener(this);
        this.toolMenu.add(this.showPefusePanel);
        this.menuBar.add(this.toolMenu);
        this.aboutItem.addActionListener(this);
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        ImageIcon icon1 = new ImageIcon("Back.gif");
        this.backButton.addActionListener(this);
        this.backButton.setIcon(icon1);
        this.backButton.setToolTipText(Text.BACK_TIP);
        this.toolBar.add(this.backButton);
        ImageIcon icon2 = new ImageIcon("Forward.gif");
        this.forwardButton.addActionListener(this);
        this.forwardButton.setIcon(icon2);
        this.forwardButton.setToolTipText(Text.FORWARD_TIP);
        this.toolBar.add(this.forwardButton);
        ImageIcon icon3 = new ImageIcon("New.gif");
        this.openNewButton.addActionListener(this);
        this.openNewButton.setIcon(icon3);
        this.openNewButton.setToolTipText(Text.NEW_ITEM_TIP);
        this.toolBar.add(this.openNewButton);
        ImageIcon icon4 = new ImageIcon("Open.gif");
        this.openDirButton.addActionListener(this);
        this.openDirButton.setIcon(icon4);
        this.openDirButton.setToolTipText(Text.OPEN_ITEM_TIP);
        this.toolBar.add(this.openDirButton);
        ImageIcon icon5 = new ImageIcon("Export.gif");
        this.exportButton.addActionListener(this);
        this.exportButton.setIcon(icon5);
        this.exportButton.setToolTipText(Text.EXPORT_TIP);
        this.toolBar.add(this.exportButton);
        ImageIcon icon6 = new ImageIcon("Zoom.gif");
        this.zoomButton.addActionListener(this);
        this.zoomButton.setIcon(icon6);
        this.toolBar.add(this.zoomButton);
        ImageIcon icon7 = new ImageIcon("Walk.gif");
        this.walkButton.addActionListener(this);
        this.walkButton.setIcon(icon7);
        this.toolBar.add(this.walkButton);
        this.stopButton.addActionListener(this);
        this.stopButton.setToolTipText(Text.STOP_TIP);
        this.toolBar.add(this.stopButton);
        this.loglogButton.addActionListener(this);
        this.loglogButton.setSelected(Parameters.IS_LOGLOG);
        this.cumulativeButton.addActionListener(this);
        this.cumulativeButton.setSelected(Parameters.IS_CUMULATIVE);
        contentP.add((Component)this.toolBar, "North");
        this.toolBar.setFloatable(false);
        this.createURLs();
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BorderLayout());
        barPanel.add((Component)this.statusBar, "North");
        contentP.add((Component)barPanel, "South");
        this.status(Text.INITIAL);
        this.setContentPane(contentP);
        this.setSize(700, 500);
        this.setDefaultCloseOperation(3);
        this.setCaptureButton(false);
        this.setZoomAndWalk(false, false);
        this.setBackAndForward(false, false);
        new Timer(500, this.timer).start();
        this.statusBar.setForeground(Parameters.STATUSBAR_COLOR);
        this.statusBar.setBackground(Parameters.STATUSBAR_BACK_COLOR);
        this.statusBar.setOpaque(true);
        this.statusBar.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.BLUE));
    }

    private void createURLs() {
        this.urls = new URLPanel(Text.URLS);
    }

    public void setParams(InParams ip, OutParams op) {
        if (op.getCommunities().size() == 0) {
            this.status("No communities found: either data has none (maybe network is bipartite?) or user aborted");
        } else {
            this.notIntroPanel = true;
            this.getContentPane().remove(this.intro);
            this.getContentPane().add((Component)this.outParamsPanel, "Center");
            this.outParamsPanel.setInParams(ip);
            this.outParamsPanel.setOutParams(op);
            this.menuBar.add((Component)this.viewMenu, 1);
            this.verticesItem.setEnabled(true);
            this.verticesItem.setSelected(true);
            this.communitiesItem.setEnabled(true);
            this.cliquesItem.setEnabled(true);
            this.statsItem.setEnabled(true);
            this.commGrafItem.setEnabled(true);
            this.zoomButton.setEnabled(true);
            this.walkButton.setEnabled(true);
            this.validate();
            this.outParamsPanel.showOutParamsCommunities(true);
        }
    }

    public void setZoomEnable(boolean b) {
        this.zoomButton.setEnabled(b);
    }

    public void setBackAndForward(boolean b, boolean f) {
        this.backButton.setEnabled(b);
        this.forwardButton.setEnabled(f);
    }

    public void setZoomAndWalk(boolean b, boolean c) {
        this.walkButton.setEnabled(c);
        this.zoomButton.setEnabled(b);
    }

    public void setZoomAndWalkText(String z, String w) {
        this.zoomButton.setText(z);
        this.walkButton.setText(w);
    }

    public void setCaptureButton(boolean b) {
        this.exportButton.setEnabled(b);
        this.captureItem.setEnabled(b);
    }

    public void setStatButtons(boolean b) {
        if (b) {
            this.toolBar.add(this.cumulativeButton);
            this.cumulativeButton.setSelected(Parameters.IS_CUMULATIVE);
            this.toolBar.add(this.loglogButton);
            this.loglogButton.setSelected(Parameters.IS_LOGLOG);
            if (Parameters.IS_CUMULATIVE.booleanValue()) {
                this.loglogButton.setEnabled(true);
            } else {
                this.loglogButton.setEnabled(false);
            }
        } else {
            this.toolBar.remove(this.loglogButton);
            this.toolBar.remove(this.cumulativeButton);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        GraphLayout.IS_STOP = true;
        if (arg0.getSource().equals(this.newItem) || arg0.getSource().equals(this.openNewButton)) {
            new FindingFrame(this).setVisible(true);
        }
        if (arg0.getSource().equals(this.openInItem) || arg0.getSource().equals(this.openDirButton)) {
            String outDir = null;
            if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                FileDialog f = new FileDialog((Frame)this, "select file", 0);
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                f.show();
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
                String dir = f.getDirectory();
                String file = f.getFile();
                outDir = dir == null || file == null ? null : dir + file;
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(this.lastPath));
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    outDir = chooser.getSelectedFile().getPath();
                }
            }
            if (outDir != null) {
                this.runLoad(outDir);
            }
        }
        if (arg0.getSource().equals(this.exitItem)) {
            this.setVisible(false);
            System.exit(0);
        }
        if (arg0.getSource().equals(this.verticesItem)) {
            this.outParamsPanel.showInParams(true);
            this.setZoomAndWalk(true, true);
        }
        if (arg0.getSource().equals(this.communitiesItem)) {
            this.outParamsPanel.showOutParamsCommunities(true);
            this.setZoomAndWalk(false, true);
        }
        if (arg0.getSource().equals(this.cliquesItem)) {
            this.outParamsPanel.showOutParamsCliques(true);
            this.setZoomAndWalk(false, false);
        }
        if (arg0.getSource().equals(this.statsItem)) {
            this.outParamsPanel.showOutParamsStats(true);
            this.setZoomAndWalk(false, false);
        }
        if (arg0.getSource().equals(this.commGrafItem)) {
            this.outParamsPanel.showOutParamsCommunityGraf(true);
            this.setZoomAndWalk(true, true);
        }
        if (arg0.getSource().equals(this.zoomButton)) {
            this.outParamsPanel.zoomInCommunities();
        }
        if (arg0.getSource().equals(this.walkButton)) {
            this.outParamsPanel.walkOnCommunities();
        }
        if (arg0.getSource().equals(this.backButton)) {
            this.outParamsPanel.back();
        }
        if (arg0.getSource().equals(this.forwardButton)) {
            this.outParamsPanel.forward();
        }
        if (arg0.getSource().equals(this.loglogButton)) {
            Parameters.IS_LOGLOG = new Boolean(this.loglogButton.isSelected());
            this.outParamsPanel.repaintStats();
        }
        if (arg0.getSource().equals(this.cumulativeButton)) {
            Parameters.IS_CUMULATIVE = new Boolean(this.cumulativeButton.isSelected());
            if (Parameters.IS_CUMULATIVE.booleanValue()) {
                this.loglogButton.setEnabled(true);
            } else {
                this.loglogButton.setEnabled(false);
            }
            this.outParamsPanel.repaintStats();
        }
        if (arg0.getSource().equals(this.captureItem) || arg0.getSource().equals(this.exportButton)) {
            this.outParamsPanel.capture();
            this.status("export done!");
        }
        if (arg0.getSource().equals(this.stopItem) || arg0.getSource().equals(this.stopButton)) {
            GraphLayout.IS_STOP = true;
            this.outParamsPanel.stopContinousLayout();
        }
        if (arg0.getSource().equals(this.settingsItem)) {
            this.settingsDialog.setVisible(true);
        }
        if (arg0.getSource().equals(this.showPefusePanel) && this.notIntroPanel) {
            this.outParamsPanel.showPrefusePanel(true);
        }
        if (arg0.getSource().equals(this.aboutItem)) {
            new InfoDialog("<html><h2>CFinder</h2>The Cluster (Community) Finding Program<br>Copyright &copy;, Department of Biological Physics, E&ouml;tv&ouml;s University<br><a href=\"http://cfinder.org\">http://cfinder.org</a></html>").setVisible(true);
        }
    }

    public void runLoad(String outDir) {
        this.waitCursor();
        this.lastPath = outDir.substring(0, outDir.lastIndexOf(File.separator));
        if (outDir.indexOf("_files") == -1) {
            this.showWarningDialog("<html><center>You must select a directory that is generated by CFinder. If you have not run CFinder yet for any input file please, go to File->New, then Browse and select an input file, then Run.</center></html>");
        } else {
            String inFile = outDir.substring(0, outDir.lastIndexOf("_files"));
            File dir = new File(inFile);
            if (!dir.exists()) {
                this.showWarningDialog("<html><center>Input file, which contains the edges is not found for the selected output directory.</center></html>");
            } else {
                new LoadingProgressFrame(this, outDir).setVisible(true);
            }
        }
        this.defaultCursor();
    }

    public void waitCursor() {
        this.getContentPane().setCursor(new Cursor(3));
    }

    public void defaultCursor() {
        this.getContentPane().setCursor(new Cursor(0));
    }

    public void status(String s) {
        this.statusBar.setAutoscrolls(true);
        this.timer.setText(s);
    }

    public void introCallback(int i) {
        if (i == IntroIcon.NEW_ICON) {
            this.actionPerformed(new ActionEvent(this.newItem, 0, ""));
        }
        if (i == IntroIcon.OPEN_ICON) {
            this.actionPerformed(new ActionEvent(this.openInItem, 0, ""));
        }
    }

    public void showWarningDialog(String s) {
        WarningDialog wd = new WarningDialog(s);
        wd.setVisible(true);
    }

    public static void main(String[] args) {
        ExternalCalls externalCalls = new ExternalCalls("commfind");
        MainFrame m = new MainFrame();
        m.setVisible(true);
        externalCalls.checkLicence(true);
    }
}

