/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Clique;
import elte.community.Community;
import elte.community.Edge;
import elte.community.InParams;
import elte.community.OutParams;
import elte.community.VertexWithCommunity;
import elte.community.visual.CommunitiesPanel;
import elte.community.visual.CommunityGrafPanel;
import elte.community.visual.History;
import elte.community.visual.LabelPanel;
import elte.community.visual.ListWithLabel;
import elte.community.visual.MainFrame;
import elte.community.visual.MyTreeCellRenderer;
import elte.community.visual.MyTreeNode;
import elte.community.visual.PrefuseSettingsWindow;
import elte.community.visual.StatsPanel;
import elte.community.visual.Text;
import elte.community.visual.VisualJPanel;
import elte.community.visual.graph.GraphLayout;
import elte.community.visual.settings.Parameters;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class OutParamsPanel
extends JSplitPane
implements TreeExpansionListener,
TreeSelectionListener,
ListSelectionListener {
    private OutParams outParams;
    private InParams inParams;
    private CommunitiesPanel commPanel;
    private CommunityGrafPanel commGrafPanel;
    private PrefuseSettingsWindow prefuseSettings;
    private StatsPanel statsPanel;
    private Hashtable visualPanels = new Hashtable();
    private JTree treeCommunity;
    private Hashtable pathForCommunity;
    private JTree treeClique;
    private JTree treeCliqueSize;
    private ListWithLabel list;
    private ListWithLabel keyList;
    public static int COMMUNITIES_PANEL = 0;
    public static int COMMUNITYGRAF_PANEL = 1;
    public static int STATS_PANEL = 2;
    private MainFrame main;
    private History history;
    private boolean rememberPrevious;
    private int view;
    private Border selection;
    private Border selected;
    private int currentRightComponent;

    public OutParamsPanel(MainFrame mf) {
        this.main = mf;
        this.setOrientation(1);
        this.setDividerLocation(100);
        this.setOneTouchExpandable(true);
        this.setLeftComponent(null);
        this.setRightComponent(null);
        try {
            Parameters.loadFromFile();
        }
        catch (IOException e) {
            System.out.println("No parameters are loaded from parameter file.");
        }
        this.commPanel = new CommunitiesPanel(this.main);
        this.commGrafPanel = new CommunityGrafPanel(this.main);
        this.commGrafPanel.setMinimumSize(new Dimension(100, 100));
        this.statsPanel = new StatsPanel();
        this.prefuseSettings = new PrefuseSettingsWindow(this.commGrafPanel, this.commPanel);
        this.visualPanels.put(new Integer(COMMUNITIES_PANEL), this.commPanel);
        this.visualPanels.put(new Integer(COMMUNITYGRAF_PANEL), this.commGrafPanel);
        this.visualPanels.put(new Integer(STATS_PANEL), this.statsPanel);
        this.selection = BorderFactory.createMatteBorder(3, 3, 3, 3, Parameters.SELECTION_COLOR);
        this.selected = BorderFactory.createMatteBorder(3, 3, 3, 3, Parameters.BORDER_COLOR);
    }

    public void setVisualJPanel(int i) {
        if (i == COMMUNITIES_PANEL) {
            this.prefuseSettings.setWidgets(this.commPanel);
        } else if (i == COMMUNITYGRAF_PANEL) {
            this.prefuseSettings.setWidgets(this.commGrafPanel);
        }
        if (i == STATS_PANEL) {
            this.showPrefusePanel(false);
        }
        this.currentRightComponent = i;
        this.setRightComponent((Component)this.visualPanels.get(new Integer(i)));
    }

    public void setInParams(InParams ip) {
        this.inParams = ip;
    }

    public void repaintGraphs(Community c) {
        if (this.main.notIntroPanel) {
            this.commGrafPanel.repaintGraph(c);
            this.commPanel.repaintGraph(c);
        }
    }

    public void repaintStats() {
        this.valueChanged(new TreeSelectionEvent(new Object(), new TreePath(new Object()), false, new TreePath(new Object()), new TreePath(new Object())));
    }

    public Community getTabbedCommunity() {
        LabelPanel lp = (LabelPanel)this.commPanel.tabbedPanel.getSelectedComponent();
        if (lp != null) {
            return lp.getCommunity();
        }
        return null;
    }

    public void zoomInCommunities() {
        if (((VisualJPanel)((Object)this.getRightComponent())).equals(this.visualPanels.get(new Integer(COMMUNITYGRAF_PANEL)))) {
            this.commPanel.setNew(this.outParams);
            Vector v = this.commGrafPanel.getSelectedCommunities();
            if (v.size() <= 0) {
                this.main.status(Text.ZOOM_SELECT_SOMETHING);
            } else {
                this.showOutParamsCommunities(true);
                this.selectCommunitiesOnTree(v);
            }
        } else if (((VisualJPanel)((Object)this.getRightComponent())).equals(this.visualPanels.get(new Integer(COMMUNITIES_PANEL)))) {
            LabelPanel lp = (LabelPanel)this.commPanel.tabbedPanel.getSelectedComponent();
            if (lp == null) {
                this.main.status(Text.ZOOM_NO_SELECT);
            } else {
                Community c = lp.getCommunity();
                Vector<Community> cv = new Vector<Community>();
                cv.add(c);
                this.showOutParamsCommunityGraf(true);
                this.selectCommunitiesOnTree(cv);
            }
        }
    }

    public void walkOnCommunities() {
        if (((VisualJPanel)((Object)this.getRightComponent())).equals(this.visualPanels.get(new Integer(COMMUNITYGRAF_PANEL)))) {
            Vector v = this.commGrafPanel.getSelectedCommunities();
            if (v.size() > 1) {
                this.main.status(Text.WALK_SELECT_ONLY_ONE_C);
            } else if (v.size() == 0) {
                this.main.status(Text.WALK_SELECT_C);
            } else {
                this.showOutParamsCommunityGraf(true);
                this.selectCommunitiesOnTree(v);
            }
        } else if (((VisualJPanel)((Object)this.getRightComponent())).equals(this.visualPanels.get(new Integer(COMMUNITIES_PANEL)))) {
            TreeSet node = this.commPanel.getSelectedNodes();
            if (node != null && node.size() > 0) {
                if (node.size() > 1) {
                    this.main.status(Text.WALK_SELECT_ONLY_ONE_V);
                } else {
                    int key = 0;
                    LabelPanel lp = (LabelPanel)this.commPanel.tabbedPanel.getSelectedComponent();
                    Vector tmp = this.outParams.getCommunityForVertex((String)node.first());
                    Vector<Community> communities = new Vector<Community>();
                    if (tmp != null) {
                        Iterator i = tmp.iterator();
                        while (i.hasNext()) {
                            Community c = (Community)i.next();
                            if (c.getSize() != lp.getCommunity().getSize()) continue;
                            communities.add(c);
                            key = c.getSize();
                        }
                        this.showInParams(true);
                        this.selectVertexAndKey((String)node.first(), new Integer(key));
                    }
                }
            } else {
                this.main.status(Text.WALK_SELECT_V);
            }
        }
    }

    public void selectVertexAndKey(String vertex, Integer key) {
        Object ss;
        int j;
        ListModel lm = this.list.list.getModel();
        for (j = 0; j < lm.getSize(); ++j) {
            ss = (VertexWithCommunity)lm.getElementAt(j);
            if (!((VertexWithCommunity)ss).getVertex().equals(vertex)) continue;
            this.list.list.setSelectedValue(ss, true);
            this.list.list.ensureIndexIsVisible(this.list.list.getSelectedIndex() + 2);
        }
        this.valueChanged(new ListSelectionEvent(new Object(), 0, 0, false));
        lm = this.keyList.list.getModel();
        for (j = 0; j < lm.getSize(); ++j) {
            ss = (String)lm.getElementAt(j);
            String s = ((String)ss).substring(((String)ss).indexOf("=") + 1, ((String)ss).indexOf("(") - 1);
            if (!Integer.valueOf(s).equals(key)) continue;
            this.keyList.list.setSelectedValue(ss, true);
        }
    }

    public Object[] getSelectedVertexAndKey() {
        String node = this.selectNode();
        String key = (String)this.keyList.list.getSelectedValue();
        Integer i = null;
        if (key != null) {
            String s = key.substring(key.indexOf("=") + 1, key.indexOf("(") - 1);
            i = Integer.valueOf(s);
        }
        return new Object[]{node, i};
    }

    public void selectCliqueAndKey(TreePath[] cliques, Integer key) {
        this.treeClique.setSelectionPaths(cliques);
        ListModel lm = this.keyList.list.getModel();
        for (int j = 0; j < lm.getSize(); ++j) {
            String ss = (String)lm.getElementAt(j);
            String s = ss.substring(ss.indexOf("=") + 1, ss.indexOf("(") - 1);
            if (!Integer.valueOf(s).equals(key)) continue;
            this.keyList.list.setSelectedValue(ss, true);
        }
    }

    public Object[] getSelectedCliqueAndKey() {
        String key = (String)this.keyList.list.getSelectedValue();
        Integer i = null;
        if (key != null) {
            String s = key.substring(key.indexOf("=") + 1, key.indexOf("(") - 1);
            i = Integer.valueOf(s);
        }
        return new Object[]{this.treeClique.getSelectionPaths(), i};
    }

    private void remember() {
        this.history.addElementToHistory(this.getState());
        this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
    }

    private Object[] getState() {
        Object[] state = null;
        if (this.view == History.VERTICES_VIEW) {
            state = this.getSelectedVertexAndKey();
        }
        if (this.view == History.CLIQUES_VIEW) {
            state = this.getSelectedCliqueAndKey();
        }
        if (this.view == History.COMMUNITIES_VIEW) {
            state = this.getSelectedPath();
        }
        if (this.view == History.COMMGRAPH_VIEW) {
            state = this.getSelectedPath();
        }
        if (this.view == History.STATS_VIEW) {
            // empty if block
        }
        return new Object[]{new Integer(this.view), state};
    }

    private void changePreviousInHistory() {
        if (this.view == History.VERTICES_VIEW) {
            this.history.changePreviousElement(this.getSelectedVertexAndKey());
        }
        if (this.view == History.CLIQUES_VIEW) {
            this.history.changePreviousElement(this.getSelectedCliqueAndKey());
        }
        if (this.view == History.COMMUNITIES_VIEW) {
            this.history.changePreviousElement(this.getSelectedPath());
        }
        if (this.view == History.COMMGRAPH_VIEW) {
            this.history.changePreviousElement(this.getSelectedPath());
        }
        if (this.view == History.STATS_VIEW) {
            this.history.changePreviousElement(null);
        }
    }

    public void back() {
        if (this.rememberPrevious) {
            this.remember();
        }
        this.rememberPrevious = false;
        this.history.back();
        this.showHistory();
    }

    public void forward() {
        this.history.forward();
        this.showHistory();
    }

    private void reshowCurrent() {
        Object[] state = this.getState();
        this.showState(state);
    }

    private void showHistory() {
        Object[] o = this.history.getPreviousElement();
        this.showState(o);
    }

    private void showState(Object[] o) {
        int i = (Integer)o[0];
        if (i == History.VERTICES_VIEW) {
            this.showInParams(false);
            if (o.length > 1 && o[1] != null && ((Object[])o[1]).length > 1 && ((Object[])o[1])[0] != null) {
                this.selectVertexAndKey((String)((Object[])o[1])[0], (Integer)((Object[])o[1])[1]);
            }
        }
        if (i == History.COMMUNITIES_VIEW) {
            this.showOutParamsCommunities(false);
            if (o[1] != null) {
                this.setSelectedPath((TreePath[])o[1]);
            }
        }
        if (i == History.COMMGRAPH_VIEW) {
            this.showOutParamsCommunityGraf(false);
            if (o[1] != null) {
                this.setSelectedPath((TreePath[])o[1]);
            }
        }
        if (i == History.STATS_VIEW) {
            this.showOutParamsStats(false);
        }
        if (i == History.CLIQUES_VIEW) {
            this.showOutParamsCliques(false);
            if (o.length > 1 && o[1] != null && ((Object[])o[1]).length > 1 && ((Object[])o[1])[0] != null) {
                this.selectCliqueAndKey((TreePath[])((Object[])o[1])[0], (Integer)((Object[])o[1])[1]);
            }
        }
        this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        this.validate();
    }

    public void setVertexList() {
        this.list = new ListWithLabel(new JList(), "Vertices (# of comm.s)", 0, true);
        this.list.addListSelectionListener(this);
        Vector<VertexWithCommunity> verticesWithCommunitiesNumber = new Vector<VertexWithCommunity>();
        Iterator i = this.inParams.getVertices().iterator();
        while (i.hasNext()) {
            String vertex = (String)i.next();
            int size = 0;
            Vector v = this.outParams.getCommunityForVertex(vertex);
            if (v != null) {
                size = v.size();
            }
            verticesWithCommunitiesNumber.add(new VertexWithCommunity(size, vertex));
        }
        this.list.setListData(verticesWithCommunitiesNumber);
    }

    public void setCliqueSizeList() {
        this.keyList = new ListWithLabel(new JList(), "k - clique sizes (# of comm.s)", 0, false);
        this.keyList.addListSelectionListener(this);
    }

    public void setCommunityTree() {
        this.pathForCommunity = new Hashtable();
        MyTreeNode root = new MyTreeNode();
        Hashtable communities = this.outParams.getCommunities();
        Enumeration e = communities.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            MyTreeNode keyNode = new MyTreeNode("k=" + key);
            int cCount = 0;
            Iterator i = ((Vector)communities.get(key)).iterator();
            while (i.hasNext()) {
                Community comm = (Community)i.next();
                MyTreeNode community = new MyTreeNode(new Integer(comm.getIndex()) + ". community (" + comm.getVertices().size() + ")", comm.approximated);
                keyNode.add(community);
                ++cCount;
                this.pathForCommunity.put(comm, new TreePath(new Object[]{root, keyNode, community}));
            }
            root.add(keyNode);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.treeCommunity = new JTree(treeModel);
        this.treeCommunity.addTreeExpansionListener(this);
        this.treeCommunity.addTreeSelectionListener(this);
        this.treeCommunity.setCellRenderer(new MyTreeCellRenderer());
    }

    public void setCliqueTree() {
        MyTreeNode root = new MyTreeNode();
        MyTreeNode cliques = new MyTreeNode("Cliques");
        root.add(cliques);
        int cCount = 0;
        Iterator i = this.outParams.getCliques().iterator();
        while (i.hasNext()) {
            Clique c = (Clique)i.next();
            Iterator j = c.getVertices().iterator();
            MyTreeNode clique = new MyTreeNode(new Integer(cCount) + ". clique", c.approximated);
            while (j.hasNext()) {
                clique.add(new MyTreeNode(j.next()));
            }
            cliques.add(clique);
            ++cCount;
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.treeClique = new JTree(treeModel);
        this.treeClique.addTreeExpansionListener(this);
        this.treeClique.addTreeSelectionListener(this);
        this.treeClique.setCellRenderer(new MyTreeCellRenderer());
    }

    public void setCliqueSizeTree() {
        MyTreeNode root = new MyTreeNode();
        Hashtable communities = this.outParams.getCommunities();
        Enumeration e = communities.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            MyTreeNode keyNode = new MyTreeNode("k=" + key);
            root.add(keyNode);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.treeCliqueSize = new JTree(treeModel);
        this.treeCliqueSize.addTreeExpansionListener(this);
        this.treeCliqueSize.addTreeSelectionListener(this);
        this.treeCliqueSize.setCellRenderer(new MyTreeCellRenderer());
    }

    public void setOutParams(OutParams op) {
        this.outParams = op;
        this.commPanel.setNew(op);
        this.commGrafPanel.setNew(op);
        this.statsPanel.setNew(op);
        this.setVertexList();
        this.setCliqueSizeList();
        this.setCommunityTree();
        this.setCliqueTree();
        this.setCliqueSizeTree();
        this.history = new History();
    }

    public void showInParams(boolean remember) {
        if (remember) {
            this.history.clearHistoryAboveCurrent();
            this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        }
        if (this.rememberPrevious) {
            this.remember();
        }
        this.view = History.VERTICES_VIEW;
        this.rememberPrevious = remember;
        this.main.setCaptureButton(false);
        this.main.setStatButtons(false);
        this.main.setZoomAndWalkText(Text.ZOOM_VERTICES, Text.WALK_COMMUNITIES);
        this.main.setZoomEnable(true);
        this.main.verticesItem.setSelected(true);
        this.setVisualJPanel(COMMUNITIES_PANEL);
        ((VisualJPanel)((Object)this.getRightComponent())).setNew(this.outParams);
        JSplitPane left = new JSplitPane();
        left.setOrientation(0);
        left.setBottomComponent(this.list);
        left.setTopComponent(this.keyList);
        left.setMinimumSize(new Dimension(100, 200));
        left.setDividerLocation(100);
        this.setLeftComponent(left);
        this.setDividerLocation(150);
        if (remember) {
            this.list.list.setSelectedIndex(0);
            this.main.status(Text.VERTICES_START);
        }
        this.keyList.setBorder(null);
        this.commPanel.setBorder(null);
        this.list.setBorder(this.selection);
        this.validate();
    }

    public void showOutParamsCliques(boolean remember) {
        if (remember) {
            this.history.clearHistoryAboveCurrent();
            this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        }
        if (this.rememberPrevious) {
            this.remember();
        }
        this.view = History.CLIQUES_VIEW;
        this.rememberPrevious = remember;
        this.main.setCaptureButton(false);
        this.main.setZoomAndWalk(false, false);
        this.main.setZoomAndWalkText("", "");
        this.main.setStatButtons(false);
        this.setVisualJPanel(COMMUNITIES_PANEL);
        ((VisualJPanel)((Object)this.getRightComponent())).setNew(this.outParams);
        JSplitPane left = new JSplitPane();
        left.setOrientation(0);
        left.setBottomComponent(new JScrollPane(this.treeClique));
        left.setTopComponent(this.keyList);
        left.setMinimumSize(new Dimension(100, 200));
        left.setDividerLocation(100);
        this.setLeftComponent(left);
        this.setDividerLocation(150);
        this.treeClique.setSelectionPath(new TreePath(new Object()));
        this.main.status(Text.CLIQUES);
        this.keyList.setBorder(null);
        this.commPanel.setBorder(null);
        this.treeClique.setBorder(this.selection);
        this.validate();
    }

    public void showOutParamsStats(boolean remember) {
        if (remember) {
            this.history.clearHistoryAboveCurrent();
            this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        }
        if (this.rememberPrevious) {
            this.remember();
        }
        this.view = History.STATS_VIEW;
        this.rememberPrevious = remember;
        this.main.setCaptureButton(false);
        this.main.setStatButtons(true);
        this.main.status(Text.STATS);
        this.main.setZoomAndWalk(false, false);
        this.main.setZoomAndWalkText("", "");
        this.setVisualJPanel(STATS_PANEL);
        ((VisualJPanel)((Object)this.getRightComponent())).setNew(this.outParams);
        JScrollPane left = new JScrollPane(this.treeCliqueSize);
        left.setMinimumSize(new Dimension(200, 200));
        this.setLeftComponent(left);
        this.validate();
    }

    public void selectCommunitiesOnTree(Vector v) {
        TreePath[] tps = new TreePath[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            TreePath tp;
            tps[i] = tp = (TreePath)this.pathForCommunity.get((Community)v.get(i));
        }
        this.treeCommunity.setSelectionPaths(tps);
        this.treeCommunity.scrollPathToVisible(tps[0]);
    }

    public TreePath[] getSelectedPath() {
        return this.treeCommunity.getSelectionPaths();
    }

    public void setSelectedPath(TreePath[] tp) {
        this.treeCommunity.setSelectionPaths(tp);
    }

    private void showCommunitiesOnLeftPanel() {
        JScrollPane left = new JScrollPane(this.treeCommunity);
        left.setMinimumSize(new Dimension(150, 200));
        this.setLeftComponent(left);
        this.valueChanged(new TreeSelectionEvent(new Object(), new TreePath(""), false, new TreePath(""), new TreePath("")));
        this.commPanel.setBorder(null);
        this.commGrafPanel.setBorder(null);
        this.treeCommunity.setBorder(this.selection);
        this.validate();
    }

    public void showOutParamsCommunityGraf(boolean remember) {
        if (remember) {
            this.history.clearHistoryAboveCurrent();
            this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        }
        if (this.rememberPrevious) {
            this.remember();
        }
        this.view = History.COMMGRAPH_VIEW;
        this.rememberPrevious = remember;
        this.main.setCaptureButton(false);
        this.main.setStatButtons(false);
        this.main.status(Text.COMMUNITIES_SELECT_COMMUNITY);
        this.main.setZoomAndWalkText(Text.ZOOM_COMMUNITYGRAPH, Text.WALK_COMMUNITYGRAPH);
        this.setVisualJPanel(COMMUNITYGRAF_PANEL);
        this.main.setZoomAndWalk(false, false);
        this.main.commGrafItem.setSelected(true);
        this.showCommunitiesOnLeftPanel();
    }

    public void showOutParamsCommunities(boolean remember) {
        if (remember) {
            this.history.clearHistoryAboveCurrent();
            this.main.setBackAndForward(this.history.getBack(), this.history.getForward());
        }
        if (this.rememberPrevious) {
            this.remember();
        }
        this.view = History.COMMUNITIES_VIEW;
        this.rememberPrevious = remember;
        this.main.setCaptureButton(false);
        this.main.setStatButtons(false);
        this.main.status(Text.COMMUNITIES_SELECT_COMMUNITY);
        this.main.setZoomAndWalkText(Text.ZOOM_VERTICES, Text.WALK_COMMUNITIES);
        this.setVisualJPanel(COMMUNITIES_PANEL);
        this.main.setZoomAndWalk(false, false);
        this.main.communitiesItem.setSelected(true);
        this.showCommunitiesOnLeftPanel();
    }

    public void treeCollapsed(TreeExpansionEvent arg0) {
        this.validate();
    }

    public void treeExpanded(TreeExpansionEvent arg0) {
        this.validate();
    }

    private Vector selectCommunitiesByKeyOrFillKeyList(String key, Vector tmp, EventObject arg0) {
        Vector<Community> selectedCommunities = new Vector<Community>();
        if (tmp != null && key != null && arg0.getSource().equals(this.keyList.list)) {
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                Community c = (Community)i.next();
                String s = key.substring(key.indexOf("=") + 1, key.indexOf("(") - 1);
                if (c.getSize() != Integer.valueOf(s).intValue()) continue;
                selectedCommunities.add(c);
            }
            this.main.status(Text.COMMUNITIES_SELECT);
            this.commPanel.setBorder(this.selection);
            this.keyList.setBorder(this.selected);
        } else if (tmp != null && key == null) {
            Hashtable<Integer, Integer> communityHash = new Hashtable<Integer, Integer>();
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                Community c = (Community)i.next();
                Integer size = new Integer(c.getSize());
                if (communityHash.containsKey(size)) {
                    Integer numOfComms = (Integer)communityHash.get(size);
                    communityHash.remove(size);
                    communityHash.put(size, new Integer(numOfComms + 1));
                    continue;
                }
                communityHash.put(size, new Integer(1));
            }
            Vector<String> listData = new Vector<String>();
            Enumeration e = communityHash.keys();
            while (e.hasMoreElements()) {
                Integer size = (Integer)e.nextElement();
                listData.add("k=" + size + " (" + communityHash.get(size) + ")");
            }
            this.keyList.setListData(listData);
            this.main.status(Text.VERTICES_SELECT_K);
            this.keyList.setBorder(this.selection);
            this.list.setBorder(this.selected);
            this.treeClique.setBorder(this.selected);
            this.commPanel.setBorder(null);
        } else {
            this.keyList.setListData(new Vector());
            if (this.view == History.CLIQUES_VIEW) {
                this.main.status(Text.CLIQUES_NO);
            }
            if (this.view == History.VERTICES_VIEW) {
                this.main.status(Text.VERTICES_NO);
            }
            this.keyList.setBorder(null);
            this.list.setBorder(this.selection);
            this.treeClique.setBorder(this.selection);
            this.commPanel.setBorder(null);
        }
        return selectedCommunities;
    }

    public Clique selectClique() {
        TreePath[] tps = this.treeClique.getSelectionPaths();
        TreePath tp = null;
        if (tps != null && tps.length > 0) {
            Vector<Clique> selectedCliques = new Vector<Clique>();
            for (int k = 0; k < tps.length; ++k) {
                tp = tps[k];
                Object[] path = tp.getPath();
                if (path == null || path.length <= 1 || !path[1].toString().equals("Cliques") || path.length <= 2) continue;
                int i = Integer.valueOf(path[2].toString().substring(0, path[2].toString().indexOf(".")));
                Clique c = (Clique)this.outParams.getCliques().get(i);
                selectedCliques.add(c);
            }
            if (selectedCliques.size() > 0) {
                return (Clique)selectedCliques.get(0);
            }
        }
        return null;
    }

    public String selectNode() {
        VertexWithCommunity node = (VertexWithCommunity)this.list.list.getSelectedValue();
        if (node != null) {
            return node.getVertex();
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent arg0) {
        GraphLayout.IS_STOP = true;
        this.main.setCaptureButton(false);
        this.main.setZoomAndWalk(false, false);
        if (this.getRightComponent() != null && this.outParams != null) {
            Clique cl;
            if (!this.rememberPrevious) {
                this.changePreviousInHistory();
            }
            ((VisualJPanel)((Object)this.getRightComponent())).setNew(this.outParams);
            String key = (String)this.keyList.list.getSelectedValue();
            Vector tmp = null;
            if (this.view == History.CLIQUES_VIEW && (cl = this.selectClique()) != null) {
                tmp = this.outParams.getCommunityForClique(cl);
            }
            this.selectCommunitiesByKeyOrFillKeyList(key, tmp, arg0);
            TreePath[] tps = this.treeCliqueSize.getSelectionPaths();
            TreePath tp = null;
            if (tps != null && tps.length > 0) {
                Vector<Integer> selectedKeys = new Vector<Integer>();
                for (int k = 0; k < tps.length; ++k) {
                    String s;
                    tp = tps[k];
                    Object[] path = tp.getPath();
                    if (path == null || path.length <= 1 || !(s = path[1].toString()).startsWith("k=")) continue;
                    Integer keyi = Integer.valueOf(s.substring(s.indexOf("=") + 1));
                    selectedKeys.add(keyi);
                }
                if (selectedKeys.size() > 0) {
                    ((VisualJPanel)((Object)this.getRightComponent())).setKeys(selectedKeys);
                }
            }
            tps = this.treeCommunity.getSelectionPaths();
            tp = null;
            if (tps != null && tps.length > 0 && (this.view == History.COMMUNITIES_VIEW || this.view == History.COMMGRAPH_VIEW)) {
                Vector<Community> selectedCommunities = new Vector<Community>();
                Vector<Integer> selectedKeys = new Vector<Integer>();
                Community dummyEdges = new Community();
                String dummyVertex1 = null;
                String dummyVertex2 = null;
                boolean dummyVertexSet = false;
                for (int k = 0; k < tps.length; ++k) {
                    String s;
                    tp = tps[k];
                    Object[] path = tp.getPath();
                    if (path == null || path.length <= 1 || !(s = path[1].toString()).startsWith("k=")) continue;
                    Integer keyi = Integer.valueOf(s.substring(s.indexOf("=") + 1));
                    selectedKeys.add(keyi);
                    if (path.length <= 2) continue;
                    int i = Integer.valueOf(path[2].toString().substring(0, path[2].toString().indexOf(".")));
                    Community c = (Community)((Vector)this.outParams.getCommunities().get(keyi)).get(i);
                    selectedCommunities.add(c);
                    if (!dummyVertexSet) {
                        dummyVertex1 = (String)c.getVertices().toArray()[0];
                        dummyVertexSet = true;
                        continue;
                    }
                    dummyVertex2 = (String)c.getVertices().toArray()[0];
                    dummyEdges.addEdge(new Edge(dummyVertex1, dummyVertex2));
                }
                if (selectedCommunities.size() > 0) {
                    ((VisualJPanel)((Object)this.getRightComponent())).setCommunities(selectedCommunities);
                    this.getParent().getParent().setCursor(Cursor.getPredefinedCursor(0));
                    if (((VisualJPanel)((Object)this.getRightComponent())).equals(this.visualPanels.get(new Integer(COMMUNITIES_PANEL)))) {
                        this.commPanel.setDummyEdges(dummyEdges, null);
                        this.main.status(Text.COMMUNITIES_SELECT);
                        this.commPanel.setBorder(this.selection);
                        this.treeCommunity.setBorder(this.selected);
                    }
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        GraphLayout.IS_STOP = true;
        this.main.setCaptureButton(false);
        this.main.setZoomAndWalk(false, false);
        if (this.getRightComponent() != null && this.outParams != null) {
            Vector selectedCommunities;
            Clique clique;
            if (!this.rememberPrevious) {
                this.changePreviousInHistory();
            }
            String key = (String)this.keyList.list.getSelectedValue();
            Vector tmp = null;
            String node = null;
            if (this.view == History.VERTICES_VIEW && (node = this.selectNode()) != null) {
                tmp = this.outParams.getCommunityForVertex(node);
            }
            if (this.view == History.CLIQUES_VIEW && (clique = this.selectClique()) != null) {
                tmp = this.outParams.getCommunityForClique(clique);
                node = (String)clique.getVertices().get(0);
            }
            if ((selectedCommunities = this.selectCommunitiesByKeyOrFillKeyList(key, tmp, arg0)).size() > 0) {
                ((VisualJPanel)((Object)this.getRightComponent())).setCommunities(selectedCommunities);
                this.commPanel.setDummyEdges(new Community(), node);
                ((VisualJPanel)((Object)this.getRightComponent())).setSelectedVertices(new Object[]{node});
            } else {
                ((VisualJPanel)((Object)this.getRightComponent())).setNew(this.outParams);
            }
        }
    }

    public void capture() {
        if (this.view == History.COMMGRAPH_VIEW) {
            this.commGrafPanel.capture();
        } else {
            this.commPanel.capture();
        }
    }

    public void maybeWidgetChange() {
        boolean change1 = this.commGrafPanel.maybeWidgetChange();
        boolean change2 = this.commPanel.maybeWidgetChange();
        if ((change1 || change2) && this.main.notIntroPanel) {
            this.reshowCurrent();
        }
    }

    public void showPrefusePanel(boolean b) {
        this.prefuseSettings.setVisible(b);
    }

    public void stopContinousLayout() {
        this.commGrafPanel.stopContinousLayout();
        this.commPanel.stopContinousLayout();
    }
}

