/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.Community;
import elte.community.Edge;
import elte.community.visual.AggregateDragControl;
import elte.community.visual.AggregateLayout;
import elte.community.visual.ForceDirectedLayoutMagic;
import elte.community.visual.LabelLayout;
import elte.community.visual.RepaintOnEventControl;
import elte.community.visual.ZoomtoFitAction;
import elte.community.visual.settings.Parameters;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.PanControl;
import prefuse.controls.ToolTipControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.PolygonRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.PrefuseLib;
import prefuse.util.display.DebugStatsPainter;
import prefuse.util.display.DisplayLib;
import prefuse.util.display.ItemBoundsListener;
import prefuse.util.display.PaintListener;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JForcePanel;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class PrefuseWidget
extends JPanel {
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    private static final String AGGR = "aggregates";
    public static final String EDGE_DECORATORS = "edgeDeco";
    public static final String NODE_DECORATORS = "nodeDeco";
    private static final String RUBBER_BAND = "rubberband";
    private static final Schema DECORATOR_SCHEMA = PrefuseLib.getVisualItemSchema();
    private static final String hover = "hover";
    private static final String selected = "selected";
    private Visualization m_vis;
    public boolean continousLayout = true;
    private Graph graphStructure;
    private AggregateTable aggregateTable;
    private MyRendererFactory rendererFactory;
    private HashMap stringToPrefuseNode;
    private HashMap commsToPrefuseAggr = new HashMap();
    private DataColorAction nodeColorAction;
    private DataColorAction aggrColorAction;
    private DataColorAction nodeLabelColorAction;
    protected JCheckBox offNodeLabelChkBox;
    public final Display display;
    private JCheckBox layoutChkBox = new JCheckBox("run continous layout");
    public JForcePanel jForcePanel;

    public PrefuseWidget() {
        String label = "label";
        this.graphStructure = new Graph(true);
        this.graphStructure.addColumn("label", String.class);
        this.graphStructure.addColumn("id", String.class);
        this.graphStructure.addColumn("colorid", Integer.class);
        this.graphStructure.addColumn("weight", Integer.class);
        this.m_vis = new Visualization();
        this.aggregateTable = this.m_vis.addAggregates(AGGR);
        this.aggregateTable.addColumn(VisualItem.POLYGON, [F.class);
        this.aggregateTable.addColumn("colorid", Integer.class);
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.rendererFactory = new MyRendererFactory(tr);
        this.m_vis.setRendererFactory((RendererFactory)this.rendererFactory);
        PolygonRenderer polyR = new PolygonRenderer(1);
        polyR.setCurveSlack(0.15f);
        this.rendererFactory.add("ingroup('aggregates')", (Renderer)polyR);
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup(graph);
        VisualGraph vg = this.m_vis.addGraph(graph, this.graphStructure);
        this.m_vis.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        this.m_vis.addFocusGroup(selected);
        ColorAction communityStroke = new ColorAction(AGGR, VisualItem.STROKECOLOR);
        communityStroke.setDefaultColor(ColorLib.gray((int)200));
        communityStroke.add("_hover", ColorLib.rgb((int)255, (int)100, (int)100));
        int max_num_colors = 25;
        int[] palette = ColorLib.getCategoryPalette((int)max_num_colors, (float)1.0f, (float)0.4f, (float)1.0f, (float)1.0f);
        int[] aggrPalette = ColorLib.getCategoryPalette((int)max_num_colors, (float)1.0f, (float)0.4f, (float)1.0f, (float)0.2f);
        int[] labelPalette = ColorLib.getCategoryPalette((int)max_num_colors, (float)1.0f, (float)0.4f, (float)1.0f, (float)0.2f);
        ActionList draw = new ActionList();
        this.aggrColorAction = new DataColorAction(AGGR, "colorid", 0, VisualItem.FILLCOLOR, aggrPalette);
        draw.add((Action)this.aggrColorAction);
        this.nodeColorAction = new DataColorAction(nodes, "colorid", 0, VisualItem.FILLCOLOR, palette);
        draw.add((Action)this.nodeColorAction);
        this.nodeLabelColorAction = new DataColorAction(nodes, "colorid", 0, VisualItem.TEXTCOLOR, labelPalette);
        draw.add((Action)this.nodeLabelColorAction);
        draw.add((Action)communityStroke);
        draw.add((Action)new ColorAction(nodes, (Predicate)new InGroupPredicate(selected), VisualItem.FILLCOLOR, ColorLib.gray((int)100)));
        draw.add((Action)new ColorAction(nodes, VisualItem.STROKECOLOR, 0));
        draw.add((Action)new ColorAction(edges, VisualItem.FILLCOLOR, ColorLib.gray((int)200)));
        draw.add((Action)new ColorAction(edges, VisualItem.STROKECOLOR, ColorLib.gray((int)200)));
        ForceDirectedLayoutMagic fdlm = new ForceDirectedLayoutMagic(graph);
        AggregateLayout aggrLayout = new AggregateLayout(AGGR);
        LabelLayout labelLayout = new LabelLayout(EDGE_DECORATORS, this.m_vis, true);
        LabelLayout nodeLabelLayout = new LabelLayout(NODE_DECORATORS, this.m_vis, false);
        ActionList animate = new ActionList(-1L);
        animate.add((Action)fdlm);
        animate.add((Action)aggrLayout);
        animate.add((Action)labelLayout);
        animate.add((Action)nodeLabelLayout);
        animate.add((Action)new RepaintAction());
        ActionList nolayoutDraw = new ActionList();
        nolayoutDraw.add((Action)aggrLayout);
        nolayoutDraw.add((Action)labelLayout);
        nolayoutDraw.add((Action)nodeLabelLayout);
        nolayoutDraw.add((Action)draw);
        nolayoutDraw.add((Action)new RepaintAction());
        ActionList oneShotLayout = new ActionList(1000L);
        oneShotLayout.add((Action)fdlm);
        oneShotLayout.add((Action)aggrLayout);
        oneShotLayout.add((Action)labelLayout);
        oneShotLayout.add((Action)nodeLabelLayout);
        oneShotLayout.add((Action)draw);
        oneShotLayout.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.m_vis.putAction("onlydraw", (Action)draw);
        this.m_vis.putAction("nolayout-draw", (Action)nolayoutDraw);
        this.m_vis.putAction("layout", (Action)animate);
        this.m_vis.putAction("oneShotLayout", (Action)oneShotLayout);
        this.m_vis.runAfter("draw", "layout");
        this.m_vis.putAction("zoomtoFitAction", (Action)new ZoomtoFitAction());
        Table rubberBandTable = new Table();
        rubberBandTable.addColumn(VisualItem.POLYGON, [F.class);
        rubberBandTable.addRow();
        this.m_vis.add(RUBBER_BAND, (TupleSet)rubberBandTable);
        VisualItem rubberBand = (VisualItem)this.m_vis.getVisualGroup(RUBBER_BAND).tuples().next();
        rubberBand.set(VisualItem.POLYGON, (Object)new float[8]);
        rubberBand.setStrokeColor(ColorLib.color((Color)ColorLib.getColor((int)255, (int)0, (int)0)));
        PolygonRenderer rubberBandRenderer = new PolygonRenderer(0);
        drf.add((Predicate)new InGroupPredicate(RUBBER_BAND), (Renderer)rubberBandRenderer);
        this.display = new Display(this.m_vis);
        this.display.setSize(700, 700);
        this.display.pan(350.0, 350.0);
        this.display.setForeground(Color.GRAY);
        this.display.setBackground(Color.WHITE);
        this.display.addPaintListener((PaintListener)new DebugStatsPainter());
        this.display.addControlListener((Control)new AggregateDragControl());
        this.display.addControlListener((Control)new PanControl());
        this.display.addControlListener((Control)new ZoomControl());
        this.display.addControlListener((Control)new WheelZoomControl());
        this.display.addControlListener((Control)new ZoomToFitControl());
        this.display.addControlListener((Control)new SelectControl(selected));
        this.display.addControlListener((Control)new ToolTipControl("label"));
        this.display.addControlListener((Control)new RepaintOnEventControl(this.m_vis, "nolayout-draw"));
        this.display.addControlListener((Control)new RubberBandSelect(rubberBand));
        this.display.setForeground(Color.GRAY);
        this.display.setBackground(Color.WHITE);
        ForceSimulator fsim = ((ForceDirectedLayoutMagic)animate.get(0)).getForceSimulator();
        JForcePanel fpanel = new JForcePanel(fsim);
        this.layoutChkBox.setSelected(true);
        this.layoutChkBox.setBackground(Color.WHITE);
        this.layoutChkBox.setMaximumSize(new Dimension(200, 30));
        this.layoutChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PrefuseWidget.this.setContinousLayout(true);
                } else {
                    PrefuseWidget.this.setContinousLayout(false);
                }
            }
        });
        JButton layoutButton = new JButton("run one-shot layout");
        layoutButton.setBackground(Color.WHITE);
        layoutButton.setMaximumSize(new Dimension(200, 30));
        layoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PrefuseWidget.this.continousLayout) {
                    PrefuseWidget.this.m_vis.run("oneShotLayout");
                }
            }
        });
        Box lf = new Box(0);
        lf.add(this.layoutChkBox);
        lf.add(layoutButton);
        lf.setBorder(BorderFactory.createTitledBorder("layout method"));
        fpanel.add((Component)lf);
        JCheckBox aggrChkBox = new JCheckBox("show community borders");
        aggrChkBox.setSelected(true);
        aggrChkBox.setBackground(Color.WHITE);
        aggrChkBox.setMaximumSize(new Dimension(200, 30));
        aggrChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TupleSet ts = PrefuseWidget.this.m_vis.getGroup(PrefuseWidget.AGGR);
                boolean flag = e.getStateChange() == 1;
                Iterator i = ts.tuples();
                while (i.hasNext()) {
                    VisualItem t = (VisualItem)i.next();
                    t.setVisible(flag);
                }
            }
        });
        this.offNodeLabelChkBox = new JCheckBox("off-center labels");
        this.offNodeLabelChkBox.setSelected(false);
        this.offNodeLabelChkBox.setBackground(Color.WHITE);
        this.offNodeLabelChkBox.setMaximumSize(new Dimension(200, 30));
        this.offNodeLabelChkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PrefuseWidget.this.setOffNodeLabels(true);
                } else {
                    PrefuseWidget.this.setOffNodeLabels(false);
                }
                PrefuseWidget.this.m_vis.run("nolayoutDraw");
            }
        });
        Box of = new Box(0);
        of.add(aggrChkBox);
        of.add(this.offNodeLabelChkBox);
        of.setBorder(BorderFactory.createTitledBorder("other options"));
        fpanel.add((Component)of);
        fpanel.add(Box.createVerticalGlue());
        this.jForcePanel = fpanel;
        this.m_vis.run("draw");
        this.setLayout(new BorderLayout());
        this.add((Component)this.display, "Center");
    }

    public synchronized void clearGraph() {
        this.stopViz();
        this.graphStructure.clear();
        this.aggregateTable.clear();
        if (this.stringToPrefuseNode != null) {
            this.stringToPrefuseNode.clear();
        }
        this.commsToPrefuseAggr.clear();
    }

    public synchronized void addData(TreeSet vertices, TreeSet edges, HashMap commsToVertices, Map idToLabelMap, boolean addAggregateItems) {
        this.addData(vertices, edges, commsToVertices, idToLabelMap, addAggregateItems, null, null);
    }

    public synchronized void addData(TreeSet vertices, TreeSet edges, HashMap commsToVertices, Map idToLabelMap, boolean addAggregateItems, Hashtable edgeWeights, Hashtable vertexSizes) {
        this.stopViz();
        this.stringToPrefuseNode = new HashMap();
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            String v = (String)i.next();
            Node n = this.graphStructure.addNode();
            n.set("id", (Object)v);
            this.stringToPrefuseNode.put(v, n);
        }
        Edge firstEdge = (Edge)edges.first();
        boolean directed = firstEdge.isDirected;
        Iterator i2 = edges.iterator();
        while (i2.hasNext()) {
            prefuse.data.Edge prefuseEdge;
            Edge e = (Edge)i2.next();
            Node n1 = (Node)this.stringToPrefuseNode.get(e.getVertex1());
            Node n2 = (Node)this.stringToPrefuseNode.get(e.getVertex2());
            try {
                prefuseEdge = this.graphStructure.addEdge(n1, n2);
            }
            catch (IllegalArgumentException exception) {
                continue;
            }
            if (edgeWeights == null) continue;
            prefuseEdge.set("weight", (Object)((Integer)edgeWeights.get(e)));
        }
        this.setItemAttributes(vertices, commsToVertices, idToLabelMap, addAggregateItems, edgeWeights, directed, vertexSizes);
        if (!this.isContinousLayout()) {
            this.m_vis.run("oneShotLayout");
        }
        this.m_vis.run("zoomtoFitAction");
    }

    public synchronized void setItemAttributes(TreeSet vertices, HashMap commsToVertices, Map idToLabelMap, boolean addAggregateItems, Hashtable edgeWeights, boolean directed, Hashtable vertexSizes) {
        this.stopViz();
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            String v = (String)i.next();
            Node n = (Node)this.stringToPrefuseNode.get(v);
            if (idToLabelMap != null) {
                n.set("label", idToLabelMap.get(v));
            } else {
                n.set("label", (Object)v);
            }
            VisualItem visualNode = this.m_vis.getVisualItem(nodes, (Tuple)n);
            if (vertexSizes != null && vertexSizes.containsKey(v) && !Parameters.IS_NODE_SIZE.booleanValue()) {
                n.set("weight", (Object)((Integer)vertexSizes.get(v)));
                visualNode.setSize(Math.sqrt(((Integer)vertexSizes.get(v)).intValue()));
                continue;
            }
            visualNode.setSize(1.0);
            n.set("weight", null);
        }
        this.aggregateTable.clear();
        HashSet previousComms = new HashSet(this.commsToPrefuseAggr.keySet());
        int num_colors = commsToVertices.size();
        int[] palette = new int[num_colors];
        int[] labelpalette = new int[num_colors];
        int[] aggrpalette = new int[num_colors];
        int curr_colorid = 0;
        Iterator i2 = commsToVertices.entrySet().iterator();
        while (i2.hasNext()) {
            Color labelColor;
            Color color;
            Map.Entry entry = i2.next();
            Set comm = (Set)entry.getValue();
            Community community = (Community)entry.getKey();
            if (community == null) {
                color = Parameters.NODE_COLOR;
                labelColor = Color.BLACK;
            } else {
                color = community.getColor();
                labelColor = community.labelColor;
            }
            palette[curr_colorid] = ColorLib.rgba((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)color.getAlpha());
            labelpalette[curr_colorid] = ColorLib.rgba((int)labelColor.getRed(), (int)labelColor.getGreen(), (int)labelColor.getBlue(), (int)labelColor.getAlpha());
            aggrpalette[curr_colorid] = ColorLib.rgba((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)51);
            AggregateItem item = null;
            if (addAggregateItems) {
                previousComms.remove(community);
                if (this.commsToPrefuseAggr.containsKey(community)) {
                    item = (AggregateItem)this.commsToPrefuseAggr.get(community);
                } else {
                    item = (AggregateItem)this.aggregateTable.addItem();
                    this.commsToPrefuseAggr.put(community, item);
                }
                item.set("colorid", (Object)new Integer(curr_colorid));
            }
            Iterator j = comm.iterator();
            while (j.hasNext()) {
                String v = (String)j.next();
                Node n = (Node)this.stringToPrefuseNode.get(v);
                n.set("colorid", (Object)new Integer(curr_colorid));
                if (!addAggregateItems) continue;
                VisualItem visualNode = this.m_vis.getVisualItem(nodes, (Tuple)n);
                item.addItem(visualNode);
            }
            ++curr_colorid;
        }
        i2 = previousComms.iterator();
        while (i2.hasNext()) {
            Community c = (Community)((Object)i2.next());
            this.aggregateTable.removeTuple((Tuple)((AggregateItem)this.commsToPrefuseAggr.get(c)));
            this.commsToPrefuseAggr.remove(c);
        }
        this.nodeColorAction.setPalette(palette);
        this.nodeLabelColorAction.setPalette(labelpalette);
        this.aggrColorAction.setPalette(aggrpalette);
        this.startViz();
        this.m_vis.run("draw");
        TupleSet ts = this.m_vis.getGroup(nodes);
        if (ts.getTupleCount() > 300) {
            this.rendererFactory.setHighDetail(false);
        } else {
            this.rendererFactory.setHighDetail(true);
        }
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        if (edgeWeights != null && Parameters.IS_DRAW_WEIGHT.booleanValue()) {
            drf.add((Predicate)new InGroupPredicate(EDGE_DECORATORS), (Renderer)new LabelRenderer("weight"));
        }
        EdgeRenderer er = (EdgeRenderer)drf.getDefaultEdgeRenderer();
        if (directed) {
            er.setArrowType(1);
        } else {
            er.setArrowType(0);
        }
        try {
            this.m_vis.addDecorators(EDGE_DECORATORS, edges, DECORATOR_SCHEMA);
            this.m_vis.addDecorators(NODE_DECORATORS, nodes, DECORATOR_SCHEMA);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (edgeWeights == null || !Parameters.IS_DRAW_WEIGHT.booleanValue()) {
            this.m_vis.setVisible(EDGE_DECORATORS, ExpressionParser.predicate((String)"TRUE"), false);
        } else {
            this.m_vis.setVisible(EDGE_DECORATORS, ExpressionParser.predicate((String)"TRUE"), true);
        }
        if (Parameters.IS_DRAW_RECT.booleanValue()) {
            this.m_vis.setVisible(nodes, ExpressionParser.predicate((String)"TRUE"), true);
        } else {
            this.m_vis.setVisible(nodes, ExpressionParser.predicate((String)"TRUE"), false);
        }
        if (Parameters.IS_DRAW_FONT.booleanValue()) {
            ((MyRendererFactory)drf).forceCircles(false);
        } else {
            ((MyRendererFactory)drf).forceCircles(true);
        }
        if (!this.offNodeLabelChkBox.isSelected()) {
            this.m_vis.setVisible(NODE_DECORATORS, ExpressionParser.predicate((String)"TRUE"), false);
        }
        this.m_vis.setValue(nodes, null, VisualItem.SHAPE, (Object)new Integer(1));
    }

    public synchronized void refreshLabels(Map idToLabelMap) {
        TupleSet ts = this.graphStructure.getNodes();
        if (idToLabelMap != null) {
            Iterator i = ts.tuples();
            while (i.hasNext()) {
                Tuple t = (Tuple)i.next();
                String id = (String)t.get("id");
                if (!idToLabelMap.containsKey(id)) continue;
                t.set("label", idToLabelMap.get(id));
            }
        }
    }

    public void setContinousLayout(boolean continous) {
        if (continous && !this.continousLayout) {
            this.m_vis.cancel("nolayout-draw");
            this.m_vis.run("layout");
            this.continousLayout = true;
        } else if (!continous && this.continousLayout) {
            this.m_vis.cancel("layout");
            this.m_vis.run("nolayout-draw");
            this.continousLayout = false;
        }
        this.layoutChkBox.setSelected(continous);
    }

    public void setOffNodeLabels(boolean offNode) {
        if (offNode) {
            DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
            ((MyRendererFactory)drf).forceCircles(true);
            this.m_vis.setVisible(NODE_DECORATORS, ExpressionParser.predicate((String)"TRUE"), true);
        } else {
            this.m_vis.setVisible(NODE_DECORATORS, ExpressionParser.predicate((String)"TRUE"), false);
            DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
            ((MyRendererFactory)drf).forceCircles(false);
        }
    }

    public synchronized void stopViz() {
        if (this.isContinousLayout()) {
            this.m_vis.cancel("layout");
        }
        this.m_vis.cancel("layout");
        this.m_vis.cancel("draw");
        this.m_vis.cancel("nolayout-draw");
        this.m_vis.cancel("oneShotLayout");
        this.m_vis.cancel("onlydraw");
        this.m_vis.cancel("nolayoutDraw");
    }

    public synchronized void startViz() {
        if (this.isContinousLayout()) {
            this.m_vis.run("layout");
        } else {
            this.m_vis.run("draw");
            this.m_vis.run("nolayout-draw");
        }
    }

    public synchronized TreeSet getSelectedNodeIds() {
        TreeSet<String> set = new TreeSet<String>();
        TupleSet ts = this.m_vis.getGroup(selected);
        Iterator i = ts.tuples();
        while (i.hasNext()) {
            Tuple t = (Tuple)i.next();
            String v = (String)t.get("id");
            set.add(v);
        }
        return set;
    }

    public void selectVertex(Object[] nodes, boolean center) {
        TupleSet set = this.m_vis.getGroup(selected);
        set.clear();
        for (int i = 0; i < nodes.length; ++i) {
            String v = (String)nodes[i];
            Node n = (Node)this.stringToPrefuseNode.get(v);
            VisualItem visualNode = this.m_vis.getVisualItem(nodes, (Tuple)n);
            set.addTuple((Tuple)visualNode);
        }
        this.m_vis.run("onlydraw");
    }

    public boolean isContinousLayout() {
        return this.continousLayout;
    }

    public JForcePanel getPrefuseSettings() {
        return this.jForcePanel;
    }

    static {
        DECORATOR_SCHEMA.setDefault(VisualItem.INTERACTIVE, false);
        DECORATOR_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)128));
        DECORATOR_SCHEMA.setDefault(VisualItem.FONT, (Object)FontLib.getFont((String)"Tahoma", (double)16.0));
        DECORATOR_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)0));
    }

    public class RubberBandSelect
    extends ControlAdapter {
        private int downX1;
        private int downY1;
        private VisualItem rubberBand;
        Point2D screenPoint = new Point2D.Float();
        Point2D absPoint = new Point2D.Float();
        Rectangle2D rect = new Rectangle2D.Float();
        Rectangle r = new Rectangle();

        public RubberBandSelect(VisualItem rubberBand) {
            this.rubberBand = rubberBand;
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            Display d = (Display)e.getComponent();
            Visualization vis = d.getVisualization();
            TupleSet focus = vis.getFocusGroup(PrefuseWidget.selected);
            if (!e.isShiftDown()) {
                focus.clear();
            }
            float[] bandRect = (float[])this.rubberBand.get(VisualItem.POLYGON);
            bandRect[7] = 0.0f;
            bandRect[6] = 0.0f;
            bandRect[5] = 0.0f;
            bandRect[4] = 0.0f;
            bandRect[3] = 0.0f;
            bandRect[2] = 0.0f;
            bandRect[1] = 0.0f;
            bandRect[0] = 0.0f;
            d.setHighQuality(false);
            this.screenPoint.setLocation(e.getX(), e.getY());
            d.getAbsoluteCoordinate(this.screenPoint, this.absPoint);
            this.downX1 = (int)this.absPoint.getX();
            this.downY1 = (int)this.absPoint.getY();
            this.rubberBand.setVisible(true);
        }

        public void mouseDragged(MouseEvent e) {
            int temp;
            if (!SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            Display d = (Display)e.getComponent();
            this.screenPoint.setLocation(e.getX(), e.getY());
            d.getAbsoluteCoordinate(this.screenPoint, this.absPoint);
            int x1 = this.downX1;
            int y1 = this.downY1;
            int x2 = (int)this.absPoint.getX();
            int y2 = (int)this.absPoint.getY();
            float[] bandRect = (float[])this.rubberBand.get(VisualItem.POLYGON);
            bandRect[0] = x1;
            bandRect[1] = y1;
            bandRect[2] = x2;
            bandRect[3] = y1;
            bandRect[4] = x2;
            bandRect[5] = y2;
            bandRect[6] = x1;
            bandRect[7] = y2;
            if (x2 < x1) {
                temp = x2;
                x2 = x1;
                x1 = temp;
            }
            if (y2 < y1) {
                temp = y2;
                y2 = y1;
                y1 = temp;
            }
            this.rect.setRect(x1, y1, x2 - x1, y2 - y1);
            Visualization vis = d.getVisualization();
            TupleSet focus = vis.getFocusGroup(PrefuseWidget.selected);
            if (!e.isShiftDown()) {
                focus.clear();
            }
            Iterator it = vis.getGroup(PrefuseWidget.nodes).tuples();
            while (it.hasNext()) {
                VisualItem item = (VisualItem)it.next();
                if (!item.isVisible() || !item.getBounds().intersects(this.rect)) continue;
                focus.addTuple((Tuple)item);
            }
            d.damageReport(this.rect);
            this.rubberBand.setValidated(false);
            d.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            this.rubberBand.setVisible(false);
            Display d = (Display)e.getComponent();
            d.setHighQuality(true);
            d.getVisualization().repaint();
        }
    }

    public class GroupDistanceListener
    implements TupleSetListener {
        String graph;
        Visualization vis;
        GraphDistanceFilter filter;
        String drawAction;
        ArrayList previousVisibleItems;
        int distance;
        boolean lastTimeFiltered = false;

        public GroupDistanceListener(String graphName, Visualization vis, GraphDistanceFilter filter, String drawAction) {
            this(graphName, vis, filter, drawAction, 1);
        }

        public GroupDistanceListener(String graph, Visualization vis, GraphDistanceFilter filter, String drawAction, int distance) {
            this.graph = graph;
            this.vis = vis;
            this.filter = filter;
            this.drawAction = drawAction;
            this.distance = distance;
            this.previousVisibleItems = new ArrayList();
        }

        public void setDistance(int distance) {
            this.distance = distance;
            this.filter.setDistance(distance);
        }

        public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
            if (ts.getTupleCount() == 0) {
                if (this.previousVisibleItems != null) {
                    Iterator iter = this.previousVisibleItems.iterator();
                    while (iter.hasNext()) {
                        VisualItem aItem = (VisualItem)iter.next();
                        aItem.setVisible(true);
                    }
                }
                this.lastTimeFiltered = false;
                this.filter.setEnabled(false);
            } else {
                if (!this.lastTimeFiltered) {
                    this.previousVisibleItems.clear();
                    Iterator iter = this.vis.visibleItems(this.graph);
                    while (iter.hasNext()) {
                        VisualItem aItem = (VisualItem)iter.next();
                        this.previousVisibleItems.add(aItem);
                    }
                }
                this.lastTimeFiltered = true;
                this.filter.setEnabled(true);
                this.filter.setDistance(this.distance);
            }
            this.vis.run(this.drawAction);
        }
    }

    public class MyRendererFactory
    extends DefaultRendererFactory {
        public boolean useHighDetail;
        public boolean forceCircles;

        public MyRendererFactory(LabelRenderer lr) {
            super((Renderer)lr);
            this.useHighDetail = true;
            this.forceCircles = false;
        }

        public Renderer getRenderer(VisualItem item) {
            if (item.isInGroup(PrefuseWidget.nodes)) {
                if (!this.forceCircles && this.useHighDetail) {
                    return super.getRenderer(item);
                }
                return new ShapeRenderer(12);
            }
            return super.getRenderer(item);
        }

        public void setHighDetail(boolean flag) {
            this.useHighDetail = flag;
        }

        public void forceCircles(boolean flag) {
            this.forceCircles = flag;
        }
    }

    public class SelectControl
    extends ControlAdapter {
        String groupName;

        public SelectControl(String groupName) {
            this.groupName = groupName;
        }

        public void itemClicked(VisualItem item, MouseEvent e) {
            if (item == null) {
                // empty if block
            }
            if (item instanceof NodeItem) {
                Visualization vis = item.getVisualization();
                TupleSet set = vis.getGroup(this.groupName);
                if (set.containsTuple((Tuple)item)) {
                    set.removeTuple((Tuple)item);
                } else {
                    set.setTuple((Tuple)item);
                }
                vis.run("onlydraw");
            }
        }
    }

    public class HoverControl
    extends ControlAdapter {
        String hoverGroupName;

        public HoverControl(String hoverGroupName) {
            this.hoverGroupName = hoverGroupName;
        }

        public void itemEntered(VisualItem item, MouseEvent e) {
            if (item instanceof NodeItem) {
                Visualization vis = item.getVisualization();
                vis.getGroup(this.hoverGroupName).setTuple((Tuple)item);
            }
        }

        public void itemExited(VisualItem item, MouseEvent e) {
            if (item instanceof NodeItem) {
                Visualization vis = item.getVisualization();
                vis.getGroup(this.hoverGroupName).removeTuple((Tuple)item);
            }
        }
    }

    public static class FitOverviewListener
    implements ItemBoundsListener {
        private Rectangle2D m_bounds = new Rectangle2D.Double();
        private Rectangle2D m_temp = new Rectangle2D.Double();
        private double m_d = 15.0;

        public void itemBoundsChanged(Display d) {
            d.getItemBounds(this.m_temp);
            GraphicsLib.expand((Rectangle2D)this.m_temp, (double)(25.0 / d.getScale()));
            double dd = this.m_d / d.getScale();
            double xd = Math.abs(this.m_temp.getMinX() - this.m_bounds.getMinX());
            double yd = Math.abs(this.m_temp.getMinY() - this.m_bounds.getMinY());
            double wd = Math.abs(this.m_temp.getWidth() - this.m_bounds.getWidth());
            double hd = Math.abs(this.m_temp.getHeight() - this.m_bounds.getHeight());
            if (xd > dd || yd > dd || wd > dd || hd > dd) {
                this.m_bounds.setFrame(this.m_temp);
                DisplayLib.fitViewToBounds((Display)d, (Rectangle2D)this.m_bounds, (long)0L);
            }
        }
    }
}

