/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.ExternalCalls;
import elte.community.InParams;
import elte.community.OutParams;
import elte.community.StateReportPinger;
import elte.community.visual.MainFrame;
import elte.community.visual.ProgressBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ProgressFrame
extends JFrame
implements ActionListener,
Runnable {
    public ProgressBar locatingCliques = new ProgressBar("Locating Cliques");
    public ProgressBar extractingCommunitites = new ProgressBar("Extracting Communities");
    public ProgressBar readingInput = new ProgressBar("Reading Input File");
    public ProgressBar loadingResults = new ProgressBar("Loading Results");
    JLabel stateLabel = new JLabel();
    JButton stopButton = new JButton("stop");
    protected JPanel progressBarPanel;
    protected JPanel paramPanel;
    protected StateReportPinger srPinger;
    protected MainFrame main;
    protected String inFile;
    protected String outFile;
    protected Double lower;
    protected Double upper;
    protected ExternalCalls externalCalls;

    public ProgressFrame(MainFrame m, String title) {
        super(title);
        this.makeGUI();
        this.main = m;
    }

    protected void start(String filename, Double l, Double u) {
        this.inFile = filename;
        this.outFile = filename + "_files";
        if (l != null) {
            this.outFile = this.outFile + "_" + l;
        }
        if (l != null || u != null) {
            this.outFile = this.outFile + "_w";
        }
        if (u != null) {
            this.outFile = this.outFile + "_" + u;
        }
        this.lower = l;
        this.upper = u;
        this.start();
    }

    protected void start() {
        new Thread(this.srPinger).start();
        new Thread(this).start();
    }

    protected void makeGUI() {
        Container cp = this.getContentPane();
        GridBagLayout gln = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        cp.setLayout(gln);
        this.paramPanel = new JPanel();
        this.paramPanel.setBorder(BorderFactory.createTitledBorder("parameters"));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        cp.add((Component)this.paramPanel, c);
        this.progressBarPanel = new JPanel();
        this.progressBarPanel.setBorder(BorderFactory.createTitledBorder("progress"));
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        cp.add((Component)this.progressBarPanel, c);
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(true);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        cp.add((Component)this.stopButton, c);
        this.setDefaultCloseOperation(1);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.stopButton)) {
            this.stopFinding();
        }
    }

    public void stopFinding() {
        this.log("stopping");
        this.srPinger.isRunning = false;
        this.externalCalls.Stop_process();
    }

    public void findingFinished(InParams ip, OutParams op) {
        this.srPinger.isRunning = false;
        this.stopButton.setEnabled(false);
        this.main.setParams(ip, op);
        this.setVisible(false);
    }

    public void log(String s) {
        System.out.println(s);
    }

    public abstract void run();

    protected abstract void makeProgressBars();
}

