/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.OutParams;
import elte.community.visual.VisualJPanel;
import elte.community.visual.settings.Parameters;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class StatsPanel
extends JPanel
implements VisualJPanel {
    private OutParams outParams;

    public StatsPanel() {
        GridLayout gl = new GridLayout(2, 2);
        this.setLayout(gl);
    }

    public void setCliques(Vector v) {
    }

    public void setCommunities(Vector v) {
    }

    public void setNew(OutParams op) {
        this.outParams = op;
    }

    public ChartPanel createHistogramChart(Hashtable h, String t) {
        HistogramDataset hds = new HistogramDataset();
        hds.setType(HistogramType.FREQUENCY);
        if (h != null) {
            Vector<Double> series = new Vector<Double>();
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                int l = (Integer)h.get(key);
                for (int i = 0; i < l; ++i) {
                    series.add(new Double(key.doubleValue()));
                }
            }
            double[] d = new double[series.size()];
            for (int i = 0; i < d.length; ++i) {
                d[i] = (Double)series.get(i);
            }
            hds.addSeries("series", d, d.length);
        }
        JFreeChart chart = ChartFactory.createHistogram((String)t, (String)"", (String)"", (IntervalXYDataset)hds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        return new ChartPanel(chart, false);
    }

    public ChartPanel createLineChart(Hashtable h, String t) {
        DefaultCategoryDataset cds = new DefaultCategoryDataset();
        if (h != null) {
            double sum = 0.0;
            Enumeration e = h.keys();
            int end = 0;
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                int l = (Integer)h.get(key);
                sum += (double)l;
                if (key <= end) continue;
                end = key;
            }
            double l = 0.0;
            for (int i = 0; i < end; ++i) {
                Integer key = new Integer(i);
                Integer value = (Integer)h.get(key);
                if (value != null) {
                    l += value.doubleValue() / sum;
                }
                if (Parameters.IS_LOGLOG.booleanValue()) {
                    cds.addValue(Math.log(1.0 - l), (Comparable)((Object)t), (Comparable)new Double(Math.log(key.intValue())));
                    continue;
                }
                cds.addValue(1.0 - l, (Comparable)((Object)t), (Comparable)key);
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)t, (String)"", (String)"", (CategoryDataset)cds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        return new ChartPanel(chart, false);
    }

    public void setKeys(Vector v) {
        if (this.outParams != null && v.size() > 0) {
            Integer i = (Integer)v.get(0);
            this.removeAll();
            if (Parameters.IS_CUMULATIVE.booleanValue()) {
                this.add((Component)this.createLineChart(this.outParams.getSizeDistForKey(i), "Size Distribution"));
                this.add((Component)this.createLineChart(this.outParams.getDegreeDistForKey(i), "Degree Distribution"));
                this.add((Component)this.createLineChart(this.outParams.getMembershipDistForKey(i), "Membership Distribution"));
                this.add((Component)this.createLineChart(this.outParams.getOverlapDistForKey(i), "Overlap Distribution"));
            } else {
                this.add((Component)this.createHistogramChart(this.outParams.getSizeDistForKey(i), "Size Distribution"));
                this.add((Component)this.createHistogramChart(this.outParams.getDegreeDistForKey(i), "Degree Distribution"));
                this.add((Component)this.createHistogramChart(this.outParams.getMembershipDistForKey(i), "Membership Distribution"));
                this.add((Component)this.createHistogramChart(this.outParams.getOverlapDistForKey(i), "Overlap Distribution"));
            }
            this.validate();
        }
    }

    public void setSelectedEdges(Object[] s) {
    }

    public void setSelectedVertices(Object[] s) {
    }
}

