/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import elte.community.ExternalCalls;
import elte.community.InParams;
import elte.community.OutParams;
import elte.community.StateReportPinger;
import elte.community.visual.MainFrame;
import elte.community.visual.ProgressFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jfree.ExceptionDialog;

public class StdProgressFrame
extends ProgressFrame {
    protected boolean useDirected;
    protected boolean useWeighted;
    protected double intensTh;
    protected boolean useLowerThresh;
    protected boolean useUpperThresh;
    protected double lowerThresh;
    protected double upperThresh;
    protected boolean useKLevel;
    protected int kLevel;
    protected boolean useTimeLimit;
    protected double timeLimit;
    protected MainFrame mainFrame;

    public StdProgressFrame(MainFrame m, String filename, boolean useDirected, boolean useWeighted, double intensTh, boolean useLowerThresh, boolean useUpperThresh, double l, double u, boolean useKLevel, int kLevel, boolean useTimeLimit, double timeLimit) {
        super(m, "Running calculation");
        this.useDirected = useDirected;
        this.useWeighted = useWeighted;
        this.intensTh = intensTh;
        this.useLowerThresh = useLowerThresh;
        this.useUpperThresh = useUpperThresh;
        this.lowerThresh = l;
        this.upperThresh = u;
        this.useKLevel = useKLevel;
        this.kLevel = kLevel;
        this.useTimeLimit = useTimeLimit;
        this.timeLimit = timeLimit;
        this.log("loading c++ library:");
        this.externalCalls = new ExternalCalls("commfind");
        this.log("loaded c++ library");
        this.makeProgressBars();
        String algo = "Running ";
        algo = useDirected ? algo + " directed" : (useWeighted ? algo + " weighted" : algo + " undirected");
        algo = algo + " algorithm on file:";
        String parameters = !useLowerThresh && !useUpperThresh && !useKLevel && !useTimeLimit ? "" : "with ";
        if (useLowerThresh) {
            parameters = parameters + "lower link-weight threshold: " + l + ", ";
        }
        if (useUpperThresh) {
            parameters = parameters + "upper link-weight threshold: " + u + ", ";
        }
        if (useWeighted) {
            parameters = parameters + "at clique-instensity threshold: " + intensTh + ", ";
        }
        if (useKLevel) {
            parameters = parameters + "at k=" + kLevel + ", ";
        }
        if (useTimeLimit) {
            parameters = parameters + "timelimit: " + timeLimit + " sec. (per node)";
        }
        GridBagLayout gln = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.paramPanel.setLayout(gln);
        c.gridx = 0;
        c.ipady = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        this.paramPanel.add((Component)new JLabel(algo), c);
        c.gridy = 1;
        this.paramPanel.add((Component)new JLabel(filename), c);
        c.gridy = 2;
        this.paramPanel.add((Component)new JLabel(parameters), c);
        this.pack();
        this.validate();
        this.repaint();
        this.setVisible(true);
        this.srPinger = new StateReportPinger(this, this.externalCalls);
        this.start(filename, new Double(l), new Double(u));
    }

    protected void makeProgressBars() {
        GridBagLayout gln = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.progressBarPanel.setLayout(gln);
        this.extractingCommunitites.setPreferredSize(new Dimension(500, 25));
        c.gridx = 0;
        c.ipady = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        this.progressBarPanel.add((Component)this.readingInput, c);
        c.gridy = 1;
        this.progressBarPanel.add((Component)this.locatingCliques, c);
        c.gridy = 2;
        this.progressBarPanel.add((Component)this.extractingCommunitites, c);
        c.gridy = 3;
        this.progressBarPanel.add((Component)this.loadingResults, c);
    }

    public void run() {
        InParams ip = null;
        OutParams op = null;
        String outFileName = this.outFile;
        if (this.useDirected) {
            outFileName = outFileName + "-d";
        } else if (this.useWeighted) {
            outFileName = outFileName + "-w";
            outFileName = outFileName + "-th" + this.intensTh;
        }
        File outputDir = new File(outFileName);
        if (outputDir.exists()) {
            Object[] options = new Object[]{"cancel", "remove directory, re-run community finding", "load results from directory"};
            int n = JOptionPane.showOptionDialog(this.main, "Output directory already exists! Would you like to load results from it or re-reun community finding?", "Output directory already exists", 1, 2, null, options, options[0]);
            System.out.println("choice: " + n);
            if (n == 0) {
                System.out.println("canceling");
                this.stopFinding();
                this.setVisible(false);
                return;
            }
            if (n == 1) {
                System.out.println("removing directory");
                outputDir.renameTo(new File(outputDir.getPath() + ".bckp_" + new Date().getTime()));
            } else if (n == 2) {
                System.out.println("loading results instead");
                this.stopFinding();
                this.setVisible(false);
                this.main.runLoad(outputDir.getPath());
                return;
            }
        }
        try {
            this.readingInput.setProgressRatio(0.0);
            this.readingInput.setIndeterminate(true);
            this.readingInput.setString("Reading input...");
            this.locatingCliques.setProgressRatio(0.0);
            this.locatingCliques.setString("Locating cliques");
            this.extractingCommunitites.setProgressRatio(0.0);
            this.extractingCommunitites.setString("Extracting communitites");
            this.loadingResults.setProgressRatio(0.0);
            this.loadingResults.setString("Loading Results");
            this.log("from: " + this.inFile + " to:" + this.outFile);
            this.log("calling c++ library");
            this.externalCalls.checkLicence(false);
            op = this.externalCalls.findAndLoadComs(this.inFile, outFileName, this.useDirected, this.useWeighted, this.intensTh, this.useLowerThresh, this.lowerThresh, this.useUpperThresh, this.upperThresh, this.useKLevel, this.kLevel, this.useTimeLimit, this.timeLimit);
            ip = op.inParams;
            this.log("c++ library finished");
            this.locatingCliques.setProgressRatio(100.0);
            this.extractingCommunitites.setProgressRatio(100.0);
            this.log("OK");
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("Process stopped by user.")) {
                op = new OutParams();
                ip = new InParams();
                op.setInParams(ip);
                this.findingFinished(ip, op);
                return;
            }
            op = new OutParams();
            ip = new InParams();
            op.setInParams(ip);
            String errorMessage = "<html>An internal error has occured: <p>" + e.getMessage();
            if (e.getMessage().startsWith("ERROR: the output directory already exists and it is non-empty")) {
                errorMessage = errorMessage + "<p>Use File->Open communitites to open previously computed results.";
            }
            if (e.getMessage().startsWith("Licence file not found or invalid licence key")) {
                errorMessage = errorMessage + "<p>Please check that the directory you are running CFinder from contains a licence.txt file which includes a valid licence key.";
            }
            ExceptionDialog.showExceptionDialog("Internal Error", errorMessage, e);
            this.findingFinished(ip, op);
            return;
        }
        this.findingFinished(ip, op);
    }
}

