/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import jfree.ExceptionDialog;

public class URLLabel
extends JLabel
implements MouseListener {
    private String url;

    public URLLabel(String url, String text) {
        super(text);
        this.setToolTipText(url);
        this.setHorizontalAlignment(0);
        this.setForeground(Color.BLUE);
        this.setBackground(Color.WHITE);
        this.url = url;
        this.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent arg0) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, this.url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + this.url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, this.url});
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
        this.setForeground(Color.RED);
    }

    public void mouseExited(MouseEvent arg0) {
        this.setForeground(Color.BLUE);
    }
}

