/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual.graph;

import elte.community.Edge;
import elte.community.visual.MainFrame;
import elte.community.visual.graph.GraphCoordinate;
import elte.community.visual.graph.GraphLayout;
import elte.community.visual.settings.Parameters;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class GraphFRLayout
extends GraphLayout {
    private final double side = 500.0;
    private final int iterations = 150;
    private final double tInit = 300.0;
    private final double tFinal = 0.4;
    private final double tStep = -1.9973333333333334;

    public GraphFRLayout(MainFrame m) {
        super(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        Object object = this.lock;
        synchronized (object) {
            GraphCoordinate gc;
            GraphLayout.IS_STOP = false;
            double k = Math.sqrt(250000.0 * Parameters.LAYOUT_SPRING_STRENGHT / (double)this.vertices.size());
            double t = 300.0;
            Hashtable<String, GraphCoordinate> disp = new Hashtable<String, GraphCoordinate>();
            this.coordinates = new Hashtable();
            Iterator it = this.vertices.iterator();
            while (it.hasNext() && !GraphLayout.IS_STOP) {
                String node = (String)it.next();
                this.setCoordinate(node, new GraphCoordinate(Math.random() * 500.0, Math.random() * 500.0));
                disp.put(node, new GraphCoordinate(0.0, 0.0));
            }
            for (int i = 0; i < 150 && !GraphLayout.IS_STOP; ++i) {
                GraphCoordinate offset;
                double deltaNorm;
                GraphCoordinate delta;
                String u;
                String v;
                it = this.vertices.iterator();
                while (it.hasNext() && !GraphLayout.IS_STOP) {
                    v = (String)it.next();
                    ((GraphCoordinate)disp.get(v)).set(0.0, 0.0);
                    Iterator jt = this.vertices.iterator();
                    while (jt.hasNext() && !GraphLayout.IS_STOP) {
                        u = (String)jt.next();
                        if (u.equals(v)) continue;
                        delta = new GraphCoordinate(this.getCoordinate(v).getX() - this.getCoordinate(u).getX(), this.getCoordinate(v).getY() - this.getCoordinate(u).getY());
                        deltaNorm = Math.sqrt(delta.getX() * delta.getX() + delta.getY() * delta.getY());
                        if (deltaNorm < 1.0E-7) {
                            deltaNorm = k;
                        }
                        offset = new GraphCoordinate(delta.getX() * k * k / (deltaNorm * deltaNorm), delta.getY() * k * k / (deltaNorm * deltaNorm));
                        ((GraphCoordinate)disp.get(v)).add(offset);
                    }
                }
                it = this.edges.iterator();
                while (it.hasNext() && !GraphLayout.IS_STOP) {
                    Edge e = (Edge)it.next();
                    String v2 = e.getVertex1();
                    u = e.getVertex2();
                    delta = new GraphCoordinate(this.getCoordinate(v2).getX() - this.getCoordinate(u).getX(), this.getCoordinate(v2).getY() - this.getCoordinate(u).getY());
                    deltaNorm = Math.sqrt(delta.getX() * delta.getX() + delta.getY() * delta.getY());
                    offset = new GraphCoordinate(delta.getX() * deltaNorm / k, delta.getY() * deltaNorm / k);
                    ((GraphCoordinate)disp.get(v2)).sub(offset);
                    ((GraphCoordinate)disp.get(u)).add(offset);
                }
                it = this.vertices.iterator();
                while (it.hasNext() && !GraphLayout.IS_STOP) {
                    v = (String)it.next();
                    GraphCoordinate d = (GraphCoordinate)disp.get(v);
                    double dn = Math.sqrt(d.getX() * d.getX() + d.getY() * d.getY());
                    if (t < dn) {
                        d.set(d.getX() / dn * t, d.getY() / dn * t);
                    }
                    this.getCoordinate(v).add(d);
                }
                t += -1.9973333333333334;
            }
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double maxY = Double.MIN_VALUE;
            Enumeration e = this.coordinates.elements();
            while (e.hasMoreElements() && !GraphLayout.IS_STOP) {
                gc = (GraphCoordinate)e.nextElement();
                minX = Math.min(gc.getX(), minX);
                minY = Math.min(gc.getY(), minY);
                maxX = Math.max(gc.getX(), maxX);
                maxY = Math.max(gc.getY(), maxY);
            }
            e = this.coordinates.elements();
            while (e.hasMoreElements() && !GraphLayout.IS_STOP) {
                gc = (GraphCoordinate)e.nextElement();
                gc.set(gc.getX() - minX, gc.getY() - minY);
            }
            this.fListener.finishedEvent();
        }
    }
}

