/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual.graph;

import elte.community.Community;
import elte.community.Edge;
import elte.community.visual.FinishedListener;
import elte.community.visual.MainFrame;
import elte.community.visual.Text;
import elte.community.visual.graph.GraphCoordinate;
import elte.community.visual.settings.Parameters;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jibble.epsgraphics.EpsGraphics2D;

public abstract class GraphLayout
extends JComponent
implements MouseListener,
MouseMotionListener,
AdjustmentListener,
Runnable {
    public static boolean IS_STOP = false;
    protected Hashtable coordinates;
    protected TreeSet edges;
    protected TreeSet vertices;
    protected TreeSet overlap;
    protected TreeSet overlapE;
    protected Hashtable edgeWeights;
    protected Hashtable edgeColors;
    protected Hashtable vertexSizes;
    protected Hashtable vertexColors;
    protected Hashtable fontColors;
    protected Map idToLabelMap;
    private TreeSet selectedNodes;
    private TreeSet selectedEdges;
    private Community selectedCommunity;
    private double scale = 1.0;
    private double x;
    private double y;
    private double trX = 0.0;
    private double trY = 0.0;
    private TreeSet draggingNodes;
    private int state;
    private static int NORMAL = 0;
    private static int SELECTING_MOVING_AREA = 1;
    private static int MOVING = 2;
    private double selX;
    private double selY;
    protected BufferedImage img;
    protected FinishedListener fListener;
    protected MainFrame main;
    public Object lock = new Object();
    public boolean isFirst = true;

    public abstract void run();

    public GraphLayout(MainFrame m) {
        this.main = m;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.WHITE);
    }

    public void set(TreeSet vertices, TreeSet edges, TreeSet overlap, TreeSet overlapE, Hashtable weight, Hashtable size, Hashtable edgeC, Hashtable vertexC, Hashtable fontC, Map idToLabelMap, FinishedListener fl) {
        this.fListener = fl;
        this.edges = edges;
        this.vertices = vertices;
        this.overlap = overlap;
        this.overlapE = overlapE;
        this.edgeWeights = weight;
        this.vertexSizes = size;
        this.edgeColors = edgeC;
        this.vertexColors = vertexC;
        this.fontColors = fontC;
        this.idToLabelMap = idToLabelMap;
        this.selectedNodes = new TreeSet();
        this.selectedEdges = new TreeSet();
        this.draggingNodes = new TreeSet();
        this.state = NORMAL;
        this.isFirst = true;
    }

    public void removeEdges(TreeSet edges) {
        this.edges.removeAll(edges);
    }

    public void setCoordinate(String node, GraphCoordinate c) {
        this.coordinates.remove(node);
        this.coordinates.put(node.toString(), c);
    }

    public GraphCoordinate getCoordinate(String node) {
        return (GraphCoordinate)this.coordinates.get(node);
    }

    public void selectVertex(Object[] nodes, boolean center) {
        String s;
        GraphCoordinate c;
        this.selectedNodes = new TreeSet<Object>(Arrays.asList(nodes));
        if (this.selectedNodes.size() == 1 && center && this.coordinates != null && (c = (GraphCoordinate)this.coordinates.get(s = (String)this.selectedNodes.first())) != null) {
            this.trX = this.scale * -c.getX() + this.getSize().getWidth() / 2.0;
            this.trY = this.scale * -c.getY() + this.getSize().getHeight() / 2.0;
        }
    }

    public void centerVertex(String node) {
        GraphCoordinate c;
        if (this.coordinates != null && (c = (GraphCoordinate)this.coordinates.get(node)) != null) {
            this.trX = this.scale * -c.getX() + this.getSize().getWidth() / 2.0;
            this.trY = this.scale * -c.getY() + this.getSize().getHeight() / 2.0;
        }
    }

    public void selectEdge(Object[] edges) {
        this.selectedEdges = new TreeSet<Object>(Arrays.asList(edges));
    }

    public void selectCommunity(Community c) {
        this.selectedCommunity = c;
    }

    public void refreshLabels(Map idToLabelMap) {
        this.idToLabelMap = idToLabelMap;
    }

    public void capture(String s) throws IOException {
        if (this.img != null) {
            FileOutputStream out = new FileOutputStream(s);
            if (s.endsWith("png")) {
                ImageIO.write((RenderedImage)this.img, "png", out);
            } else if (s.endsWith("jpg")) {
                ImageIO.write((RenderedImage)this.img, "jpg", out);
            } else if (s.endsWith("eps")) {
                EpsGraphics2D g = new EpsGraphics2D();
                this.paint((Graphics)g);
                out.write(g.toString().getBytes());
            }
            out.close();
        }
    }

    public void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness) {
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }

    public void paintEdges(Graphics2D g2) {
        Iterator i = this.edges.iterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            Color edgeColor = Parameters.EDGE_COLOR;
            int we = 1;
            if (this.edgeColors != null && this.edgeColors.containsKey(edge)) {
                edgeColor = (Color)this.edgeColors.get(edge);
            }
            if (this.selectedEdges.contains(edge) || this.selectedNodes.contains(edge.getVertex1()) && this.selectedNodes.contains(edge.getVertex2())) {
                edgeColor = Parameters.HIGHLIGHT_COLOR;
            } else if (Parameters.IS_DRAW_OVERLAP.booleanValue() && this.overlapE != null && this.overlapE.contains(edge)) {
                edgeColor = Parameters.OVERLAP_COLOR;
                we = 2;
            } else if (this.selectedCommunity == null || this.selectedCommunity.getEdges().contains(edge)) {
                edgeColor = edgeColor.darker();
            }
            g2.setColor(edgeColor);
            GraphCoordinate v1 = (GraphCoordinate)this.coordinates.get(edge.getVertex1());
            GraphCoordinate v2 = (GraphCoordinate)this.coordinates.get(edge.getVertex2());
            if (this.edgeWeights != null && this.edgeWeights.containsKey(edge)) {
                we = (Integer)this.edgeWeights.get(edge);
            }
            if (we > 1 && Parameters.IS_LINE_WIDTH.booleanValue()) {
                this.drawThickLine(g2, Math.round((float)v1.getX()), Math.round((float)v1.getY()), Math.round((float)v2.getX()), Math.round((float)v2.getY()), we);
            } else {
                g2.drawLine(Math.round((float)v1.getX()), Math.round((float)v1.getY()), Math.round((float)v2.getX()), Math.round((float)v2.getY()));
            }
            if (this.edgeWeights != null && this.edgeWeights.containsKey(edge) && Parameters.IS_DRAW_WEIGHT.booleanValue()) {
                g2.drawString(Integer.toString(we), Math.round((float)((v1.getX() + v2.getX()) / 2.0 + (double)Parameters.FONT_SIZE.intValue())), Math.round((float)((v1.getY() + v2.getY()) / 2.0 + (double)Parameters.FONT_SIZE.intValue())));
            }
            g2.fillRoundRect(Math.round((float)((v1.getX() + v2.getX() - (double)Parameters.EDGE_HANDLE_SIZE.intValue()) / 2.0)), Math.round((float)((v1.getY() + v2.getY() - (double)Parameters.EDGE_HANDLE_SIZE.intValue()) / 2.0)), Parameters.EDGE_HANDLE_SIZE, Parameters.EDGE_HANDLE_SIZE, Parameters.EDGE_HANDLE_SIZE, Parameters.EDGE_HANDLE_SIZE);
            if (!edge.isDirected) continue;
            int nodeSize = Parameters.RECT_SIZE;
            double arrowHeadSize = nodeSize;
            double l = Math.sqrt((v2.getX() - v1.getX()) * (v2.getX() - v1.getX()) + (v2.getY() - v1.getY()) * (v2.getY() - v1.getY()));
            double lPrime = l - (double)nodeSize / 2.0;
            double x1 = (v2.getX() - v1.getX()) * (lPrime / l) + v1.getX();
            double y1 = (v2.getY() - v1.getY()) * (lPrime / l) + v1.getY();
            double lPrimePrime = l - (double)nodeSize / 2.0 - arrowHeadSize;
            double ratio = lPrimePrime / l;
            double x2 = (v2.getX() - v1.getX()) * ratio + v1.getX();
            double y2 = (v2.getY() - v1.getY()) * ratio + v1.getY();
            double x3 = (-y1 + y2) / 4.0 + x2;
            double y3 = (x1 - x2) / 4.0 + y2;
            double x4 = (y1 - y2) / 4.0 + x2;
            double y4 = (-x1 + x2) / 4.0 + y2;
            GeneralPath arrowHead = new GeneralPath();
            arrowHead.moveTo((float)x4, (float)y4);
            arrowHead.lineTo((float)x1, (float)y1);
            arrowHead.lineTo((float)x3, (float)y3);
            arrowHead.closePath();
            g2.fill(arrowHead);
        }
    }

    public void paintVertices(Graphics2D g2) {
        Enumeration e = this.coordinates.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            GraphCoordinate gc = (GraphCoordinate)this.coordinates.get(node);
            boolean highLight = this.selectedNodes.contains(node);
            int nodeSize = Parameters.RECT_SIZE;
            Color fontColor = Parameters.FONT_COLOR;
            Color fillColor = Parameters.NODE_COLOR;
            if (this.vertexColors != null && this.vertexColors.containsKey(node)) {
                fillColor = (Color)this.vertexColors.get(node);
            }
            if (this.fontColors != null && this.fontColors.containsKey(node)) {
                fontColor = (Color)this.fontColors.get(node);
            }
            if (highLight) {
                fontColor = Parameters.HIGHLIGHT_COLOR;
                fillColor = Parameters.HIGHLIGHT_COLOR;
            } else if (Parameters.IS_DRAW_OVERLAP.booleanValue() && this.overlap != null && this.overlap.contains(node)) {
                fontColor = Parameters.OVERLAP_COLOR;
                fillColor = Parameters.OVERLAP_COLOR;
            } else if (this.selectedCommunity == null || this.selectedCommunity.getVertices().contains(node)) {
                fontColor = fontColor.darker();
                fillColor = fillColor.darker();
            }
            if (Parameters.IS_DRAW_RECT.booleanValue()) {
                if (this.vertexSizes != null && this.vertexSizes.containsKey(node) && !Parameters.IS_NODE_SIZE.booleanValue()) {
                    nodeSize = (Integer)this.vertexSizes.get(node);
                }
                g2.setColor(fontColor);
                g2.drawRoundRect(Math.round((float)(gc.getX() - (double)nodeSize / 2.0)), Math.round((float)(gc.getY() - (double)nodeSize / 2.0)), nodeSize, nodeSize, nodeSize, nodeSize);
                g2.setColor(fillColor);
                g2.fillRoundRect(Math.round((float)(gc.getX() - (double)nodeSize / 2.0)), Math.round((float)(gc.getY() - (double)nodeSize / 2.0)), nodeSize, nodeSize, nodeSize, nodeSize);
            }
            g2.setFont(new Font(null, 1, Parameters.FONT_SIZE));
            if (!Parameters.IS_DRAW_FONT.booleanValue() && !highLight) continue;
            g2.setColor(fontColor);
            String label = this.idToLabelMap != null ? (String)this.idToLabelMap.get(node) : node;
            g2.drawString(label, (float)Math.round((double)((float)gc.getX()) + (double)nodeSize / 2.0), (float)Math.round((float)gc.getY()));
        }
    }

    public void paint(Graphics g) {
        if (this.img == null || this.img.getWidth() != this.getWidth() || this.img.getHeight() != this.getHeight()) {
            this.img = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics2D g2 = this.img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        AffineTransform atf = AffineTransform.getTranslateInstance(this.trX, this.trY);
        atf.scale(this.scale, this.scale);
        g2.setTransform(atf);
        this.paintEdges(g2);
        this.paintVertices(g2);
        if (this.state == SELECTING_MOVING_AREA) {
            g2.setColor(Color.BLACK);
            int dx = Math.min(Math.round((float)(this.x / this.scale)), Math.round((float)(this.selX / this.scale)));
            int dy = Math.min(Math.round((float)(this.y / this.scale)), Math.round((float)(this.selY / this.scale)));
            int dw = Math.round(Math.abs((float)((this.selX - this.x) / this.scale)));
            int dh = Math.round(Math.abs((float)((this.selY - this.y) / this.scale)));
            g2.drawRect(dx, dy, dw, dh);
        }
        g2.dispose();
        g.drawImage(this.img, 0, 0, this);
    }

    public TreeSet getSelectedNodes() {
        return this.selectedNodes;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        if (this.isFirst) {
            this.main.status(Text.GRAPH_HELP);
            this.isFirst = false;
        }
        this.x = (double)arg0.getX() - this.trX;
        this.y = (double)arg0.getY() - this.trY;
        if (arg0.getButton() == 3) {
            this.state = SELECTING_MOVING_AREA;
            this.draggingNodes = new TreeSet();
            this.selX = (double)arg0.getX() - this.trX;
            this.selY = (double)arg0.getY() - this.trY;
        } else {
            this.state = MOVING;
        }
        Enumeration e = this.coordinates.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            GraphCoordinate gc = (GraphCoordinate)this.coordinates.get(node);
            if (!gc.isNear(this.x / this.scale, this.y / this.scale)) continue;
            this.draggingNodes = new TreeSet();
            this.draggingNodes.add(node);
            this.selectedEdges = new TreeSet();
            this.selectVertex(new Object[]{node}, false);
            this.repaint();
        }
        Iterator i = this.edges.iterator();
        while (i.hasNext()) {
            Edge eg = (Edge)i.next();
            GraphCoordinate gc1 = (GraphCoordinate)this.coordinates.get(eg.getVertex1());
            GraphCoordinate gc2 = (GraphCoordinate)this.coordinates.get(eg.getVertex2());
            GraphCoordinate gc = new GraphCoordinate((gc1.getX() + gc2.getX()) / 2.0, (gc1.getY() + gc2.getY()) / 2.0);
            if (!gc.isNear(this.x / this.scale, this.y / this.scale)) continue;
            this.selectEdge(new Object[]{eg});
            this.selectVertex(new Object[]{eg.getVertex1(), eg.getVertex2()}, false);
            this.draggingNodes = new TreeSet();
            this.draggingNodes.add(eg.getVertex1());
            this.draggingNodes.add(eg.getVertex2());
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.state == SELECTING_MOVING_AREA) {
            if (this.draggingNodes.size() == 0) {
                this.selectedEdges = new TreeSet();
                int dx = Math.min(Math.round((float)(this.x / this.scale)), Math.round((float)(this.selX / this.scale)));
                int dy = Math.min(Math.round((float)(this.y / this.scale)), Math.round((float)(this.selY / this.scale)));
                int dw = Math.round(Math.abs((float)((this.selX - this.x) / this.scale)));
                int dh = Math.round(Math.abs((float)((this.selY - this.y) / this.scale)));
                Enumeration e = this.coordinates.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    GraphCoordinate gc = (GraphCoordinate)this.coordinates.get(node);
                    if (!(gc.getX() > (double)dx) || !(gc.getX() < (double)(dx + dw)) || !(gc.getY() > (double)dy) || !(gc.getY() < (double)(dy + dh))) continue;
                    this.draggingNodes.add(node);
                }
            }
            this.selectVertex(this.draggingNodes.toArray(), false);
        } else {
            this.draggingNodes = new TreeSet();
            this.selectedNodes = new TreeSet();
            this.selectedEdges = new TreeSet();
        }
        this.repaint();
        this.state = NORMAL;
    }

    public void mouseDragged(MouseEvent arg0) {
        if (this.state == MOVING && this.draggingNodes.size() > 0) {
            Iterator i = this.draggingNodes.iterator();
            while (i.hasNext()) {
                GraphCoordinate gc = (GraphCoordinate)this.coordinates.get(i.next());
                gc.set(gc.getX() + (-this.x + (double)arg0.getX() - this.trX) / this.scale, gc.getY() + (-this.y + (double)arg0.getY() - this.trY) / this.scale);
            }
            this.x = (double)arg0.getX() - this.trX;
            this.y = (double)arg0.getY() - this.trY;
        } else if (this.state == SELECTING_MOVING_AREA) {
            this.selX = (double)arg0.getX() - this.trX;
            this.selY = (double)arg0.getY() - this.trY;
        } else if (this.state == MOVING) {
            this.trX = (double)arg0.getX() - this.x;
            this.trY = (double)arg0.getY() - this.y;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void adjustmentValueChanged(AdjustmentEvent arg0) {
        GraphCoordinate gc = new GraphCoordinate((this.getSize().getWidth() / 2.0 - this.trX) / this.scale, (this.getSize().getHeight() / 2.0 - this.trY) / this.scale);
        this.scale = Math.pow(1.1, (double)arg0.getValue() - 50.0);
        this.trX = this.scale * -gc.getX() + this.getSize().getWidth() / 2.0;
        this.trY = this.scale * -gc.getY() + this.getSize().getHeight() / 2.0;
        this.repaint();
    }
}

