/*
 * Decompiled with CFR 0.152.
 */
package elte.community.visual.settings;

import elte.community.Community;
import elte.community.visual.OutParamsPanel;
import elte.community.visual.WarningDialog;
import elte.community.visual.settings.Parameters;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jfree.ExceptionDialog;

public class SettingsDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton("OK (close)");
    private JButton applyButton = new JButton("Apply");
    private JButton cancelButton = new JButton("Cancel (close)");
    private JButton loadButton = new JButton("Load");
    private JButton saveButton = new JButton("Save");
    private JButton defaultButton = new JButton("Set default");
    private JButton selectedColorButton = new JButton("change...");
    private Color selectedColor;
    private JButton selectedLabelColorButton = new JButton("change...");
    private Color selectedLabelColor;
    private JButton fontColorButton = new JButton("change...");
    private Color fontColor;
    private JButton edgeColorButton = new JButton("change...");
    private Color edgeColor;
    private JButton nodeColorButton = new JButton("change...");
    private Color nodeColor;
    private JButton highlightColorButton = new JButton("change...");
    private Color highlightColor;
    private JButton overlapColorButton = new JButton("change...");
    private Color overlapColor;
    private JTextField commgrafDepthField = new JTextField();
    private JTextField selectionRadiusField = new JTextField();
    private JTextField edgeHandleSizeField = new JTextField();
    private JTextField fontSizeField = new JTextField();
    private JTextField nodeSizeField = new JTextField();
    private JCheckBox usePrefuseBox = new JCheckBox();
    private JCheckBox isDrawFontBox = new JCheckBox();
    private JCheckBox isDrawGraphBox = new JCheckBox();
    private JCheckBox isDrawNodeBox = new JCheckBox();
    private JCheckBox isNewZoom = new JCheckBox();
    private JCheckBox isDrawWeightBox = new JCheckBox();
    private JCheckBox isLineWidthBox = new JCheckBox();
    private JCheckBox isNodeSizeBox = new JCheckBox();
    private JCheckBox isDrawOverlapBox = new JCheckBox();
    private JCheckBox showRelInDegreeBox = new JCheckBox();
    private JCheckBox showRelOutDegreeBox = new JCheckBox();
    private JCheckBox isCumulativeBox = new JCheckBox();
    private JTextField nodeSizeMultField = new JTextField();
    private JTextField layoutSpringStrenghtField = new JTextField();
    private Hashtable oldValues = new Hashtable();
    private OutParamsPanel outParamsPanel;
    private Community community;

    public SettingsDialog(OutParamsPanel opp) {
        super(new JFrame(), "Settings", false);
        this.outParamsPanel = opp;
        JPanel settings = new JPanel();
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        settings.setLayout(gl);
        c1.gridwidth = 1;
        c2.fill = 2;
        c2.gridwidth = 0;
        JLabel generalLabel = new JLabel("General settings:", 0);
        generalLabel.setForeground(Color.RED);
        settings.add((Component)generalLabel, c2);
        settings.add((Component)new JLabel("use prefuse widget"), c1);
        settings.add((Component)this.usePrefuseBox, c2);
        settings.add((Component)new JLabel("Draw graph"), c1);
        settings.add((Component)this.isDrawGraphBox, c2);
        settings.add((Component)new JLabel("Highlight color"), c1);
        settings.add((Component)this.highlightColorButton, c2);
        this.highlightColorButton.addActionListener(this);
        this.highlightColor = Parameters.HIGHLIGHT_COLOR;
        settings.add((Component)new JLabel("Draw node label"), c1);
        settings.add((Component)this.isDrawFontBox, c2);
        settings.add((Component)new JLabel("Draw node"), c1);
        settings.add((Component)this.isDrawNodeBox, c2);
        settings.add((Component)new JLabel("Show relative in-degree"), c1);
        settings.add((Component)this.showRelInDegreeBox, c2);
        settings.add((Component)new JLabel("Show relative out-degree"), c1);
        settings.add((Component)this.showRelOutDegreeBox, c2);
        settings.add((Component)new JLabel("Node label size"), c1);
        settings.add((Component)this.fontSizeField, c2);
        settings.add((Component)new JLabel("Node size"), c1);
        settings.add((Component)this.nodeSizeField, c2);
        settings.add((Component)new JLabel("Radius for selection"), c1);
        settings.add((Component)this.selectionRadiusField, c2);
        settings.add((Component)new JLabel("Edge handle size"), c1);
        settings.add((Component)this.edgeHandleSizeField, c2);
        JLabel commLabel = new JLabel("Communities:", 0);
        commLabel.setForeground(Color.RED);
        settings.add((Component)commLabel, c2);
        settings.add((Component)new JLabel("Color of selected community"), c1);
        settings.add((Component)this.selectedColorButton, c2);
        this.selectedColorButton.addActionListener(this);
        settings.add((Component)new JLabel("Label color of selected community"), c1);
        settings.add((Component)this.selectedLabelColorButton, c2);
        this.selectedLabelColorButton.addActionListener(this);
        settings.add((Component)new JLabel("Draw overlap"), c1);
        settings.add((Component)this.isDrawOverlapBox, c2);
        settings.add((Component)new JLabel("Overlap color"), c1);
        settings.add((Component)this.overlapColorButton, c2);
        this.overlapColorButton.addActionListener(this);
        this.overlapColor = Parameters.OVERLAP_COLOR;
        JLabel commGraphLabel = new JLabel("Graph of communities:", 0);
        commGraphLabel.setForeground(Color.RED);
        settings.add((Component)commGraphLabel, c2);
        settings.add((Component)new JLabel("Node label color"), c1);
        settings.add((Component)this.fontColorButton, c2);
        this.fontColorButton.addActionListener(this);
        this.fontColor = Parameters.FONT_COLOR;
        settings.add((Component)new JLabel("Edge color"), c1);
        settings.add((Component)this.edgeColorButton, c2);
        this.edgeColorButton.addActionListener(this);
        this.edgeColor = Parameters.EDGE_COLOR;
        settings.add((Component)new JLabel("Node color"), c1);
        settings.add((Component)this.nodeColorButton, c2);
        this.nodeColorButton.addActionListener(this);
        this.nodeColor = Parameters.NODE_COLOR;
        settings.add((Component)new JLabel("Community graph depth"), c1);
        settings.add((Component)this.commgrafDepthField, c2);
        settings.add((Component)new JLabel("Label lines with edge weight"), c1);
        settings.add((Component)this.isDrawWeightBox, c2);
        settings.add((Component)new JLabel("Line width shows edge weight"), c1);
        settings.add((Component)this.isLineWidthBox, c2);
        settings.add((Component)new JLabel("Nodes have the same size"), c1);
        settings.add((Component)this.isNodeSizeBox, c2);
        settings.add((Component)new JLabel("Node size multiplier"), c1);
        settings.add((Component)this.nodeSizeMultField, c2);
        settings.add((Component)new JLabel("layout spring strenght"), c1);
        settings.add((Component)this.layoutSpringStrenghtField, c2);
        c1.fill = 2;
        settings.add((Component)this.applyButton, c1);
        settings.add((Component)this.defaultButton, c2);
        settings.add((Component)this.okButton, c1);
        settings.add((Component)this.cancelButton, c2);
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.defaultButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(settings), "Center");
        this.pack();
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.community = this.outParamsPanel.getTabbedCommunity();
            if (this.community == null) {
                this.selectedColorButton.setEnabled(false);
                this.selectedLabelColorButton.setEnabled(false);
            } else {
                this.selectedColor = this.community.getColor();
                this.selectedLabelColor = this.community.labelColor;
                this.selectedColorButton.setEnabled(true);
                this.selectedLabelColorButton.setEnabled(true);
            }
            this.setDialogToParameters();
            this.rememberOldValues();
        }
        super.setVisible(flag);
    }

    private void setDialogToParameters() {
        if (this.community != null) {
            this.selectedColor = this.community.getColor();
            this.selectedLabelColor = this.community.labelColor;
        }
        this.fontColor = Parameters.FONT_COLOR;
        this.edgeColor = Parameters.EDGE_COLOR;
        this.nodeColor = Parameters.NODE_COLOR;
        this.highlightColor = Parameters.HIGHLIGHT_COLOR;
        this.overlapColor = Parameters.OVERLAP_COLOR;
        this.commgrafDepthField.setText(Parameters.COMMGRAF_DEPTH.toString());
        this.selectionRadiusField.setText(Parameters.DRAG_NEAR_RADIUS.toString());
        this.edgeHandleSizeField.setText(Parameters.EDGE_HANDLE_SIZE.toString());
        this.fontSizeField.setText(Parameters.FONT_SIZE.toString());
        this.nodeSizeField.setText(Parameters.RECT_SIZE.toString());
        this.usePrefuseBox.setSelected(Parameters.USE_PREFUSE);
        this.isDrawFontBox.setSelected(Parameters.IS_DRAW_FONT);
        this.isDrawGraphBox.setSelected(Parameters.IS_DRAW_GRAPH);
        this.isDrawNodeBox.setSelected(Parameters.IS_DRAW_RECT);
        this.isNewZoom.setSelected(Parameters.IS_NEW_ZOOM);
        this.isDrawWeightBox.setSelected(Parameters.IS_DRAW_WEIGHT);
        this.isLineWidthBox.setSelected(Parameters.IS_LINE_WIDTH);
        this.isNodeSizeBox.setSelected(Parameters.IS_NODE_SIZE);
        this.isDrawOverlapBox.setSelected(Parameters.IS_DRAW_OVERLAP);
        this.showRelInDegreeBox.setSelected(Parameters.SHOW_REL_INDEGREE);
        this.showRelOutDegreeBox.setSelected(Parameters.SHOW_REL_OUTDEGREE);
        this.isCumulativeBox.setSelected(Parameters.IS_CUMULATIVE);
        this.nodeSizeMultField.setText(Parameters.RECT_SIZE_MULT.toString());
        this.layoutSpringStrenghtField.setText(Parameters.LAYOUT_SPRING_STRENGHT.toString());
    }

    private void setParametersFromDialog() {
        if (this.community != null) {
            this.community.setColor(this.selectedColor);
            this.community.labelColor = this.selectedLabelColor;
        }
        Parameters.FONT_COLOR = this.fontColor;
        Parameters.EDGE_COLOR = this.edgeColor;
        Parameters.NODE_COLOR = this.nodeColor;
        Parameters.HIGHLIGHT_COLOR = this.highlightColor;
        Parameters.OVERLAP_COLOR = this.overlapColor;
        Parameters.USE_PREFUSE = new Boolean(this.usePrefuseBox.isSelected());
        Parameters.IS_DRAW_FONT = new Boolean(this.isDrawFontBox.isSelected());
        Parameters.IS_DRAW_GRAPH = new Boolean(this.isDrawGraphBox.isSelected());
        Parameters.IS_DRAW_RECT = new Boolean(this.isDrawNodeBox.isSelected());
        Parameters.IS_NEW_ZOOM = new Boolean(this.isNewZoom.isSelected());
        Parameters.IS_DRAW_WEIGHT = new Boolean(this.isDrawWeightBox.isSelected());
        Parameters.IS_LINE_WIDTH = new Boolean(this.isLineWidthBox.isSelected());
        Parameters.IS_NODE_SIZE = new Boolean(this.isNodeSizeBox.isSelected());
        Parameters.IS_DRAW_OVERLAP = new Boolean(this.isDrawOverlapBox.isSelected());
        Parameters.SHOW_REL_INDEGREE = new Boolean(this.showRelInDegreeBox.isSelected());
        Parameters.SHOW_REL_OUTDEGREE = new Boolean(this.showRelOutDegreeBox.isSelected());
        Parameters.IS_CUMULATIVE = new Boolean(this.isCumulativeBox.isSelected());
        try {
            Parameters.COMMGRAF_DEPTH = Integer.valueOf(this.commgrafDepthField.getText());
            Parameters.RECT_SIZE_MULT = Double.valueOf(this.nodeSizeMultField.getText());
            Parameters.LAYOUT_SPRING_STRENGHT = Double.valueOf(this.layoutSpringStrenghtField.getText());
            Parameters.EDGE_HANDLE_SIZE = Integer.valueOf(this.edgeHandleSizeField.getText());
            Parameters.DRAG_NEAR_RADIUS = Double.valueOf(this.selectionRadiusField.getText());
            Parameters.FONT_SIZE = Integer.valueOf(this.fontSizeField.getText());
            Parameters.RECT_SIZE = Integer.valueOf(this.nodeSizeField.getText());
        }
        catch (NumberFormatException e) {
            new WarningDialog("Wrong Number Format!").setVisible(true);
        }
    }

    private void rememberOldValues() {
        if (this.community != null) {
            this.oldValues.put("selected_COLOR", this.community.getColor());
        }
        this.oldValues.put("FONT_COLOR", Parameters.FONT_COLOR);
        this.oldValues.put("EDGE_COLOR", Parameters.EDGE_COLOR);
        this.oldValues.put("NODE_COLOR", Parameters.NODE_COLOR);
        this.oldValues.put("HIGHLIGHT_COLOR", Parameters.HIGHLIGHT_COLOR);
        this.oldValues.put("OVERLAP_COLOR", Parameters.OVERLAP_COLOR);
        this.oldValues.put("COMMGRAF_DEPTH", Parameters.COMMGRAF_DEPTH);
        this.oldValues.put("DRAG_NEAR_RADIUS", Parameters.DRAG_NEAR_RADIUS);
        this.oldValues.put("EDGE_HANDLE_SIZE", Parameters.EDGE_HANDLE_SIZE);
        this.oldValues.put("FONT_SIZE", Parameters.FONT_SIZE);
        this.oldValues.put("RECT_SIZE", Parameters.RECT_SIZE);
        this.oldValues.put("USE_PREFUSE", Parameters.USE_PREFUSE);
        this.oldValues.put("IS_DRAW_FONT", Parameters.IS_DRAW_FONT);
        this.oldValues.put("IS_DRAW_GRAPH", Parameters.IS_DRAW_GRAPH);
        this.oldValues.put("IS_DRAW_RECT", Parameters.IS_DRAW_RECT);
        this.oldValues.put("IS_NEW_ZOOM", Parameters.IS_NEW_ZOOM);
        this.oldValues.put("IS_DRAW_WEIGHT", Parameters.IS_DRAW_WEIGHT);
        this.oldValues.put("IS_LINE_WIDTH", Parameters.IS_LINE_WIDTH);
        this.oldValues.put("IS_NODE_SIZE", Parameters.IS_NODE_SIZE);
        this.oldValues.put("IS_DRAW_OVERLAP", Parameters.IS_DRAW_OVERLAP);
        this.oldValues.put("IS_CUMULATIVE", Parameters.IS_CUMULATIVE);
        this.oldValues.put("RECT_SIZE_MULT", Parameters.RECT_SIZE_MULT);
        this.oldValues.put("LAYOUT_SPRING_STRENGHT", Parameters.LAYOUT_SPRING_STRENGHT);
    }

    private void reloadOldValues() {
        if (this.community != null) {
            this.community.setColor((Color)this.oldValues.get("selected_COLOR"));
        }
        Parameters.FONT_COLOR = (Color)this.oldValues.get("FONT_COLOR");
        Parameters.EDGE_COLOR = (Color)this.oldValues.get("EDGE_COLOR");
        Parameters.NODE_COLOR = (Color)this.oldValues.get("NODE_COLOR");
        Parameters.HIGHLIGHT_COLOR = (Color)this.oldValues.get("HIGHLIGHT_COLOR");
        Parameters.OVERLAP_COLOR = (Color)this.oldValues.get("OVERLAP_COLOR");
        Parameters.IS_DRAW_FONT = (Boolean)this.oldValues.get("IS_DRAW_FONT");
        Parameters.USE_PREFUSE = (Boolean)this.oldValues.get("USE_PREFUSE");
        Parameters.IS_DRAW_GRAPH = (Boolean)this.oldValues.get("IS_DRAW_GRAPH");
        Parameters.IS_DRAW_RECT = (Boolean)this.oldValues.get("IS_DRAW_RECT");
        Parameters.IS_NEW_ZOOM = (Boolean)this.oldValues.get("IS_NEW_ZOOM");
        Parameters.IS_DRAW_WEIGHT = (Boolean)this.oldValues.get("IS_DRAW_WEIGHT");
        Parameters.IS_LINE_WIDTH = (Boolean)this.oldValues.get("IS_LINE_WIDTH");
        Parameters.IS_NODE_SIZE = (Boolean)this.oldValues.get("IS_NODE_SIZE");
        Parameters.IS_DRAW_OVERLAP = (Boolean)this.oldValues.get("IS_DRAW_OVERLAP");
        Parameters.IS_CUMULATIVE = (Boolean)this.oldValues.get("IS_CUMULATIVE");
        Parameters.COMMGRAF_DEPTH = (Integer)this.oldValues.get("COMMGRAF_DEPTH");
        Parameters.RECT_SIZE_MULT = (Double)this.oldValues.get("RECT_SIZE_MULT");
        Parameters.LAYOUT_SPRING_STRENGHT = (Double)this.oldValues.get("LAYOUT_SPRING_STRENGHT");
        Parameters.EDGE_HANDLE_SIZE = (Integer)this.oldValues.get("EDGE_HANDLE_SIZE");
        Parameters.DRAG_NEAR_RADIUS = (Double)this.oldValues.get("DRAG_NEAR_RADIUS");
        Parameters.FONT_SIZE = (Integer)this.oldValues.get("FONT_SIZE");
        Parameters.RECT_SIZE = (Integer)this.oldValues.get("RECT_SIZE");
    }

    private Color chooseColor(String t, Color c) {
        Color tmp = JColorChooser.showDialog(this, t, c);
        if (tmp != null) {
            return tmp;
        }
        return c;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.selectedColorButton)) {
            this.selectedColor = this.chooseColor("Choose color of selected community!", this.selectedColor);
        }
        if (arg0.getSource().equals(this.selectedLabelColorButton)) {
            this.selectedLabelColor = this.chooseColor("Choose label color of selected community!", this.selectedLabelColor);
        }
        if (arg0.getSource().equals(this.fontColorButton)) {
            this.fontColor = this.chooseColor("Choose font color!", this.fontColor);
        }
        if (arg0.getSource().equals(this.edgeColorButton)) {
            this.edgeColor = this.chooseColor("Choose edge color!", this.edgeColor);
        }
        if (arg0.getSource().equals(this.nodeColorButton)) {
            this.nodeColor = this.chooseColor("Choose node color!", this.nodeColor);
        }
        if (arg0.getSource().equals(this.highlightColorButton)) {
            this.highlightColor = this.chooseColor("Choose highlight color!", this.highlightColor);
        }
        if (arg0.getSource().equals(this.overlapColorButton)) {
            this.overlapColor = this.chooseColor("Choose overlap color!", this.overlapColor);
        }
        if (arg0.getSource().equals(this.cancelButton)) {
            this.reloadOldValues();
            this.outParamsPanel.maybeWidgetChange();
            this.outParamsPanel.repaintGraphs(this.community);
            this.setVisible(false);
        }
        if (arg0.getSource().equals(this.applyButton) || arg0.getSource().equals(this.okButton)) {
            this.setParametersFromDialog();
            this.outParamsPanel.maybeWidgetChange();
            this.outParamsPanel.repaintGraphs(this.community);
            if (arg0.getSource().equals(this.okButton)) {
                this.setVisible(false);
            }
        }
        if (arg0.getSource().equals(this.defaultButton)) {
            Parameters.setToDefault();
            this.setDialogToParameters();
            this.outParamsPanel.maybeWidgetChange();
            this.outParamsPanel.repaintGraphs(this.community);
        }
        if (arg0.getSource().equals(this.loadButton)) {
            try {
                Parameters.loadFromFile();
                this.setDialogToParameters();
                this.outParamsPanel.maybeWidgetChange();
                this.outParamsPanel.repaintGraphs(this.community);
            }
            catch (IOException e) {
                ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
                e.printStackTrace();
            }
        }
        if (arg0.getSource().equals(this.okButton)) {
            try {
                Parameters.saveToFile();
            }
            catch (IOException e) {
                ExceptionDialog.showExceptionDialog("Internal Error", "An internal error has occured: " + e.getMessage(), e);
                e.printStackTrace();
            }
        }
    }
}

