/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action;

import java.util.logging.Logger;
import prefuse.Visualization;
import prefuse.activity.Activity;

public abstract class Action
extends Activity {
    private static final Logger s_logger = Logger.getLogger(Action.class.getName());
    protected Visualization m_vis;

    public Action() {
        this(null);
    }

    public Action(long duration) {
        super(duration, 15L);
    }

    public Action(long duration, long stepTime) {
        super(duration, stepTime);
    }

    public Action(Visualization vis) {
        this(vis, 0L);
    }

    public Action(Visualization vis, long duration) {
        super(duration, 15L);
        this.m_vis = vis;
    }

    public Action(Visualization vis, long duration, long stepTime) {
        super(duration, stepTime);
        this.m_vis = vis;
    }

    public abstract void run(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(long elapsedTime) {
        Visualization vis = this.getVisualization();
        if (vis != null) {
            try {
                Visualization visualization = vis;
                synchronized (visualization) {
                    this.run(this.getPace(elapsedTime));
                }
            }
            catch (IllegalStateException exc) {
            }
            catch (IllegalArgumentException exc) {}
        } else {
            s_logger.info("Running unsynchronized Action");
            this.run(this.getPace(elapsedTime));
        }
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization vis) {
        this.m_vis = vis;
    }
}

