/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.util.logging.Logger;
import prefuse.action.ItemAction;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class ArrayAnimator
extends ItemAction {
    private static final Logger s_logger = Logger.getLogger(ArrayAnimator.class.getName());
    private String m_field;
    private String m_start;
    private String m_end;

    public ArrayAnimator(String group, String field) {
        super(group);
        this.m_field = field;
        this.m_start = PrefuseLib.getStartField(field);
        this.m_end = PrefuseLib.getEndField(field);
    }

    @Override
    public void process(VisualItem item, double frac) {
        Object o = item.get(this.m_field);
        if (o instanceof float[]) {
            float[] a = (float[])o;
            float[] s = (float[])item.get(this.m_start);
            float[] e = (float[])item.get(this.m_end);
            float f = (float)frac;
            for (int i = 0; i < a.length && !Float.isNaN(a[i]); ++i) {
                a[i] = s[i] + f * (e[i] - s[i]);
            }
            item.setValidated(false);
        } else if (o instanceof double[]) {
            double[] a = (double[])o;
            double[] s = (double[])item.get(this.m_start);
            double[] e = (double[])item.get(this.m_end);
            for (int i = 0; i < a.length && !Double.isNaN(a[i]); ++i) {
                a[i] = s[i] + frac * (e[i] - s[i]);
            }
            item.setValidated(false);
        } else {
            s_logger.warning("Encountered non-double/non-float array type: " + (o == null ? "null" : o.getClass().getName()));
        }
    }
}

