/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import prefuse.action.assignment.ColorAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.visual.VisualItem;

public class DataColorAction
extends ColorAction {
    private String m_dataField;
    private int m_type;
    private int m_scale = 0;
    private int m_tempScale;
    private double[] m_dist;
    private int m_bins = -1;
    private Map m_omap;
    private Object[] m_olist;
    private ColorMap m_cmap = new ColorMap(null, 0.0, 1.0);
    private int[] m_palette;

    public DataColorAction(String group, String dataField, int dataType, String colorField) {
        super(group, colorField);
        this.setDataType(dataType);
        this.setDataField(dataField);
    }

    public DataColorAction(String group, String dataField, int dataType, String colorField, int[] palette) {
        super(group, colorField);
        this.setDataType(dataType);
        this.setDataField(dataField);
        this.m_palette = palette;
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String field) {
        this.m_dataField = field;
    }

    public int getDataType() {
        return this.m_type;
    }

    public void setDataType(int type) {
        if (type < 0 || type >= 3) {
            throw new IllegalArgumentException("Unrecognized data type: " + type);
        }
        this.m_type = type;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        if (scale < 0 || scale >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + scale);
        }
        this.m_scale = scale;
    }

    public int getBinCount() {
        return this.m_bins;
    }

    public void setBinCount(int count) {
        if (this.m_scale == 3 && count <= 0) {
            throw new IllegalArgumentException("The quantile scale can not be used without binning. Use a bin value greater than zero.");
        }
        this.m_bins = count;
    }

    @Override
    public void setDefaultColor(int color) {
        throw new UnsupportedOperationException();
    }

    public void setOrdinalMap(Object[] values) {
        this.m_olist = values;
        this.m_omap = new HashMap();
        for (int i = 0; i < values.length; ++i) {
            this.m_omap.put(values[i], new Integer(i));
        }
    }

    @Override
    protected void setup() {
        int size = 64;
        int[] palette = this.m_palette;
        this.m_tempScale = this.m_scale;
        if (this.m_scale == 3 && this.m_bins <= 0) {
            Logger.getLogger(this.getClass().getName()).warning("Can't use quantile scale with no binning. Defaulting to linear scale. Set the bin value greater than zero to use a quantile scale.");
            this.m_scale = 0;
        }
        switch (this.m_type) {
            case 0: 
            case 1: {
                this.m_dist = this.getDistribution();
                size = this.m_omap.size();
                palette = this.m_palette != null ? this.m_palette : this.createPalette(size);
                this.m_cmap.setColorPalette(palette);
                this.m_cmap.setMinValue(this.m_dist[0]);
                this.m_cmap.setMaxValue(this.m_dist[1]);
                return;
            }
            case 2: {
                this.m_dist = this.getDistribution();
                size = this.m_bins > 0 ? this.m_bins : size;
                palette = this.m_palette != null ? this.m_palette : this.createPalette(size);
                this.m_cmap.setColorPalette(palette);
                this.m_cmap.setMinValue(0.0);
                this.m_cmap.setMaxValue(1.0);
                return;
            }
        }
    }

    @Override
    protected void finish() {
        this.m_scale = this.m_tempScale;
    }

    protected double[] getDistribution() {
        TupleSet ts = this.m_vis.getGroup(this.m_group);
        if (this.m_type == 2) {
            this.m_omap = null;
            if (this.m_scale == 3 && this.m_bins > 0) {
                double[] values = DataLib.toDoubleArray(ts.tuples(), this.m_dataField);
                return MathLib.quantiles(this.m_bins, values);
            }
            double[] dist = new double[]{DataLib.min(ts, this.m_dataField).getDouble(this.m_dataField), DataLib.max(ts, this.m_dataField).getDouble(this.m_dataField)};
            return dist;
        }
        if (this.m_olist == null) {
            this.m_omap = DataLib.ordinalMap(ts, this.m_dataField);
        }
        return new double[]{0.0, this.m_omap.size() - 1};
    }

    protected int[] createPalette(int size) {
        switch (this.m_type) {
            case 0: {
                return ColorLib.getCategoryPalette(size);
            }
        }
        return ColorLib.getGrayscalePalette(size);
    }

    public void setPalette(int[] palette) {
        this.m_palette = palette;
    }

    @Override
    public int getColor(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof ColorAction) {
                return ((ColorAction)o).getColor(item);
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        switch (this.m_type) {
            case 2: {
                double v = item.getDouble(this.m_dataField);
                double f = MathLib.interp(this.m_scale, v, this.m_dist);
                return this.m_cmap.getColor(f);
            }
        }
        Integer idx = (Integer)this.m_omap.get(item.get(this.m_dataField));
        return this.m_cmap.getColor(idx.doubleValue());
    }
}

