/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.awt.Font;
import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;

public class FontAction
extends EncoderAction {
    protected Font defaultFont = FontLib.getFont("SansSerif", 0, 10);

    public FontAction() {
    }

    public FontAction(String group) {
        super(group);
    }

    public FontAction(String group, Font defaultFont) {
        super(group);
        this.defaultFont = defaultFont;
    }

    public void setDefaultFont(Font f) {
        this.defaultFont = f;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void add(Predicate p, Font font) {
        super.add(p, font);
    }

    public void add(String expr, Font font) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, font);
    }

    public void add(Predicate p, FontAction f) {
        super.add(p, f);
    }

    public void add(String expr, FontAction f) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, f);
    }

    @Override
    public void process(VisualItem item, double frac) {
        Font f = this.getFont(item);
        Font o = item.getFont();
        item.setStartFont(o);
        item.setEndFont(f);
        item.setFont(f);
    }

    public Font getFont(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof FontAction) {
                return ((FontAction)o).getFont(item);
            }
            if (o instanceof Font) {
                return (Font)o;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.defaultFont;
    }
}

