/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import java.util.ArrayList;
import prefuse.activity.Activity;
import prefuse.activity.ActivityAdapter;
import prefuse.util.PrefuseConfig;

public class ActivityManager
extends Thread {
    private static ActivityManager s_instance;
    private ArrayList m_activities = new ArrayList();
    private ArrayList m_tmp = new ArrayList();
    private long m_nextTime = Long.MAX_VALUE;
    private boolean m_run;

    private static synchronized ActivityManager getInstance() {
        if (s_instance == null || !s_instance.isAlive()) {
            s_instance = new ActivityManager();
        }
        return s_instance;
    }

    private ActivityManager() {
        super("prefuse_ActivityManager");
        int priority = PrefuseConfig.getInt("activity.threadPriority");
        if (priority >= 1 && priority <= 10) {
            this.setPriority(priority);
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopThread() {
        Class<ActivityManager> clazz = ActivityManager.class;
        synchronized (ActivityManager.class) {
            ActivityManager am = s_instance;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (am != null) {
                am._stop();
            }
            return;
        }
    }

    static void schedule(Activity a) {
        ActivityManager.getInstance()._schedule(a, a.getStartTime());
    }

    static void scheduleNow(Activity a) {
        ActivityManager.getInstance()._schedule(a, System.currentTimeMillis());
    }

    static void scheduleAt(Activity a, long startTime) {
        ActivityManager.getInstance()._schedule(a, startTime);
    }

    static void scheduleAfter(Activity before, Activity after) {
        ActivityManager.getInstance()._scheduleAfter(before, after);
    }

    static void alwaysScheduleAfter(Activity before, Activity after) {
        ActivityManager.getInstance()._alwaysScheduleAfter(before, after);
    }

    static void removeActivity(Activity a) {
        ActivityManager.getInstance()._removeActivity(a);
    }

    public static int activityCount() {
        return ActivityManager.getInstance()._activityCount();
    }

    private synchronized void _stop() {
        while (this.m_activities.size() > 0) {
            Activity a = (Activity)this.m_activities.get(this.m_activities.size() - 1);
            a.cancel();
        }
        this._setRunning(false);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _schedule(Activity a, long startTime) {
        if (a.isScheduled()) {
            return;
        }
        a.setStartTime(startTime);
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.m_activities.add(a);
            a.setScheduled(true);
            if (startTime < this.m_nextTime) {
                this.m_nextTime = startTime;
                this.notify();
            }
        }
    }

    private void _scheduleAfter(Activity before, Activity after) {
        before.addActivityListener(new ScheduleAfterActivity(after, true));
    }

    private void _alwaysScheduleAfter(Activity before, Activity after) {
        before.addActivityListener(new ScheduleAfterActivity(after, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeActivity(Activity a) {
        boolean r;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            r = this.m_activities.remove(a);
            if (r && this.m_activities.size() == 0) {
                this.m_nextTime = Long.MAX_VALUE;
            }
        }
        if (r) {
            a.setScheduled(false);
        }
        return r;
    }

    private synchronized int _activityCount() {
        return this.m_activities.size();
    }

    private synchronized void _setRunning(boolean b) {
        this.m_run = b;
    }

    private synchronized boolean _keepRunning() {
        return this.m_run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._setRunning(true);
        while (this._keepRunning()) {
            if (this._activityCount() > 0) {
                long currentTime = System.currentTimeMillis();
                long t = -1L;
                ActivityManager activityManager = this;
                synchronized (activityManager) {
                    for (int i = 0; i < this.m_activities.size(); ++i) {
                        Activity a = (Activity)this.m_activities.get(i);
                        this.m_tmp.add(a);
                        if (currentTime < a.getStopTime()) continue;
                        this.m_activities.remove(i--);
                        a.setScheduled(false);
                    }
                    if (this.m_activities.size() == 0) {
                        this.m_nextTime = Long.MAX_VALUE;
                    }
                }
                for (int i = 0; i < this.m_tmp.size(); ++i) {
                    Activity a = (Activity)this.m_tmp.get(i);
                    long s = a.runActivity(currentTime);
                    t = s < 0L ? t : (t < 0L ? s : Math.min(t, s));
                }
                this.m_tmp.clear();
                if (t == -1L) continue;
                try {
                    ActivityManager i = this;
                    synchronized (i) {
                        this.wait(t);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
            }
            try {
                ActivityManager currentTime = this;
                synchronized (currentTime) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public class ScheduleAfterActivity
    extends ActivityAdapter {
        Activity after;
        boolean remove;

        public ScheduleAfterActivity(Activity after, boolean remove) {
            this.after = after;
            this.remove = remove;
        }

        @Override
        public void activityFinished(Activity a) {
            if (this.remove) {
                a.removeActivityListener(this);
            }
            ActivityManager.scheduleNow(this.after);
        }

        @Override
        public void activityCancelled(Activity a) {
            if (this.remove) {
                a.removeActivityListener(this);
            }
        }
    }
}

