/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.controls.AbstractZoomControl;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomControl
extends AbstractZoomControl {
    private int yLast;
    private Point2D down = new Point2D.Float();
    private int button = 4;

    public ZoomControl() {
    }

    public ZoomControl(int mouseButton) {
        this.button = mouseButton;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            Display display = (Display)e.getComponent();
            if (display.isTranformInProgress()) {
                this.yLast = -1;
                return;
            }
            display.setCursor(Cursor.getPredefinedCursor(8));
            display.getAbsoluteCoordinate(e.getPoint(), this.down);
            this.yLast = e.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            Display display = (Display)e.getComponent();
            if (display.isTranformInProgress() || this.yLast == -1) {
                this.yLast = -1;
                return;
            }
            int y = e.getY();
            int dy = y - this.yLast;
            double zoom = 1.0 + (double)dy / 100.0;
            int status = this.zoom(display, this.down, zoom, true);
            int cursor = 8;
            if (status == 3) {
                cursor = 3;
            }
            display.setCursor(Cursor.getPredefinedCursor(cursor));
            this.yLast = y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void itemPressed(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mousePressed(e);
        }
    }

    @Override
    public void itemDragged(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mouseDragged(e);
        }
    }

    @Override
    public void itemReleased(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mouseReleased(e);
        }
    }
}

