/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.util.PrefuseConfig;
import prefuse.util.collections.IntIterator;

public class Tree
extends Graph {
    private static final Logger s_logger = Logger.getLogger(Tree.class.getName());
    public static final String DEFAULT_SOURCE_KEY = PrefuseConfig.get("data.tree.sourceKey");
    public static final String DEFAULT_TARGET_KEY = PrefuseConfig.get("data.tree.targetKey");
    protected int m_root = -1;
    protected static final String CHILDINDEX = "_childIndex";
    protected static final Schema TREE_LINKS_SCHEMA = new Schema();

    public Tree() {
        super(new Table(), false);
    }

    public Tree(Table nodes, Table edges) {
        this(nodes, edges, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Tree(Table nodes, Table edges, String sourceKey, String targetKey) {
        this(nodes, edges, DEFAULT_NODE_KEY, sourceKey, targetKey);
    }

    public Tree(Table nodes, Table edges, String nodeKey, String sourceKey, String targetKey) {
        super(nodes, edges, false, nodeKey, sourceKey, targetKey);
        IntIterator rows = nodes.rows();
        while (rows.hasNext()) {
            int n = rows.nextInt();
            if (this.getParent(n) >= 0) continue;
            this.m_root = n;
            break;
        }
    }

    void setRoot(Node root) {
        this.m_root = root.getRow();
    }

    @Override
    protected Table createLinkTable() {
        Table links = super.createLinkTable();
        links.addColumns(TREE_LINKS_SCHEMA);
        return links;
    }

    @Override
    protected void updateDegrees(int e, int s, int t, int incr) {
        super.updateDegrees(e, s, t, incr);
        int od = this.getOutDegree(s);
        if (incr > 0) {
            this.m_links.setInt(t, CHILDINDEX, od - 1);
        } else if (incr < 0) {
            int[] links = (int[])this.m_links.get(s, "_outlinks");
            for (int i = 0; i < od; ++i) {
                int n = this.getTargetNode(links[i]);
                this.m_links.setInt(n, CHILDINDEX, i);
            }
            this.m_links.setInt(t, CHILDINDEX, -1);
        }
    }

    public int addRootRow() {
        if (this.getNodeCount() != 0) {
            throw new IllegalStateException("Can only add a root node to an empty tree");
        }
        this.m_root = this.addNodeRow();
        return this.m_root;
    }

    public Node addRoot() {
        return this.getNode(this.addRootRow());
    }

    public int addChild(int parent) {
        int child = super.addNodeRow();
        this.addChildEdge(parent, child);
        return child;
    }

    public Node addChild(Node parent) {
        this.nodeCheck(parent, true);
        return this.getNode(this.addChild(parent.getRow()));
    }

    public int addChildEdge(int parent, int child) {
        return super.addEdge(parent, child);
    }

    public Edge addChildEdge(Node parent, Node child) {
        this.nodeCheck(parent, true);
        this.nodeCheck(child, true);
        return this.getEdge(this.addChildEdge(parent.getRow(), child.getRow()));
    }

    public boolean removeChildEdge(int edge) {
        return this.removeChild(this.getTargetNode(edge));
    }

    public boolean removeChildEdge(Edge e) {
        this.edgeCheck(e, true);
        return this.removeChild(this.getTargetNode(e.getRow()));
    }

    public boolean removeChild(int node) {
        while (this.getChildCount(node) > 0) {
            this.removeChild(this.getLastChildRow(node));
        }
        return this.removeNode(node);
    }

    public boolean removeChild(Node n) {
        this.nodeCheck(n, true);
        return this.removeChild(n.getRow());
    }

    public int getRootRow() {
        return this.m_root;
    }

    public Node getRoot() {
        return (Node)this.m_nodeTuples.getTuple(this.m_root);
    }

    public int getChildRow(int node, int idx) {
        int cc = this.getChildCount(node);
        if (idx < 0 || idx >= cc) {
            return -1;
        }
        int[] links = (int[])this.m_links.get(node, "_outlinks");
        return this.getTargetNode(links[idx]);
    }

    public Node getChild(Node node, int idx) {
        int c = this.getChildRow(node.getRow(), idx);
        return c < 0 ? null : this.getNode(c);
    }

    public int getChildIndex(int parent, int child) {
        if (this.getParent(child) != parent) {
            return -1;
        }
        return this.m_links.getInt(child, CHILDINDEX);
    }

    public int getChildIndex(Node p, Node c) {
        return this.getChildIndex(p.getRow(), c.getRow());
    }

    public int getFirstChildRow(int node) {
        return this.getChildRow(node, 0);
    }

    public Node getFirstChild(Node node) {
        return this.getChild(node, 0);
    }

    public int getLastChildRow(int node) {
        return this.getChildRow(node, this.getChildCount(node) - 1);
    }

    public Node getLastChild(Node node) {
        return this.getChild(node, node.getChildCount() - 1);
    }

    public int getPreviousSiblingRow(int node) {
        int p = this.getParent(node);
        if (p < 0) {
            return -1;
        }
        int[] links = (int[])this.m_links.get(p, "_outlinks");
        int idx = this.m_links.getInt(node, CHILDINDEX);
        return idx <= 0 ? -1 : this.getTargetNode(links[idx - 1]);
    }

    public Node getPreviousSibling(Node node) {
        int n = this.getPreviousSiblingRow(node.getRow());
        return n < 0 ? null : this.getNode(n);
    }

    public int getNextSiblingRow(int node) {
        int p = this.getParent(node);
        if (p < 0) {
            return -1;
        }
        int[] links = (int[])this.m_links.get(p, "_outlinks");
        int idx = this.m_links.getInt(node, CHILDINDEX);
        int max = this.getChildCount(p) - 1;
        return idx < 0 || idx >= max ? -1 : this.getTargetNode(links[idx + 1]);
    }

    public Node getNextSibling(Node node) {
        int n = this.getNextSiblingRow(node.getRow());
        return n < 0 ? null : this.getNode(n);
    }

    public int getDepth(int node) {
        if (!this.getNodeTable().isValidRow(node)) {
            return -1;
        }
        int depth = 0;
        int i = node;
        while (i != this.m_root && i >= 0) {
            ++depth;
            i = this.getParent(i);
        }
        return depth;
    }

    public int getChildCount(int node) {
        return this.getOutDegree(node);
    }

    public int getParentEdge(int node) {
        if (this.getInDegree(node) > 0) {
            int[] inlinks = (int[])this.m_links.get(node, "_inlinks");
            return inlinks[0];
        }
        return -1;
    }

    public Edge getParentEdge(Node n) {
        this.nodeCheck(n, true);
        int pe = this.getParentEdge(n.getRow());
        return pe < 0 ? null : this.getEdge(pe);
    }

    public int getParent(int node) {
        int pe = this.getParentEdge(node);
        return pe < 0 ? -1 : this.getSourceNode(pe);
    }

    public Node getParent(Node n) {
        int p = this.getParent(n.getRow());
        return p < 0 ? null : this.getNode(p);
    }

    public IntIterator childEdgeRows(int node) {
        return super.outEdgeRows(node);
    }

    public Iterator childEdges(Node n) {
        return super.outEdges(n);
    }

    public Iterator children(Node n) {
        return super.outNeighbors(n);
    }

    public boolean isValidTree() {
        int nedges;
        int nnodes = this.getNodeCount();
        if (nnodes != (nedges = this.getEdgeCount()) + 1) {
            s_logger.warning("Node/edge counts incorrect.");
            return false;
        }
        int root = this.getRootRow();
        IntIterator nodes = this.getNodeTable().rows();
        while (nodes.hasNext()) {
            int n = nodes.nextInt();
            int id = this.getInDegree(n);
            if (n == root && id > 0) {
                s_logger.warning("Root node has a parent.");
                return false;
            }
            if (id <= 1) continue;
            s_logger.warning("Node " + n + " has multiple parents.");
            return false;
        }
        int[] counts = new int[]{0, nedges};
        this.isValidHelper(this.getRootRow(), counts);
        if (counts[0] > nedges) {
            s_logger.warning("The tree has non-tree edges in it.");
            return false;
        }
        if (counts[0] < nedges) {
            s_logger.warning("Not all of the tree was visited. Only " + counts[0] + "/" + nedges + " edges encountered");
            return false;
        }
        return true;
    }

    private void isValidHelper(int node, int[] counts) {
        IntIterator edges = this.childEdgeRows(node);
        int ncount = 0;
        while (edges.hasNext()) {
            int edge = edges.nextInt();
            ++ncount;
            counts[0] = counts[0] + 1;
            int c = this.getAdjacentNode(edge, node);
            this.isValidHelper(c, counts);
            if (counts[0] <= counts[1]) continue;
            return;
        }
    }

    @Override
    public Tree getSpanningTree() {
        return this.m_spanning == null ? this : this.m_spanning;
    }

    @Override
    public Tree getSpanningTree(Node root) {
        this.nodeCheck(root, true);
        if (this.m_spanning == null) {
            if (this.m_root == root.getRow()) {
                return this;
            }
            this.m_spanning = new SpanningTree(this, root);
        } else if (this.m_spanning.getRoot() != root) {
            this.m_spanning.buildSpanningTree(root);
        }
        return this.m_spanning;
    }

    static {
        TREE_LINKS_SCHEMA.addColumn(CHILDINDEX, Integer.TYPE, new Integer(-1));
        TREE_LINKS_SCHEMA.lockSchema();
    }
}

