/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphReader;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.collections.IntIterator;

public class GraphMLReader
extends AbstractGraphReader
implements GraphReader {
    @Override
    public Graph readGraph(InputStream is) throws DataIOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            GraphMLHandler handler = new GraphMLHandler();
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getGraph();
        }
        catch (Exception e) {
            if (e instanceof DataIOException) {
                throw (DataIOException)e;
            }
            throw new DataIOException(e);
        }
    }

    public static class GraphMLHandler
    extends DefaultHandler
    implements Tokens {
        protected ParserFactory m_pf = ParserFactory.getDefaultFactory();
        protected static final String SRC = Graph.DEFAULT_SOURCE_KEY;
        protected static final String TRG = Graph.DEFAULT_TARGET_KEY;
        protected static final String SRCID = SRC + '_' + "id";
        protected static final String TRGID = TRG + '_' + "id";
        protected Schema m_nsch = new Schema();
        protected Schema m_esch = new Schema();
        protected String m_graphid;
        protected Graph m_graph = null;
        protected Table m_nodes;
        protected Table m_edges;
        protected String m_id;
        protected String m_for;
        protected String m_name;
        protected String m_type;
        protected String m_dflt;
        protected StringBuffer m_sbuf = new StringBuffer();
        private String m_key;
        private int m_row = -1;
        private Table m_table = null;
        protected HashMap m_nodeMap = new HashMap();
        protected HashMap m_idMap = new HashMap();
        private boolean m_directed = false;
        private boolean inSchema;

        @Override
        public void startDocument() {
            this.m_nodeMap.clear();
            this.inSchema = true;
            this.m_esch.addColumn(SRC, Integer.TYPE);
            this.m_esch.addColumn(TRG, Integer.TYPE);
            this.m_esch.addColumn(SRCID, String.class);
            this.m_esch.addColumn(TRGID, String.class);
        }

        @Override
        public void endDocument() throws SAXException {
            IntIterator rows = this.m_edges.rows();
            while (rows.hasNext()) {
                int r = rows.nextInt();
                String src = this.m_edges.getString(r, SRCID);
                if (!this.m_nodeMap.containsKey(src)) {
                    throw new SAXException("Tried to create edge with source node id=" + src + " which does not exist.");
                }
                int s = (Integer)this.m_nodeMap.get(src);
                this.m_edges.setInt(r, SRC, s);
                String trg = this.m_edges.getString(r, TRGID);
                if (!this.m_nodeMap.containsKey(trg)) {
                    throw new SAXException("Tried to create edge with target node id=" + trg + " which does not exist.");
                }
                int t = (Integer)this.m_nodeMap.get(trg);
                this.m_edges.setInt(r, TRG, t);
            }
            this.m_edges.removeColumn(SRCID);
            this.m_edges.removeColumn(TRGID);
            this.m_graph = new Graph(this.m_nodes, this.m_edges, this.m_directed);
            if (this.m_graphid != null) {
                this.m_graph.putClientProperty("id", this.m_graphid);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.m_sbuf.delete(0, this.m_sbuf.length());
            if (qName.equals("graph")) {
                String edef = atts.getValue("edgedefault");
                this.m_directed = "directed".equalsIgnoreCase(edef);
                this.m_graphid = atts.getValue("id");
            } else if (qName.equals("key")) {
                if (!this.inSchema) {
                    this.error("\"key\" elements can not occur after the first node or edge declaration.");
                }
                this.m_for = atts.getValue("for");
                this.m_id = atts.getValue("id");
                this.m_name = atts.getValue("attr.name");
                this.m_type = atts.getValue("attr.type");
            } else if (qName.equals("node")) {
                this.schemaCheck();
                this.m_row = this.m_nodes.addRow();
                String id = atts.getValue("id");
                this.m_nodeMap.put(id, new Integer(this.m_row));
                this.m_table = this.m_nodes;
            } else if (qName.equals("edge")) {
                this.schemaCheck();
                this.m_row = this.m_edges.addRow();
                this.m_edges.setString(this.m_row, SRCID, atts.getValue(SRC));
                this.m_edges.setString(this.m_row, TRGID, atts.getValue(TRG));
                this.m_table = this.m_edges;
            } else if (qName.equals("data")) {
                this.m_key = atts.getValue("key");
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("default")) {
                this.m_dflt = this.m_sbuf.toString();
            } else if (qName.equals("key")) {
                this.addToSchema();
            } else if (qName.equals("data")) {
                String value = this.m_sbuf.toString();
                String name = (String)this.m_idMap.get(this.m_key);
                Class type = this.m_table.getColumnType(name);
                try {
                    Object val = this.parse(value, type);
                    this.m_table.set(this.m_row, name, val);
                }
                catch (DataParseException dpe) {
                    this.error(dpe);
                }
            } else if (qName.equals("node") || qName.equals("edge")) {
                this.m_row = -1;
                this.m_table = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.m_sbuf.append(ch, start, length);
        }

        protected void schemaCheck() {
            if (this.inSchema) {
                this.m_nsch.lockSchema();
                this.m_esch.lockSchema();
                this.m_nodes = this.m_nsch.instantiate();
                this.m_edges = this.m_esch.instantiate();
                this.inSchema = false;
            }
        }

        protected void addToSchema() {
            if (this.m_name == null || this.m_name.length() == 0) {
                this.error("Empty key name.");
            }
            if (this.m_type == null || this.m_type.length() == 0) {
                this.error("Empty key type.");
            }
            try {
                Object dflt;
                Class type = this.parseType(this.m_type);
                Object object = dflt = this.m_dflt == null ? null : this.parse(this.m_dflt, type);
                if (this.m_for == null || this.m_for.equals("all")) {
                    this.m_nsch.addColumn(this.m_name, type, dflt);
                    this.m_esch.addColumn(this.m_name, type, dflt);
                } else if (this.m_for.equals("node")) {
                    this.m_nsch.addColumn(this.m_name, type, dflt);
                } else if (this.m_for.equals("edge")) {
                    this.m_esch.addColumn(this.m_name, type, dflt);
                } else {
                    this.error("Unrecognized \"for\" value: " + this.m_for);
                }
                this.m_idMap.put(this.m_id, this.m_name);
                this.m_dflt = null;
            }
            catch (DataParseException dpe) {
                this.error(dpe);
            }
        }

        protected Class parseType(String type) {
            if ((type = type.toLowerCase()).equals("int") || type.equals("integer")) {
                return Integer.TYPE;
            }
            if (type.equals("long")) {
                return Long.TYPE;
            }
            if (type.equals("float")) {
                return Float.TYPE;
            }
            if (type.equals("double") || type.equals("real")) {
                return Double.TYPE;
            }
            if (type.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("string")) {
                return String.class;
            }
            if (type.equals("date")) {
                return Date.class;
            }
            this.error("Unrecognized data type: " + type);
            return null;
        }

        protected Object parse(String s, Class type) throws DataParseException {
            DataParser dp = this.m_pf.getParser(type);
            return dp.parse(s);
        }

        public Graph getGraph() {
            return this.m_graph;
        }

        protected void error(String s) {
            throw new RuntimeException(s);
        }

        protected void error(Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Tokens {
        public static final String ID = "id";
        public static final String GRAPH = "graph";
        public static final String EDGEDEF = "edgedefault";
        public static final String DIRECTED = "directed";
        public static final String UNDIRECTED = "undirected";
        public static final String KEY = "key";
        public static final String FOR = "for";
        public static final String ALL = "all";
        public static final String ATTRNAME = "attr.name";
        public static final String ATTRTYPE = "attr.type";
        public static final String DEFAULT = "default";
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String DATA = "data";
        public static final String TYPE = "type";
        public static final String INT = "int";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String REAL = "real";
        public static final String BOOLEAN = "boolean";
        public static final String STRING = "string";
        public static final String DATE = "date";
    }
}

