/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class DateParser
implements DataParser {
    protected DateFormat m_dfmt;
    protected ParsePosition m_pos;

    public DateParser() {
        this(DateFormat.getDateInstance(3));
    }

    public DateParser(DateFormat dateFormat) {
        this.m_dfmt = dateFormat;
        this.m_pos = new ParsePosition(0);
    }

    @Override
    public Class getType() {
        return java.sql.Date.class;
    }

    @Override
    public String format(Object value) {
        return value == null ? null : this.m_dfmt.format(value);
    }

    @Override
    public boolean canParse(String text) {
        try {
            this.parseDate(text);
            return true;
        }
        catch (DataParseException e) {
            return false;
        }
    }

    @Override
    public Object parse(String text) throws DataParseException {
        return this.parseDate(text);
    }

    public java.sql.Date parseDate(String text) throws DataParseException {
        Date d1;
        this.m_pos.setErrorIndex(0);
        this.m_pos.setIndex(0);
        java.sql.Date d = null;
        try {
            d = java.sql.Date.valueOf(text);
            this.m_pos.setIndex(text.length());
        }
        catch (IllegalArgumentException e) {
            d = null;
        }
        if (d == null && (d1 = this.m_dfmt.parse(text, this.m_pos)) != null) {
            d = new java.sql.Date(d1.getTime());
        }
        if (d == null || this.m_pos.getIndex() < text.length()) {
            throw new DataParseException("Could not parse Date: " + text);
        }
        return d;
    }
}

