/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class IntParser
implements DataParser {
    @Override
    public Class getType() {
        return Integer.TYPE;
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).intValue());
    }

    @Override
    public boolean canParse(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Object parse(String text) throws DataParseException {
        return new Integer(IntParser.parseInt(text));
    }

    public static int parseInt(String text) throws DataParseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

