/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.util.Iterator;
import java.util.StringTokenizer;
import prefuse.data.Tuple;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.search.Trie;

public class PrefixSearchTupleSet
extends SearchTupleSet {
    private Trie m_trie;
    private Trie.TrieNode m_curNode;
    private String m_delim = " \t\n\r";
    private String m_query = "";

    public PrefixSearchTupleSet() {
        this(false);
    }

    public PrefixSearchTupleSet(boolean caseSensitive) {
        this.m_trie = new Trie(caseSensitive);
    }

    public String getDelimiterString() {
        return this.m_delim;
    }

    public void setDelimiterString(String delim) {
        this.m_delim = delim;
    }

    @Override
    public String getQuery() {
        return this.m_query;
    }

    @Override
    public void search(String query) {
        if (query == null) {
            query = "";
        }
        if (query.equals(this.m_query)) {
            return;
        }
        Tuple[] rem = this.clearInternal();
        this.m_query = query;
        StringTokenizer st = new StringTokenizer(this.m_query, this.m_delim);
        if (!st.hasMoreTokens()) {
            this.m_query = "";
        }
        while (st.hasMoreTokens()) {
            this.prefixSearch(st.nextToken());
        }
        Tuple[] add = this.getTupleCount() > 0 ? this.toArray() : null;
        this.fireTupleEvent(add, rem);
    }

    private void prefixSearch(String query) {
        this.m_curNode = this.m_trie.find(query);
        if (this.m_curNode != null) {
            Iterator iter = this.trieIterator();
            while (iter.hasNext()) {
                this.addInternal((Tuple)iter.next());
            }
        }
    }

    @Override
    public void index(Tuple t, String field) {
        String s = t.getString(field);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, this.m_delim);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.addString(tok, t);
        }
    }

    private void addString(String s, Tuple t) {
        this.m_trie.addString(s, t);
    }

    @Override
    public boolean isUnindexSupported() {
        return true;
    }

    @Override
    public void unindex(Tuple t, String field) {
        String s = t.getString(field);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, this.m_delim);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.removeString(tok, t);
        }
    }

    @Override
    public void clear() {
        this.m_trie = new Trie(this.m_trie.isCaseSensitive());
        super.clear();
    }

    private void removeString(String s, Tuple t) {
        this.m_trie.removeString(s, t);
    }

    private Iterator trieIterator() {
        Trie trie = this.m_trie;
        trie.getClass();
        return new Trie.TrieIterator(trie, this.m_curNode);
    }
}

