/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.tuple.TableTuple;

public class TableNode
extends TableTuple
implements Node {
    protected Graph m_graph;

    @Override
    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_graph = graph;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    @Override
    public Graph getGraph() {
        return this.m_graph;
    }

    @Override
    public int getInDegree() {
        return this.m_graph.getInDegree(this);
    }

    @Override
    public int getOutDegree() {
        return this.m_graph.getOutDegree(this);
    }

    @Override
    public int getDegree() {
        return this.m_graph.getDegree(this);
    }

    @Override
    public Iterator inEdges() {
        return this.m_graph.inEdges(this);
    }

    @Override
    public Iterator outEdges() {
        return this.m_graph.outEdges(this);
    }

    @Override
    public Iterator edges() {
        return this.m_graph.edges(this);
    }

    @Override
    public Iterator inNeighbors() {
        return this.m_graph.inNeighbors(this);
    }

    @Override
    public Iterator outNeighbors() {
        return this.m_graph.outNeighbors(this);
    }

    @Override
    public Iterator neighbors() {
        return this.m_graph.neighbors(this);
    }

    @Override
    public Node getParent() {
        return this.m_graph.getSpanningTree().getParent(this);
    }

    @Override
    public Edge getParentEdge() {
        return this.m_graph.getSpanningTree().getParentEdge(this);
    }

    @Override
    public int getChildCount() {
        return this.m_graph.getSpanningTree().getChildCount(this.m_row);
    }

    @Override
    public int getChildIndex(Node child) {
        return this.m_graph.getSpanningTree().getChildIndex(this, child);
    }

    @Override
    public Node getChild(int idx) {
        return this.m_graph.getSpanningTree().getChild(this, idx);
    }

    @Override
    public Node getFirstChild() {
        return this.m_graph.getSpanningTree().getFirstChild(this);
    }

    @Override
    public Node getLastChild() {
        return this.m_graph.getSpanningTree().getLastChild(this);
    }

    @Override
    public Node getPreviousSibling() {
        return this.m_graph.getSpanningTree().getPreviousSibling(this);
    }

    @Override
    public Node getNextSibling() {
        return this.m_graph.getSpanningTree().getNextSibling(this);
    }

    @Override
    public Iterator children() {
        return this.m_graph.getSpanningTree().children(this);
    }

    @Override
    public Iterator childEdges() {
        return this.m_graph.getSpanningTree().childEdges(this);
    }

    @Override
    public int getDepth() {
        return this.m_graph.getSpanningTree().getDepth(this.m_row);
    }
}

