/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.BitSet;
import java.util.NoSuchElementException;
import prefuse.util.collections.IntIterator;

public class UniqueRowIterator
extends IntIterator {
    private IntIterator m_iter;
    private int m_next;
    private BitSet m_visited;

    public UniqueRowIterator(IntIterator iter) {
        this.m_iter = iter;
        this.m_visited = new BitSet();
        this.advance();
    }

    private void advance() {
        int r = -1;
        while (r == -1 && this.m_iter.hasNext()) {
            r = this.m_iter.nextInt();
            if (!this.visit(r)) continue;
            r = -1;
        }
        this.m_next = r;
    }

    private boolean visit(int row) {
        if (this.m_visited.get(row)) {
            return true;
        }
        this.m_visited.set(row);
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != -1;
    }

    @Override
    public int nextInt() {
        if (this.m_next == -1) {
            throw new NoSuchElementException();
        }
        int retval = this.m_next;
        this.advance();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

