/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StrokeLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class EdgeRenderer
extends AbstractShapeRenderer {
    public static final String EDGE_TYPE = "edgeType";
    protected static final double HALF_PI = 1.5707963267948966;
    protected Line2D m_line = new Line2D.Float();
    protected CubicCurve2D m_cubic = new CubicCurve2D.Float();
    protected int m_edgeType = 0;
    protected int m_xAlign1 = 2;
    protected int m_yAlign1 = 2;
    protected int m_xAlign2 = 2;
    protected int m_yAlign2 = 2;
    protected double m_width = 1.0;
    protected float m_curWidth = 1.0f;
    protected Point2D[] m_tmpPoints = new Point2D[2];
    protected Point2D[] m_ctrlPoints = new Point2D[2];
    protected Point2D[] m_isctPoints = new Point2D[2];
    protected int m_edgeArrow = 1;
    protected int m_arrowWidth = 8;
    protected int m_arrowHeight = 12;
    protected Polygon m_arrowHead = this.updateArrowHead(this.m_arrowWidth, this.m_arrowHeight);
    protected AffineTransform m_arrowTrans = new AffineTransform();
    protected Shape m_curArrow;

    public EdgeRenderer() {
        this.m_tmpPoints[0] = new Point2D.Float();
        this.m_tmpPoints[1] = new Point2D.Float();
        this.m_ctrlPoints[0] = new Point2D.Float();
        this.m_ctrlPoints[1] = new Point2D.Float();
        this.m_isctPoints[0] = new Point2D.Float();
        this.m_isctPoints[1] = new Point2D.Float();
    }

    public EdgeRenderer(int edgeType) {
        this(edgeType, 1);
    }

    public EdgeRenderer(int edgeType, int arrowType) {
        this();
        this.setEdgeType(edgeType);
        this.setArrowType(arrowType);
    }

    @Override
    public int getRenderType(VisualItem item) {
        return 1;
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        EdgeItem edge = (EdgeItem)item;
        NodeItem item1 = edge.getSourceItem();
        NodeItem item2 = edge.getTargetItem();
        int type = this.m_edgeType;
        EdgeRenderer.getAlignedPoint(this.m_tmpPoints[0], item1.getBounds(), this.m_xAlign1, this.m_yAlign1);
        EdgeRenderer.getAlignedPoint(this.m_tmpPoints[1], item2.getBounds(), this.m_xAlign2, this.m_yAlign2);
        this.m_curWidth = (float)(this.m_width * this.getLineWidth(item));
        EdgeItem e = (EdgeItem)item;
        if (e.isDirected() && this.m_edgeArrow != 0) {
            NodeItem dest;
            boolean forward = this.m_edgeArrow == 1;
            Point2D start = null;
            Point2D end = null;
            start = this.m_tmpPoints[forward ? 0 : 1];
            int i = GraphicsLib.intersectLineRectangle(start, end = this.m_tmpPoints[forward ? 1 : 0], (dest = forward ? e.getTargetItem() : e.getSourceItem()).getBounds(), this.m_isctPoints);
            if (i > 0) {
                end = this.m_isctPoints[0];
            }
            AffineTransform at = this.getArrowTrans(start, end, this.m_curWidth);
            this.m_curArrow = at.createTransformedShape(this.m_arrowHead);
            Point2D lineEnd = this.m_tmpPoints[forward ? 1 : 0];
            lineEnd.setLocation(0.0, -this.m_arrowHeight);
            at.transform(lineEnd, lineEnd);
        } else {
            this.m_curArrow = null;
        }
        Shape shape = null;
        double n1x = this.m_tmpPoints[0].getX();
        double n1y = this.m_tmpPoints[0].getY();
        double n2x = this.m_tmpPoints[1].getX();
        double n2y = this.m_tmpPoints[1].getY();
        switch (type) {
            case 0: {
                this.m_line.setLine(n1x, n1y, n2x, n2y);
                shape = this.m_line;
                break;
            }
            case 1: {
                this.getCurveControlPoints(edge, this.m_ctrlPoints, n1x, n1y, n2x, n2y);
                this.m_cubic.setCurve(n1x, n1y, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), n2x, n2y);
                shape = this.m_cubic;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown edge type");
            }
        }
        return shape;
    }

    @Override
    public void render(Graphics2D g, VisualItem item) {
        super.render(g, item);
        if (this.m_curArrow != null) {
            g.setPaint(ColorLib.getColor(item.getFillColor()));
            g.fill(this.m_curArrow);
            this.drawShape(g, item, this.m_curArrow);
        }
    }

    protected AffineTransform getArrowTrans(Point2D p1, Point2D p2, double width) {
        this.m_arrowTrans.setToTranslation(p2.getX(), p2.getY());
        this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX()));
        if (width > 1.0) {
            double scalar = width / 4.0;
            this.m_arrowTrans.scale(scalar, scalar);
        }
        return this.m_arrowTrans;
    }

    protected Polygon updateArrowHead(int w, int h) {
        if (this.m_arrowHead == null) {
            this.m_arrowHead = new Polygon();
        } else {
            this.m_arrowHead.reset();
        }
        this.m_arrowHead.addPoint(0, 0);
        this.m_arrowHead.addPoint(-w / 2, -h);
        this.m_arrowHead.addPoint(w / 2, -h);
        this.m_arrowHead.addPoint(0, 0);
        return this.m_arrowHead;
    }

    @Override
    protected AffineTransform getTransform(VisualItem item) {
        return null;
    }

    @Override
    public boolean locatePoint(Point2D p, VisualItem item) {
        Shape s = this.getShape(item);
        if (s == null) {
            return false;
        }
        double width = Math.max(2.0, this.getLineWidth(item));
        double halfWidth = width / 2.0;
        return s.intersects(p.getX() - halfWidth, p.getY() - halfWidth, width, width);
    }

    @Override
    public void setBounds(VisualItem item) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(item);
        if (shape == null) {
            item.setBounds(item.getX(), item.getY(), 0.0, 0.0);
            return;
        }
        GraphicsLib.setBounds(item, shape, this.getStroke(item));
        if (this.m_curArrow != null) {
            Rectangle2D bbox = (Rectangle2D)item.get(VisualItem.BOUNDS);
            Rectangle2D.union(bbox, this.m_curArrow.getBounds2D(), bbox);
        }
    }

    protected double getLineWidth(VisualItem item) {
        return item.getSize();
    }

    @Override
    protected BasicStroke getStroke(VisualItem item) {
        return StrokeLib.getDerivedStroke(item.getStroke(), this.m_curWidth);
    }

    protected void getCurveControlPoints(EdgeItem eitem, Point2D[] cp, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        cp[0].setLocation(x1 + 2.0 * dx / 3.0, y1);
        cp[1].setLocation(x2 - dx / 8.0, y2 - dy / 8.0);
    }

    protected static void getAlignedPoint(Point2D p, Rectangle2D r, int xAlign, int yAlign) {
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        if (xAlign == 2) {
            x += w / 2.0;
        } else if (xAlign == 1) {
            x += w;
        }
        if (yAlign == 2) {
            y += h / 2.0;
        } else if (yAlign == 3) {
            y += h;
        }
        p.setLocation(x, y);
    }

    public int getEdgeType() {
        return this.m_edgeType;
    }

    public void setEdgeType(int type) {
        if (type < 0 || type >= 2) {
            throw new IllegalArgumentException("Unrecognized edge curve type: " + type);
        }
        this.m_edgeType = type;
    }

    public int getArrowType() {
        return this.m_edgeArrow;
    }

    public void setArrowType(int type) {
        if (type < 0 || type >= 3) {
            throw new IllegalArgumentException("Unrecognized edge arrow type: " + type);
        }
        this.m_edgeArrow = type;
    }

    public void setArrowHeadSize(int width, int height) {
        this.m_arrowWidth = width;
        this.m_arrowHeight = height;
        this.m_arrowHead = this.updateArrowHead(width, height);
    }

    public int getArrowHeadHeight() {
        return this.m_arrowHeight;
    }

    public int getArrowHeadWidth() {
        return this.m_arrowWidth;
    }

    public int getHorizontalAlignment1() {
        return this.m_xAlign1;
    }

    public int getVerticalAlignment1() {
        return this.m_yAlign1;
    }

    public int getHorizontalAlignment2() {
        return this.m_xAlign2;
    }

    public int getVerticalAlignment2() {
        return this.m_yAlign2;
    }

    public void setHorizontalAlignment1(int align) {
        this.m_xAlign1 = align;
    }

    public void setVerticalAlignment1(int align) {
        this.m_yAlign1 = align;
    }

    public void setHorizontalAlignment2(int align) {
        this.m_xAlign2 = align;
    }

    public void setVerticalAlignment2(int align) {
        this.m_yAlign2 = align;
    }

    public void setDefaultLineWidth(double w) {
        this.m_width = w;
    }

    public double getDefaultLineWidth() {
        return this.m_width;
    }
}

