/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import prefuse.data.Tuple;
import prefuse.util.io.IOLib;

public class ImageFactory {
    protected int m_imageCacheSize = 3000;
    protected int m_maxImageWidth = 100;
    protected int m_maxImageHeight = 100;
    protected boolean m_asynch = true;
    protected Map imageCache = new LinkedHashMap((int)((float)this.m_imageCacheSize + 1.3333334f), 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > ImageFactory.this.m_imageCacheSize;
        }
    };
    protected Map loadMap = new HashMap(50);
    protected final Component component = new Component(){};
    protected final MediaTracker tracker = new MediaTracker(this.component);
    protected int nextTrackerID = 0;

    public ImageFactory() {
        this(-1, -1);
    }

    public ImageFactory(int maxImageWidth, int maxImageHeight) {
        this.setMaxImageDimensions(maxImageWidth, maxImageHeight);
    }

    public void setMaxImageDimensions(int width, int height) {
        this.m_maxImageWidth = width;
        this.m_maxImageHeight = height;
    }

    public void setImageCacheSize(int size) {
        this.m_imageCacheSize = size;
    }

    public boolean isInCache(String imageLocation) {
        return this.imageCache.containsKey(imageLocation);
    }

    public Image getImage(String imageLocation) {
        Image image = (Image)this.imageCache.get(imageLocation);
        if (image == null && !this.loadMap.containsKey(imageLocation)) {
            URL imageURL = IOLib.urlFromString(imageLocation);
            if (imageURL == null) {
                System.err.println("Null image: " + imageLocation);
                return null;
            }
            image = Toolkit.getDefaultToolkit().createImage(imageURL);
            if (!this.m_asynch) {
                this.waitForImage(image);
                this.addImage(imageLocation, image);
            } else {
                int id = ++this.nextTrackerID;
                this.tracker.addImage(image, id);
                this.loadMap.put(imageLocation, new LoadMapEntry(id, image));
            }
        } else if (image == null && this.loadMap.containsKey(imageLocation)) {
            LoadMapEntry entry = (LoadMapEntry)this.loadMap.get(imageLocation);
            if (this.tracker.checkID(entry.id, true)) {
                this.addImage(imageLocation, entry.image);
                this.loadMap.remove(imageLocation);
                this.tracker.removeImage(entry.image, entry.id);
            }
        } else {
            return image;
        }
        return (Image)this.imageCache.get(imageLocation);
    }

    public Image addImage(String location, Image image) {
        if (this.m_maxImageWidth > -1 || this.m_maxImageHeight > -1) {
            image = this.getScaledImage(image);
            image.getWidth(null);
        }
        this.imageCache.put(location, image);
        return image;
    }

    protected void waitForImage(Image image) {
        int id = ++this.nextTrackerID;
        this.tracker.addImage(image, id);
        try {
            this.tracker.waitForID(id, 0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tracker.removeImage(image, id);
    }

    protected Image getScaledImage(Image img) {
        int h;
        int w = img.getWidth(null) - this.m_maxImageWidth;
        if (w > (h = img.getHeight(null) - this.m_maxImageHeight) && w > 0 && this.m_maxImageWidth > -1) {
            Image scaled = img.getScaledInstance(this.m_maxImageWidth, -1, 4);
            img.flush();
            return scaled;
        }
        if (h > 0 && this.m_maxImageHeight > -1) {
            Image scaled = img.getScaledInstance(-1, this.m_maxImageHeight, 4);
            img.flush();
            return scaled;
        }
        return img;
    }

    public void preloadImages(Iterator iter, String field) {
        boolean synch = this.m_asynch;
        this.m_asynch = false;
        String loc = null;
        while (iter.hasNext() && this.imageCache.size() <= this.m_imageCacheSize) {
            Tuple t = (Tuple)iter.next();
            loc = t.getString(field);
            if (loc == null) continue;
            this.getImage(loc);
        }
        this.m_asynch = synch;
    }

    private class LoadMapEntry {
        public int id;
        public Image image;

        public LoadMapEntry(int id, Image image) {
            this.id = id;
            this.image = image;
        }
    }
}

