/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.LiteralComparator;

public class DefaultLiteralComparator
implements LiteralComparator {
    private static DefaultLiteralComparator s_instance = null;

    public static DefaultLiteralComparator getInstance() {
        if (s_instance == null) {
            s_instance = new DefaultLiteralComparator();
        }
        return s_instance;
    }

    @Override
    public int compare(byte x1, byte x2) {
        return x1 < x2 ? -1 : (x1 > x2 ? 1 : 0);
    }

    @Override
    public int compare(int x1, int x2) {
        return x1 < x2 ? -1 : (x1 > x2 ? 1 : 0);
    }

    @Override
    public int compare(long x1, long x2) {
        return x1 < x2 ? -1 : (x1 > x2 ? 1 : 0);
    }

    @Override
    public int compare(float x1, float x2) {
        return Float.compare(x1, x2);
    }

    @Override
    public int compare(double x1, double x2) {
        return Double.compare(x1, x2);
    }

    @Override
    public int compare(boolean x1, boolean x2) {
        return x1 ? (x2 ? 0 : 1) : (x2 ? -1 : 0);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o2 instanceof Comparable) {
            return -1 * ((Comparable)o2).compareTo(o1);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return this.compare((Boolean)o1, (Boolean)o2);
        }
        throw new IllegalArgumentException("Incomparable arguments.");
    }
}

