/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;
import prefuse.util.collections.LongIntSortedMap;

public class LongIntTreeMap
extends AbstractTreeMap
implements LongIntSortedMap {
    private LongEntry dummy = new LongEntry(Long.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public LongIntTreeMap() {
        this(null, false);
    }

    public LongIntTreeMap(boolean allowDuplicates) {
        this(null, allowDuplicates);
    }

    public LongIntTreeMap(LiteralComparator comparator) {
        this(comparator, false);
    }

    public LongIntTreeMap(LiteralComparator comparator, boolean allowDuplicates) {
        super(comparator, allowDuplicates);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public boolean containsKey(long key) {
        return this.find(key, 0) != NIL;
    }

    @Override
    public int get(long key) {
        AbstractTreeMap.Entry ret = this.find(key, 0);
        return ret == NIL ? Integer.MIN_VALUE : ret.val;
    }

    @Override
    public int put(long key, int value) {
        AbstractTreeMap.Entry t = this.root;
        this.lastOrder = 0;
        if (t == NIL) {
            this.incrementSize(true);
            this.root = new LongEntry(key, value, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = key;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int cmp;
            if ((cmp = this.compare(this.dummy, t)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != NIL) {
                    t = t.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                t.left = new LongEntry(key, value, t, this.lastOrder);
                this.fixUpInsert(t.left);
                return Integer.MIN_VALUE;
            }
            if (t.right == NIL) break;
            t = t.right;
        }
        this.incrementSize(this.lastOrder == 0);
        t.right = new LongEntry(key, value, t, this.lastOrder);
        this.fixUpInsert(t.right);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(long key) {
        AbstractTreeMap.Entry x = this.allowDuplicates ? this.findPredecessor(key, Integer.MAX_VALUE) : this.find(key, 0);
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        int val = x.val;
        this.remove(x);
        return val;
    }

    @Override
    public int remove(long key, int val) {
        AbstractTreeMap.Entry x = this.findCeiling(key, 0);
        if (x != NIL && x.getLongKey() != key) {
            x = this.successor(x);
        }
        if (x == NIL || x.getLongKey() != key) {
            return Integer.MIN_VALUE;
        }
        while (x.val != val && x != NIL) {
            x = this.successor(x);
        }
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(x);
        return val;
    }

    @Override
    public long firstKey() {
        return this.minimum(this.root).getLongKey();
    }

    @Override
    public long lastKey() {
        return this.maximum(this.root).getLongKey();
    }

    @Override
    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    @Override
    public LiteralIterator keyRangeIterator(long fromKey, boolean fromInc, long toKey, boolean toInc) {
        AbstractTreeMap.Entry end;
        AbstractTreeMap.Entry start;
        if (this.cmp.compare(fromKey, toKey) <= 0) {
            start = this.findCeiling(fromKey, fromInc ? 0 : Integer.MAX_VALUE);
            end = this.findCeiling(toKey, toInc ? Integer.MAX_VALUE : 0);
        } else {
            start = this.findCeiling(fromKey, fromInc ? Integer.MAX_VALUE : 0);
            start = this.predecessor(start);
            end = this.findCeiling(toKey, toInc ? 0 : Integer.MAX_VALUE);
            end = this.predecessor(end);
        }
        return new KeyIterator(start, end);
    }

    @Override
    public IntIterator valueRangeIterator(long fromKey, boolean fromInc, long toKey, boolean toInc) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(fromKey, fromInc, toKey, toInc));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry e1, AbstractTreeMap.Entry e2) {
        int c = this.cmp.compare(e1.getLongKey(), e2.getLongKey());
        if (this.allowDuplicates && c == 0) {
            c = e1.order < e2.order ? -1 : (e1.order > e2.order ? 1 : 0);
            this.lastOrder = 1 + (c < 0 ? e1.order : e2.order);
        }
        return c;
    }

    private AbstractTreeMap.Entry find(long key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.find(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findPredecessor(long key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findPredecessor(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findCeiling(long key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findCeiling(this.dummy);
        return e;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry start, AbstractTreeMap.Entry end) {
            super(start, end);
        }

        @Override
        public boolean isLongSupported() {
            return true;
        }

        @Override
        public long nextLong() {
            return this.nextEntry().getLongKey();
        }
    }

    static class LongEntry
    extends AbstractTreeMap.Entry {
        long key;

        public LongEntry(long key, int val) {
            super(val);
            this.key = key;
        }

        public LongEntry(long key, int val, AbstractTreeMap.Entry parent, int order) {
            super(val, parent, order);
            this.key = key;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public Object getKey() {
            return new Long(this.key);
        }

        @Override
        public boolean keyEquals(AbstractTreeMap.Entry e) {
            return e instanceof LongEntry && this.key == ((LongEntry)e).key;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LongEntry)) {
                return false;
            }
            LongEntry e = (LongEntry)o;
            return this.key == e.key && this.val == e.val;
        }

        @Override
        public int hashCode() {
            int khash = (int)(this.key ^ this.key >>> 32);
            int vhash = this.val;
            return khash ^ vhash ^ this.order;
        }

        @Override
        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry x) {
            super.copyFields(x);
            this.key = x.getLongKey();
        }
    }
}

