/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.io.CSVTableReader;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.io.GraphMLReader;
import prefuse.data.io.GraphReader;
import prefuse.data.io.TableReader;
import prefuse.data.io.TreeMLReader;
import prefuse.util.StringLib;
import prefuse.util.collections.ByteArrayList;
import prefuse.util.io.SimpleFileFilter;

public class IOLib {
    private IOLib() {
    }

    public static boolean isUrlString(String s) {
        return s.startsWith("http:/") || s.startsWith("ftp:/") || s.startsWith("file:/");
    }

    public static URL urlFromString(String location) {
        return IOLib.urlFromString(location, null, true);
    }

    public static URL urlFromString(String location, Class referrer, boolean includeFileSystem) {
        URL url = null;
        if (IOLib.isUrlString(location)) {
            try {
                url = new URL(location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            url = referrer != null ? referrer.getResource(location) : IOLib.class.getResource(location);
            if (url == null && !location.startsWith("/")) {
                url = IOLib.class.getResource("/" + location);
            }
            if (includeFileSystem && url == null && new File(location).exists()) {
                try {
                    url = new URL("file:///" + location);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static InputStream streamFromString(String location) throws IOException {
        InputStream is = null;
        URL url = IOLib.urlFromString(location, null, false);
        if (url != null) {
            is = url.openStream();
        } else {
            File f = new File(location);
            if (f.exists()) {
                is = new FileInputStream(f);
            }
        }
        if (is == null) {
            return null;
        }
        if (IOLib.isGZipFile(location)) {
            return new GZIPInputStream(is);
        }
        return is;
    }

    public static String getExtension(File f) {
        return f != null ? IOLib.getExtension(f.getName()) : null;
    }

    public static boolean isGZipFile(String file) {
        String ext = IOLib.getExtension(file);
        return "gz".equals(ext) || "z".equals(ext);
    }

    public static boolean isZipFile(String file) {
        return "zip".equals(IOLib.getExtension(file));
    }

    public static String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static ByteArrayList readAsBytes(InputStream is) throws IOException {
        ByteArrayList buf = new ByteArrayList();
        byte[] b = new byte[8192];
        int nread = -1;
        while ((nread = is.read(b)) >= 0) {
            buf.add(b, 0, nread);
        }
        return buf;
    }

    public static String readAsString(InputStream is) throws IOException {
        StringBuffer buf = new StringBuffer();
        byte[] b = new byte[8192];
        int nread = -1;
        while ((nread = is.read(b)) >= 0) {
            String s = new String(b, 0, nread);
            buf.append(s);
        }
        return buf.toString();
    }

    public static String readAsString(String location) throws IOException {
        return IOLib.readAsString(IOLib.streamFromString(location));
    }

    public static Table getTableFile(Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogType(0);
        jfc.setDialogTitle("Open Table File");
        jfc.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter ff = new SimpleFileFilter("csv", "Comma Separated Values (CSV) File (*.csv)", new CSVTableReader());
        ff.addExtension("gz");
        jfc.setFileFilter(ff);
        ff = new SimpleFileFilter("txt", "Pipe-Delimited Text File (*.txt)", new DelimitedTextTableReader("|"));
        ff.addExtension("gz");
        jfc.setFileFilter(ff);
        ff = new SimpleFileFilter("txt", "Tab-Delimited Text File (*.txt)", new DelimitedTextTableReader());
        ff.addExtension("gz");
        jfc.setFileFilter(ff);
        int retval = jfc.showOpenDialog(c);
        if (retval != 0) {
            return null;
        }
        File f = jfc.getSelectedFile();
        ff = (SimpleFileFilter)jfc.getFileFilter();
        TableReader tr = (TableReader)ff.getUserData();
        try {
            return tr.readTable(IOLib.streamFromString(f.getAbsolutePath()));
        }
        catch (Exception e) {
            Logger.getLogger(IOLib.class.getName()).warning(e.getMessage() + "\n" + StringLib.getStackTrace(e));
            return null;
        }
    }

    public static Graph getGraphFile(Component c) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogType(0);
        jfc.setDialogTitle("Open Graph or Tree File");
        jfc.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter ff = new SimpleFileFilter("xml", "TreeML File (*.xml, *.treeml)", new TreeMLReader());
        ff.addExtension("treeml");
        ff.addExtension("gz");
        jfc.setFileFilter(ff);
        ff = new SimpleFileFilter("xml", "GraphML File (*.xml, *.graphml)", new GraphMLReader());
        ff.addExtension("graphml");
        ff.addExtension("gz");
        jfc.setFileFilter(ff);
        int retval = jfc.showOpenDialog(c);
        if (retval != 0) {
            return null;
        }
        File f = jfc.getSelectedFile();
        ff = (SimpleFileFilter)jfc.getFileFilter();
        GraphReader gr = (GraphReader)ff.getUserData();
        try {
            return gr.readGraph(IOLib.streamFromString(f.getAbsolutePath()));
        }
        catch (Exception e) {
            Logger.getLogger(IOLib.class.getName()).warning(e.getMessage() + "\n" + StringLib.getStackTrace(e));
            return null;
        }
    }
}

