/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import prefuse.util.io.IOLib;

public class SimpleFileFilter
extends FileFilter {
    private ArrayList exts = new ArrayList();
    private String desc;
    private Object data;

    public SimpleFileFilter(String ext, String desc) {
        this.addExtension(ext);
        this.desc = desc;
    }

    public SimpleFileFilter(String ext, String desc, Object data) {
        this.addExtension(ext);
        this.desc = desc;
        this.data = data;
    }

    public void addExtension(String ext) {
        this.exts.add(ext.toLowerCase());
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String extension = IOLib.getExtension(f);
        if (extension == null) {
            return false;
        }
        for (String ext : this.exts) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public Object getUserData() {
        return this.data;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String getExtension() {
        return (String)this.exts.get(0);
    }
}

