/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class JCustomTooltip
extends JToolTip {
    private boolean m_persist = false;
    private Listener m_lstnr = null;

    public JCustomTooltip(JComponent src, JComponent content) {
        this(src, content, false);
    }

    public JCustomTooltip(JComponent src, JComponent content, boolean inter) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setComponent(src);
        this.add(content);
        this.setPersistent(inter);
    }

    public boolean isPersistent() {
        return this.m_persist;
    }

    public void setPersistent(boolean inter) {
        if (inter == this.m_persist) {
            return;
        }
        if (inter) {
            this.m_lstnr = new Listener();
            this.addAncestorListener(this.m_lstnr);
        } else {
            this.removeAncestorListener(this.m_lstnr);
            this.m_lstnr = null;
        }
        this.m_persist = inter;
    }

    public void setContent(JComponent content) {
        this.removeAll();
        this.add(content);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() > 0) {
            Dimension d = this.getComponent(0).getPreferredSize();
            Insets ins = this.getInsets();
            return new Dimension(d.width + ins.left + ins.right, d.height + ins.top + ins.bottom);
        }
        return super.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getComponentCount() > 0) {
            g.setColor(this.getBackground());
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(this.getComponent(0).getBackground());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    private class Listener
    extends MouseAdapter
    implements AncestorListener {
        private Point point = new Point();
        private boolean showing = false;
        private Popup popup;

        private Listener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (this.showing) {
                return;
            }
            Window ttip = SwingUtilities.getWindowAncestor(JCustomTooltip.this.getParent());
            if (ttip == null || !ttip.isVisible()) {
                return;
            }
            ttip.getLocation(this.point);
            ttip.setVisible(false);
            JCustomTooltip.this.getParent().remove(JCustomTooltip.this);
            JComponent c = JCustomTooltip.this.getComponent();
            c.setToolTipText(null);
            c.removeMouseMotionListener(ToolTipManager.sharedInstance());
            this.popup = PopupFactory.getSharedInstance().getPopup(c, JCustomTooltip.this, this.point.x, this.point.y);
            Window w = SwingUtilities.getWindowAncestor(JCustomTooltip.this);
            w.addMouseListener(this);
            w.setFocusableWindowState(true);
            this.popup.show();
            this.showing = true;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.showing) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            Component c = (Component)e.getSource();
            if (x < 0 || y < 0 || x > c.getWidth() || y > c.getHeight()) {
                Window w = SwingUtilities.getWindowAncestor(JCustomTooltip.this);
                w.removeMouseListener(this);
                w.setFocusableWindowState(false);
                this.popup.hide();
                this.popup = null;
                JCustomTooltip.this.getComponent().setToolTipText("?");
                this.showing = false;
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

