/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyDraw
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private Point[] points;
    private byte[] types;

    public PolyDraw() {
        super(56, 1);
    }

    public PolyDraw(Rectangle bounds, Point[] points, byte[] types) {
        this();
        this.bounds = bounds;
        this.points = points;
        this.types = types;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int n = emf.readDWORD();
        return new PolyDraw(emf.readRECTL(), emf.readPOINTL(n), emf.readBYTE(n));
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.points.length);
        emf.writePOINTL(this.points);
        emf.writeBYTE(this.types);
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  #points: " + this.points.length;
    }
}

