/*
 * VMS patch 5 for John the Ripper version 1.6.32
 * (C) 2002 Jean-loup Gailly  http://gailly.net
 * license: GPL <http://www.gnu.org/>
 *
 * This file is based on code from John the Ripper,
 *   Copyright (c) 1996-2002 by Solar Designer.
 * Original hash algorithm by Shawn Clifford in February 1993.
 * Code from VMSCRACK  by Davide Casale.
 * Code optimizations by Mario Ambrogetti in June 1994.
 * Code fixes with the help of Terence Lee.
 */

#include <string.h>

#include "misc.h"
#include "common.h"

typedef unsigned char byte;
typedef unsigned short word; /* note:  word in this code is 16 bits */
typedef ARCH_WORD_32 dword;  /* note: dword in this code is 32 bits */

typedef struct {
#if ARCH_LITTLE_ENDIAN
          dword d_low;
          dword d_high;
#else
          dword d_high;
          dword d_low;
#endif
        } qword;

#define UAIC_AD_II   0  /* AUTODIN-II 32 bit crc code, not supported   */
#define UAIC_PURDY   1  /* Purdy polynomial over salted input          */
#define UAIC_PURDY_V 2  /* Purdy polynomial + variable length username */
#define UAIC_PURDY_S 3  /* PURDY_V + additional bit rotation           */

/* Portable C version of the last 3 encryption methods for DEC's
   password hashing algorithms.
           output = 8 byte output buffer in cracking host format
	 password = up to 32 characters, upper case, without spaces
	  encrypt = determines algorithm to use
		    1 -> Purdy algorithm
		    2 -> Purdy_V
		    3 -> Purdy_S (Hickory algorithm)
	     salt = 2 byte random number
	 username = up to 31 characters username, upper case.
*/
extern void VMS_lgihpwd(qword *output,
			char *password,
			int encrypt,
			word salt,
			char *username);
