/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractBidiMapTest;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractOrderedBidiMapTest<K, V>
extends AbstractBidiMapTest<K, V> {
    public BulkTest bulkTestOrderedMapIterator() {
        return new TestBidiOrderedMapIterator();
    }

    @Override
    public OrderedBidiMap<K, V> getMap() {
        return (OrderedBidiMap)super.getMap();
    }

    @Test
    public void testFirstKey() {
        OrderedBidiMap bidi;
        this.resetEmpty();
        OrderedBidiMap finalBidi = bidi = this.getMap();
        Assertions.assertThrows(NoSuchElementException.class, () -> finalBidi.firstKey());
        this.resetFull();
        bidi = this.getMap();
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        Assertions.assertEquals(confirmedFirst, (Object)bidi.firstKey());
    }

    @Test
    public void testLastKey() {
        OrderedBidiMap bidi;
        this.resetEmpty();
        OrderedBidiMap finalBidi = bidi = this.getMap();
        Assertions.assertThrows(NoSuchElementException.class, () -> finalBidi.lastKey());
        this.resetFull();
        bidi = this.getMap();
        Object confirmedLast2 = null;
        for (Object confirmedLast2 : this.confirmed.keySet()) {
        }
        Assertions.assertEquals(confirmedLast2, (Object)bidi.lastKey());
    }

    @Test
    public void testNextKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = (OrderedBidiMap)this.map;
        Assertions.assertNull((Object)bidi.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assertions.assertNull((Object)bidi.nextKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Assertions.assertNull((Object)bidi.nextKey(null));
        }
        this.resetFull();
        bidi = (OrderedBidiMap)this.map;
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assertions.assertEquals(confirmedObject, (Object)bidi.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assertions.assertNull((Object)bidi.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            OrderedBidiMap finalBidi = bidi;
            Assertions.assertThrows(NullPointerException.class, () -> finalBidi.nextKey(null));
        } else {
            Assertions.assertNull((Object)bidi.nextKey(null));
        }
    }

    @Test
    public void testPreviousKey() {
        this.resetEmpty();
        OrderedBidiMap bidi = this.getMap();
        Assertions.assertNull((Object)bidi.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assertions.assertNull((Object)bidi.previousKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Assertions.assertNull((Object)bidi.previousKey(null));
        }
        this.resetFull();
        bidi = this.getMap();
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assertions.assertEquals(confirmedObject, (Object)bidi.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assertions.assertNull((Object)bidi.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            OrderedBidiMap finalBidi = bidi;
            Assertions.assertThrows(NullPointerException.class, () -> finalBidi.previousKey(null));
        } else {
            Assertions.assertNull((Object)bidi.previousKey(null));
        }
    }

    public class TestBidiOrderedMapIterator
    extends AbstractMapIteratorTest<K, V> {
        @Override
        public V[] addSetValues() {
            return AbstractOrderedBidiMapTest.this.getNewSampleValues();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractOrderedBidiMapTest.this.confirmed;
        }

        @Override
        public Map<K, V> getMap() {
            return AbstractOrderedBidiMapTest.this.map;
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractOrderedBidiMapTest.this.resetEmpty();
            return AbstractOrderedBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractOrderedBidiMapTest.this.resetFull();
            return AbstractOrderedBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractOrderedBidiMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractOrderedBidiMapTest.this.isSetValueSupported();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractOrderedBidiMapTest.this.verify();
        }
    }
}

