**Docs**

This documentation section of the repository contains links to all the optional online-only sections for the book as well as other content that readers will find useful.

- [Online-only sections](#online-only-sections)
  - [Chapter 1 Hello C#, Welcome .NET!](#chapter-1-hello-c-welcome-net)
  - [Chapter 2 Speaking C#](#chapter-2-speaking-c)
  - [Chapter 4 - Writing, Debugging, and Testing Functions](#chapter-4---writing-debugging-and-testing-functions)
  - [Chapter 6 Implementing Interfaces and Inheriting Classes](#chapter-6-implementing-interfaces-and-inheriting-classes)
  - [Chapter 7 Packaging and Distributing .NET Types](#chapter-7-packaging-and-distributing-net-types)
  - [Chapter 8 Working with Common .NET Types](#chapter-8-working-with-common-net-types)
  - [Chapter 9 Working with Files, Streams, and Serialization](#chapter-9-working-with-files-streams-and-serialization)
  - [Chapter 10 Working with Data Using Entity Framework Core](#chapter-10-working-with-data-using-entity-framework-core)
  - [Chapter 11 Querying and Manipulating Data Using LINQ](#chapter-11-querying-and-manipulating-data-using-linq)
  - [Chapter 12 Modern Web Development with .NET](#chapter-12-modern-web-development-with-net)
  - [Chapter 13 Building Websites Using ASP.NET Core](#chapter-13-building-websites-using-aspnet-core)
  - [Chapter 14 Building Interactive Web Components Using Blazor](#chapter-14-building-interactive-web-components-using-blazor)
  - [Chapter 15 Building and Consuming Web Services](#chapter-15-building-and-consuming-web-services)
  - [Bonus content](#bonus-content)
- [Errata, Improvements, and Common Mistakes](#errata-improvements-and-common-mistakes)
- [Miscellaneous](#miscellaneous)

# Online-only sections

## Chapter 1 Hello C#, Welcome .NET!

- [.NET History](ch01-dotnet-history.md)
- [Polyglot Notebooks](ch01-polyglot-notebooks.md)
- [Project Options](ch01-project-options.md)
- [Solution Folders](ch01-solution-folders.md)

## Chapter 2 Speaking C#

- [C# language versions and features](ch02-features.md)
- [Dynamic Type](ch02-dynamic.md)
- [Understanding async and await](ch02-async-await.md)

## Chapter 4 - Writing, Debugging, and Testing Functions

- [Logging during development and runtime](ch04-logging.md)

## Chapter 6 Implementing Interfaces and Inheriting Classes

- [Managing memory with reference and value types](ch06-memory.md)
- [Writing Better Code](ch06-writing-better-code.md)

## Chapter 7 Packaging and Distributing .NET Types

- [New features in modern .NET](ch07-features.md)
- [Decompiling .NET assemblies](ch07-decompiling.md)
- [Porting from .NET Framework to modern .NET](ch07-porting.md)
- [Introducing source generators](ch07-source-generators.md)

## Chapter 8 Working with Common .NET Types

- [Working with Network Resources](ch08-network-resources.md)

## Chapter 9 Working with Files, Streams, and Serialization

- [Working with environment variables](ch09-environment-variables.md)
- [Working with Tar archives](ch09-tar-archives.md)

## Chapter 10 Working with Data Using Entity Framework Core

- [Database Primer](ch10-database-primer.md)
- [Entity-Relationship Diagram for Northwind](ch10-er-diagram.md)
- [Loading and tracking patterns with EF Core](ch10-loading-tracking.md)
- [Modifying data with EF Core](ch10-modifying.md)
- [Working with transactions](ch10-transactions.md)
- [Code First EF Core models](ch10-code-first.md)
- [App Secrets](ch10-app-secrets.md)

## Chapter 11 Querying and Manipulating Data Using LINQ

- [LINQ extension methods](ch11-linq-methods.md)
- [Aggregating and paging sequences](ch11-aggregating.md)
- [Using multiple threads with parallel LINQ](ch11-plinq.md)
- [Working with LINQ to XML](ch11-linq-to-xml.md)
- [Creating your own LINQ extension methods](ch11-custom-linq-methods.md)

## Chapter 12 Modern Web Development with .NET

- [New features in ASP.NET Core](ch12-features.md)

## Chapter 13 Building Websites Using ASP.NET Core

- [Prototyping with Bootstrap](ch13-bootstrap.md)
- [ASP.NET Core common classes and methods](ch13-common-classes.md)
- [Configuring services and the HTTP request pipeline](ch13-http-pipeline.md)
- [Enabling HTTP/3 and request decompression support](ch13-enabling-http3.md)

## Chapter 14 Building Interactive Web Components Using Blazor

- [Enabling client-side execution using WebAssembly](ch14-blazor-wasm.md)
- [Enhancing Blazor apps](ch14-enhanced-blazor.md)

## Chapter 15 Building and Consuming Web Services

- [Testing requests with the Swagger UI](ch15-swagger-ui.md)
- [Implementing advanced features for web services](ch15-advanced.md)
- [Exercise 15.2 – Practice creating and deleting customers with HttpClient](ch15-exercise-2.md)

## Bonus content

The appendix and color figures are available to download as PDFs:

- [Appendix, Answers to the Test Your Knowledge Questions](B22322_Appendix.pdf).
- [Color images of the screenshots/diagrams used in this book](9781835881224_ColorImages.pdf).

# [Errata, Improvements, and Common Mistakes](errata/README.md)

If you find any mistakes in the ninth edition, *C# 13 and .NET 9 - Modern Cross-Platform Development Fundamentals*, or if you have suggestions for improvements, then please [raise an issue in this repository](https://github.com/markjprice/cs13net9/issues) or email me at markjprice (at) gmail.com.

# Miscellaneous

[**Book Links**](book-links.md): All links in the published book.

[**Ninth Edition's support for .NET 10**](dotnet10.md): How to use the 9th edition of this book with .NET 10 previews starting in February 2025.

[**What's New in the 9th Edition**](whats-new-in-book.md): There are hundreds of minor fixes and improvements throughout the 9th edition.
