**Book Links**

- [Chapter 1 - Hello, C#! Welcome, .NET!](#chapter-1---hello-c-welcome-net)
  - [Visual Studio](#visual-studio)
  - [VS Code](#vs-code)
  - [Other C# code editors and platforms](#other-c-code-editors-and-platforms)
  - [.NET Interactive and Polyglot Notebooks](#net-interactive-and-polyglot-notebooks)
  - [Command Line Interfaces](#command-line-interfaces)
  - [.NET](#net)
  - [.NET performance improvements](#net-performance-improvements)
  - [Open source and other projects related to .NET](#open-source-and-other-projects-related-to-net)
  - [Git](#git)
  - [Help and learning](#help-and-learning)
- [Chapter 2 - Speaking C#](#chapter-2---speaking-c)
  - [What's New in C#?](#whats-new-in-c)
  - [The journey to modern C#](#the-journey-to-modern-c)
  - [C# language](#c-language)
  - [C# implemented proposals](#c-implemented-proposals)
  - [C# proposals being worked on](#c-proposals-being-worked-on)
  - [Text and number types](#text-and-number-types)
  - [Console apps and formatting](#console-apps-and-formatting)
  - [Miscellaneous](#miscellaneous)
- [Chapter 3 - Controlling Flow, Converting Types, and Handling Exceptions](#chapter-3---controlling-flow-converting-types-and-handling-exceptions)
  - [Operators](#operators)
  - [Branching statements and pattern matching](#branching-statements-and-pattern-matching)
  - [Casting, converting, rounding, and formatting data](#casting-converting-rounding-and-formatting-data)
  - [Handling exceptions](#handling-exceptions)
  - [Coding problems in interviews](#coding-problems-in-interviews)
- [Chapter 4 - Writing, Debugging, and Testing Functions](#chapter-4---writing-debugging-and-testing-functions)
  - [Debugging](#debugging)
  - [Instrumenting](#instrumenting)
  - [Testing](#testing)
- [Chapter 5 - Building Your Own Types with Object-Oriented Programming](#chapter-5---building-your-own-types-with-object-oriented-programming)
  - [Fields](#fields)
  - [Methods](#methods)
  - [Properties](#properties)
  - [Pattern matching, Records, and Miscellaneous](#pattern-matching-records-and-miscellaneous)
- [Chapter 6 - Implementing Interfaces and Inheriting Classes](#chapter-6---implementing-interfaces-and-inheriting-classes)
  - [Operator overloading, delegates and events](#operator-overloading-delegates-and-events)
  - [Interfaces and generics](#interfaces-and-generics)
  - [Memory, reference and value types](#memory-reference-and-value-types)
  - [Null and nullability](#null-and-nullability)
  - [Inheritance](#inheritance)
  - [Language design](#language-design)
- [Chapter 7 - Packaging and Distributing .NET Types](#chapter-7---packaging-and-distributing-net-types)
  - [.NET versions](#net-versions)
  - [.NET Standard](#net-standard)
  - [.NET API, packages and frameworks](#net-api-packages-and-frameworks)
  - [Roslyn, SDKs, and project templates](#roslyn-sdks-and-project-templates)
  - [Packaging and publishing](#packaging-and-publishing)
  - [Decompiling .NET](#decompiling-net)
  - [Ahead-of-time (AOT) compilation](#ahead-of-time-aot-compilation)
  - [Porting from .NET Framework to modern .NET](#porting-from-net-framework-to-modern-net)
  - [Preview features](#preview-features)
- [Chapter 8 - Working with Common .NET Types](#chapter-8---working-with-common-net-types)
  - [Working with numbers](#working-with-numbers)
  - [Working with text and regular expressions](#working-with-text-and-regular-expressions)
  - [Collections](#collections)
  - [Spans](#spans)
  - [Networking](#networking)
- [Chapter 9 - Working with Files, Streams, and Serialization](#chapter-9---working-with-files-streams-and-serialization)
  - [File system, encoding, streams, and serialization](#file-system-encoding-streams-and-serialization)
  - [JSON](#json)
- [Chapter 10 - Working with Data Using Entity Framework Core](#chapter-10---working-with-data-using-entity-framework-core)
  - [Legacy EF 6](#legacy-ef-6)
  - [EF Core](#ef-core)
  - [EF Core database providers](#ef-core-database-providers)
  - [SQLite](#sqlite)
  - [Microsoft SQL Server](#microsoft-sql-server)
  - [EF Core models](#ef-core-models)
  - [EF Core querying and manipulating](#ef-core-querying-and-manipulating)
- [Chapter 11 - Querying and Manipulating Data Using LINQ](#chapter-11---querying-and-manipulating-data-using-linq)
  - [LINQ concepts](#linq-concepts)
  - [LINQ providers](#linq-providers)
  - [LINQ samples and tools](#linq-samples-and-tools)
- [Chapter 12 - Introducing Modern Web Development Using .NET](#chapter-12---introducing-modern-web-development-using-net)
  - [.NET apps](#net-apps)
  - [.NET Content Management Systems](#net-content-management-systems)
  - [General web development](#general-web-development)
  - [ASP.NET versions and features](#aspnet-versions-and-features)
- [Chapter 13 - Building Websites Using ASP.NET Core](#chapter-13---building-websites-using-aspnet-core)
  - [ASP.NET Core](#aspnet-core)
  - [Razor syntax](#razor-syntax)
  - [Endpoint routing](#endpoint-routing)
  - [Security and privacy](#security-and-privacy)
  - [Miscellaneous](#miscellaneous-1)
- [Chapter 14 - Building Interactive Web Components Using Blazor](#chapter-14---building-interactive-web-components-using-blazor)
  - [Blazor hosting models](#blazor-hosting-models)
  - [Blazor components](#blazor-components)
  - [Advanced techniques](#advanced-techniques)
  - [Other resources](#other-resources)
- [Chapter 15 - Building and Consuming Web Services](#chapter-15---building-and-consuming-web-services)
  - [Web service technologies](#web-service-technologies)
  - [Web service routing](#web-service-routing)
  - [Web service clients](#web-service-clients)
  - [Documenting web services](#documenting-web-services)
  - [Securing web services](#securing-web-services)
  - [Health checks and reliable web services](#health-checks-and-reliable-web-services)
- [Epilogue](#epilogue)
  - [Next steps on your C# and .NET learning journey](#next-steps-on-your-c-and-net-learning-journey)
  - [Learn from other Packt books](#learn-from-other-packt-books)

# Chapter 1 - Hello, C#! Welcome, .NET!

## Visual Studio
- [Download Visual Studio](https://visualstudio.microsoft.com/downloads/)
- [Sign up for a Microsoft account](https://signup.live.com/)
- [Visual Studio for Windows documentation](https://learn.microsoft.com/en-us/visualstudio/windows/)
- [20 Must-Know Visual Studio Shortcuts for Developers - YouTube](https://www.youtube.com/watch?v=nhEHXQGVmaQ)
- [Microsoft Visual Studio on YouTube](https://www.youtube.com/visualstudio)
- [Building Apps with Visual Studio in the Cloud with Dev Box](https://www.youtube.com/watch?v=9imDpJwrFJE)
- [Cool features in Visual Studio 2022](https://www.youtube.com/watch?v=NBfNnyPQTKs)
- [MSBuild and 64-bit Visual Studio 2022](https://devblogs.microsoft.com/dotnet/msbuild-and-64-bit-visual-studio-2022/)
- [Create C# apps with Visual Studio](https://learn.microsoft.com/en-us/visualstudio/get-started/csharp/)
- [Comparison of Visual Studio Code and Visual Studio](https://www.itworld.com/article/3403683/visual-studio-code-stepping-on-visual-studios-toes.html)

## VS Code
- [C# Dev Kit – Now Generally Available](https://devblogs.microsoft.com/dotnet/csharp-dev-kit-now-generally-available/)
- [Download VS Code](https://code.visualstudio.com/)
- [VS Code documentation](https://code.visualstudio.com/docs)
- [Set up VS Code](https://code.visualstudio.com/docs/setup/setup-overview)
- [VS Code key bindings and shortcuts](https://code.visualstudio.com/docs/getstarted/keybindings)
  - [Windows shortcuts PDF](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-windows.pdf)
  - [macOS shortcuts PDF](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-macos.pdf)
  - [Linux shortcuts PDF](https://code.visualstudio.com/shortcuts/keyboard-shortcuts-linux.pdf)
- [How can I do a 'clean' uninstall of VS Code?](https://code.visualstudio.com/docs/setup/setup-overview#_how-can-i-do-a-clean-uninstall-of-vs-code)
- [Microsoft's roadmap for VS Code](https://github.com/Microsoft/vscode/wiki/Roadmap)
- [VS Code for C# Developers | .NET Conf 2022](https://www.youtube.com/watch?v=fuBi4d7k1-M)
- [Learning with VS Code on Chromebooks](https://code.visualstudio.com/blogs/2020/12/03/chromebook-get-started)
- [The History of VS Code | BDL134](https://www.youtube.com/watch?v=Tw8l0WzQxmY)

## Other C# code editors and platforms
- [Stack Overflow survey 2021 - Integrated development environment](https://insights.stackoverflow.com/survey/2021#section-most-popular-technologies-integrated-development-environment)
- [Stack Overflow survey 2019 - Most Popular Development Environments](https://insights.stackoverflow.com/survey/2019#development-environments-and-tools)
- [GitHub Codespaces](https://docs.github.com/en/codespaces/overview)
- [WebStorm and Rider Are Now Free for Non-Commercial Use](https://blog.jetbrains.com/blog/2024/10/24/webstorm-and-rider-are-now-free-for-non-commercial-use/)
- [JetBrains Rider](https://www.jetbrains.com/rider/)
- [Rider documentation](https://www.jetbrains.com/help/rider/Introduction.html)

## .NET Interactive and Polyglot Notebooks
- [The Power of Polyglot Notebooks | .NET Conf 2022](https://www.youtube.com/watch?v=IXRGa5m-Lbo)
- [.NET Interactive documentation](https://github.com/dotnet/interactive/blob/main/docs/README.md)
- [VS Code Notebooks: A Deep Dive video](https://www.youtube.com/watch?v=D-AXZZDTQhM)
- [Discuss: File format in the .NET Interactive VS Code extension](https://github.com/dotnet/interactive/issues/467)
- [Polyglot Notebooks: Variable Sharing](https://devblogs.microsoft.com/dotnet/net-interactive-preview-3-vs-code-insiders-and-polyglot-notebooks/)
- [Using HTML and JavaScript in .NET Interactive](https://github.com/dotnet/interactive/blob/main/docs/javascript-overview.md)
- [.NET Interactive Samples](https://github.com/dotnet/interactive/blob/main/samples/readme.md)
- [Markdown syntax](https://daringfireball.net/projects/markdown/syntax)

## Command Line Interfaces
- [Windows Terminal as your Default Command Line Experience](https://devblogs.microsoft.com/commandline/windows-terminal-as-your-default-command-line-experience/)
- [.NET Core Command-Line Interface (CLI) tool overview](https://aka.ms/dotnet-cli-docs)

## .NET
- [Download .NET SDK](https://dotnet.microsoft.com/en-us/download)
- [Official list of .NET 9 supported operating systems](https://github.com/dotnet/core/blob/main/release-notes/9.0/supported-os.md)
- [The convenience of .NET](https://devblogs.microsoft.com/dotnet/the-convenience-of-dotnet/)
- [What's new in .NET 9](https://learn.microsoft.com/en-us/dotnet/core/whats-new/dotnet-9)
- [.NET Conf 2022 Keynote: Welcome to .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=8V_BUGFKdaI)
- [Stack Overflow survey 2021 - Most loved frameworks and libraries](https://insights.stackoverflow.com/survey/2021#section-most-loved-dreaded-and-wanted-other-frameworks-and-libraries)
- [Themes of .NET](https://themesof.net/)
- [Microsoft's positioning of .NET Core and .NET Framework](https://devblogs.microsoft.com/dotnet/update-on-net-core-3-0-and-net-framework-4-8/)
- [Microsoft's plans for the journey to one .NET](https://devblogs.microsoft.com/dotnet/announcing-net-5-preview-4-and-our-journey-to-one-net/)
- [.NET Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core)
- [.NET versions](https://learn.microsoft.com/en-us/dotnet/core/versions/)
- [.NET Uninstall Tool](https://learn.microsoft.com/en-us/dotnet/core/additional-tools/uninstall-tool)
- [How to remove .NET SDKs and runtimes](https://learn.microsoft.com/en-us/dotnet/core/install/remove-runtime-sdk-versions)
- [ASP.NET Core and EF Core branding for .NET 5](https://learn.microsoft.com/en-us/dotnet/core/whats-new/dotnet-5)
- [.NET Optional SDK Workloads](https://github.com/dotnet/designs/blob/main/accepted/2020/workloads/workloads.md)
- [.NET Runtime](https://github.com/dotnet/runtime/blob/main/README.md)
- [.NET Release Schedule](https://github.com/dotnet/core/blob/main/roadmap.md)
- [.NET Team Members on Twitter](https://twitter.com/i/lists/120961876//members)
- [dotnet new templates](https://github.com/dotnet/templating/wiki/Available-templates-for-dotnet-new)
- [.NET 6 is now in Ubuntu 22.04](https://devblogs.microsoft.com/dotnet/dotnet-6-is-now-in-ubuntu-2204/)

## .NET performance improvements
- [Performance Improvements in .NET 10](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-10/)
- [Performance Improvements in .NET 9](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-9/)
- [Performance Improvements in .NET 8](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-8/)
- [Arm64 Performance Improvements in .NET 7](https://devblogs.microsoft.com/dotnet/arm64-performance-improvements-in-dotnet-7/)
- [Performance Improvements in .NET 7](https://devblogs.microsoft.com/dotnet/performance_improvements_in_net_7/)
- [Performance Improvements in .NET 6](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-6/)
- [Performance Improvements in .NET 5](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-5/)
- [Performance Improvements in .NET Core 3.0](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core-3-0/)
- [Performance Improvements in .NET Core 2.1](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core-2-1/)
- [Performance Improvements in .NET Core](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core/)

## Open source and other projects related to .NET
- [Mono project](http://www.mono-project.com/)
- [Unity project](https://docs.unity3d.com/)
- [Open source projects to enable WCF and WF to migrate to .NET 5](https://devblogs.microsoft.com/dotnet/supporting-the-community-with-wf-and-wcf-oss-projects/)
- [CoreWCF 1.1.0 and project templates](https://devblogs.microsoft.com/dotnet/corewcf-1-1-0-and-project-templates/)
- [Upgrading a WCF service to .NET 6 with CoreWCF](https://devblogs.microsoft.com/dotnet/upgrading-a-wcf-service-to-dotnet-6/)
- [CoreWCF 1.0 has been Released, WCF for .NET Core and .NET 5+](https://devblogs.microsoft.com/dotnet/corewcf-v1-released/)
- [Open source project for Blazor Web Forms components](https://github.com/FritzAndFriends/BlazorWebFormsComponents/blob/dev/README.md)
- [OSS Spotlight - Build amazing cross-platform UI for .NET with Avalonia UI!](https://www.youtube.com/watch?v=qcZSr2ejH5I)

## Git
- [Download Git](https://git-scm.com/download)
- [Download GitHub Desktop](https://desktop.github.com)
- [Become a master at Git and Open Source](https://devblogs.microsoft.com/visualstudio/become-a-master-at-git-and-open-source/)

## Help and learning
- [Raise an issue with the book](https://github.com/markjprice/cs11dotnet7/issues): Please tell me as much as possible about the scenario e.g. the book section title and page number, your operating system and code editor including version, project file (.csproj), code files, what you expected and what actually happened, and so on.
- [Top .NET Videos & Live Streams of 2024](https://devblogs.microsoft.com/dotnet/top-dotnet-videos-live-streams-of-2024/)
- [Top .NET Blogs Posts of 2024](https://devblogs.microsoft.com/dotnet/top-dotnet-blogs-posts-of-2024/)
- [.NET Conf 2021 Recap – Videos, Slides, Demos, and More](https://devblogs.microsoft.com/dotnet/net-conf-2021-recap-videos-slides-demos-and-more/)
- [Microsoft Learn - Technical Documentation](https://learn.microsoft.com/en-us/docs/)
- [Official .NET Blog written by the .NET engineering teams](https://devblogs.microsoft.com/dotnet/)
- [Scott Hanselman's Computer Stuff They Didn't Teach You video series on YouTube](http://computerstufftheydidntteachyou.com/)
- [Get better at programming by learning how things work](https://jvns.ca/blog/learn-how-things-work/)
- [Practice .NET anywhere with .NET Fiddle](https://dotnetfiddle.net/)
- [Try .NET](https://try.dot.net/)
- [Stack Overflow](https://stackoverflow.com/)
- [Google Advanced Search](https://www.google.com/advanced_search)
- [.NET Videos](https://dotnet.microsoft.com/en-us/learn/videos)
- [Microsoft Learn Shows – .NET Videos](https://learn.microsoft.com/en-us/search/?terms=.net&category=Show)

# Chapter 2 - Speaking C#

## What's New in C#?
- [What's new in C# 13](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-13)
- [What's new in C# 12](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-12)
- [What's new in C# 11](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-11)
- [What's new in C# 10](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-10)
- [What's new in C# 9.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-9)
- [What's new in C# 8.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-8)
- [What's new in C# 7.3](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-73)
- [What's new in C# 7.2](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-72)
- [What's new in C# 7.1](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-71)
- [What's new in C# 7.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-70)
- [What's new in C# 6.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-60)
- [What's new in C# 5.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-50)
- [What's new in C# 4.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-40)
- [What's new in C# 3.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-30)
- [What's new in C# 2.0](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history#c-version-20)

## The journey to modern C#
- [Announcing Open Source C# standardization](https://devblogs.microsoft.com/dotnet/announcing-open-source-c-standardization-standards/)
- [Rosalyn and C# compiler versions](https://github.com/dotnet/roslyn/blob/main/docs/wiki/NuGet-packages.md)
- [How Microsoft rewrote its C# compiler in C# and made it open source](https://medium.com/microsoft-open-source-stories/how-microsoft-rewrote-its-c-compiler-in-c-and-made-it-open-source-4ebed5646f98)
- [Current status of the C# language](https://github.com/dotnet/roslyn/blob/main/docs/Language%20Feature%20Status.md)
- [C# Language Specification 5.0](https://www.microsoft.com/en-us/download/details.aspx?id=7029)
- [Draft proposals for C# Language Specifications for 6.0 and later](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/)
- [C# 9 & 10 Workshop](https://github.com/dotnet-presentations/csharp-workshop)
- [C# language versioning](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/configure-language-version)
- [The history of C#](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history)
- [Interview with the C# Boss - Mads Torgersen](https://www.dotnetcurry.com/csharp/1455/mads-torgersen-interview)
- [The .NET Docs Show - C# Ask Me Anything 🤯](https://www.youtube.com/watch?v=U6cwOzUqjxY)
- [EPIC - .NET 6 C# project templates use latest language idioms #3359](https://github.com/dotnet/templating/issues/3359)
- [SDK support for implicit namespaces in C# projects #25066](https://github.com/dotnet/docs/issues/25066)

## C# language
- [C# Reference](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/)
- [C# Programming Guide](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/)
- [C# Keywords](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/)
- [Naming guidelines](https://learn.microsoft.com/en-us/dotnet/standard/design-guidelines/naming-guidelines)
- [Types (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/types/)
- [Statements, Expressions, and Operators (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/statements-expressions-operators/)
- [Pattern matching overview](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/functional/pattern-matching)
- [Patterns (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/patterns)

## C# implemented proposals
- [C# 13](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-13.0)
- [C# 12](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-12.0)
- [C# 11](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-11.0)
- [C# 10](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-10.0)
- [C# 9](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-9.0)
- [C# 8](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-8.0)
- [C# 7.3](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-7.3)
- [C# 7.2](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-7.2)
- [C# 7.1](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-7.1)
- [C# 7.0](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-7.0)
- [C# 6.0](https://github.com/dotnet/csharplang/tree/main/proposals/csharp-6.0)

## C# proposals being worked on
- [Champion: Simplified parameter null validation code #2145](https://github.com/dotnet/csharplang/issues/2145)
- [Proposal: Semi-Auto-Properties; field keyword #140](https://github.com/dotnet/csharplang/issues/140)
- [Working Set (of proposals)](https://github.com/dotnet/csharplang/milestone/19)

## Text and number types
- [Strings (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/strings/)
- [Verbatim strings](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/tokens/verbatim)
- [String Interpolation in C# 10 and .NET 6](https://devblogs.microsoft.com/dotnet/string-interpolation-in-c-10-and-net-6/)
- [Escape sequences](https://learn.microsoft.com/en-us/archive/blogs/csharpfaq/what-character-escape-sequences-are-available)
- [Floating point numbers](https://ciechanow.ski/exposing-floating-point/)
- [Why 0.1 does not exist in floating-point numbers](https://www.exploringbinary.com/why-0-point-1-does-not-exist-in-floating-point/)
- [American Patriot missile disaster](https://www.ima.umn.edu/~arnold/disasters/patriot.html)

## Console apps and formatting
- [Console.ReadKey improvements in .NET 7](https://devblogs.microsoft.com/dotnet/console-readkey-improvements-in-net-7/)
- [Main() and command-line arguments (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/program-structure/main-command-line)
- [Console Class](https://learn.microsoft.com/en-us/dotnet/api/system.console)
- [Formatting types](https://learn.microsoft.com/en-us/dotnet/standard/base-types/formatting-types)
- [Composite Formatting](https://learn.microsoft.com/en-us/dotnet/standard/base-types/composite-formatting)

## Miscellaneous
- [FWD: "Alb/قلب - the Arabic programming language"](https://www.youtube.com/watch?v=EwYIZBL4sAU)

# Chapter 3 - Controlling Flow, Converting Types, and Handling Exceptions

## Operators
- [C# operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/)
- [Truth tables](https://en.wikipedia.org/wiki/Truth_table)
- [Side effects](https://en.wikipedia.org/wiki/Side_effect_(computer_science))
- [Bitwise and shift operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators)
- [Member access operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/member-access-operators)

## Branching statements and pattern matching
- [Statement keywords (C# Reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/statement-keywords)
- [Goto Fail bug](https://gotofail.com/)
- [goto keyword and examples of when it can be used](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/jump-statements#the-goto-statement)
- [Pattern matching](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/functional/pattern-matching)
- [Patterns and switch expressions](https://devblogs.microsoft.com/dotnet/do-more-with-patterns-in-c-8-0/)

## Casting, converting, rounding, and formatting data
- [Taking control of rounding](https://learn.microsoft.com/en-us/dotnet/api/system.math.round)
- [Format codes for common scenarios](https://learn.microsoft.com/en-us/dotnet/standard/base-types/standard-date-and-time-format-strings)
- [Casting and type conversions (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/articles/csharp/programming-guide/types/casting-and-type-conversions)

## Handling exceptions
- [Exceptions and Exception Handling](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/exceptions/)
- [Exception handling best practices in C#](https://kumarashwinhubert.com/10-exception-handling-best-practices-in-csharp)

## Coding problems in interviews
- [Why can't programmers program?](http://blog.codinghorror.com/why-cant-programmers-program/)
- FizzBuzz for programming interviews:
  - [r/learnprogramming: Is fizzbuzz really still used for interviews](https://www.reddit.com/r/learnprogramming/comments/s1jsyj/is_fizzbuzz_really_still_used_for_interviews/)
  - [r/leetcode, Question regarding Fizzbuzz](https://www.reddit.com/r/leetcode/comments/wdor3z/serious_question_regarding_fizzbuzz/)
- [Make Better Hiring Decisions With Take-Home Coding Challenges](https://codesubmit.io)
- [The 30-minute guide to rocking your next coding interview](https://www.freecodecamp.org/news/coding-interviews-for-dummies-5e048933b82b/)
- [C# Interview Questions](https://www.codingdojo.com/blog/c-interview-questions)
- [Recursion versus interation](https://en.wikipedia.org/wiki/Recursion_(computer_science)#Recursion_versus_iteration)

# Chapter 4 - Writing, Debugging, and Testing Functions

## Debugging
- [Debugging Enhancements in .NET 8](https://devblogs.microsoft.com/dotnet/debugging-enhancements-in-dotnet-8/)
- [Visual Studio for Windows debugger documentation](https://learn.microsoft.com/en-us/visualstudio/debugger/)
- [Visual Studio Code debugger](https://code.visualstudio.com/docs/editor/debugging)
- [How to debug for absolute beginners](https://learn.microsoft.com/en-us/visualstudio/debugger/debugging-absolute-beginners)
- [Master Advanced Breakpoints in Visual Studio - YouTube](https://www.youtube.com/watch?v=n5Pqn_wofmY)
- [Inspect Variables Like a Pro in Visual Studio Debugger - YouTube](https://www.youtube.com/watch?v=bHgprFPmwzo)

## Instrumenting
- [System.Diagnostics Namespace](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics)
- [Debug class](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.debug)
- [Trace listeners](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.tracelistener)
- [Console log formatting](https://learn.microsoft.com/en-us/dotnet/core/extensions/console-log-formatter)
- [Using .env in .NET](https://dusted.codes/dotenv-in-dotnet)
- [Announcing dotnet monitor in .NET 6](https://devblogs.microsoft.com/dotnet/announcing-dotnet-monitor-in-net-6/)

## Testing
- [Test Driven Development (TDD)](https://en.wikipedia.org/wiki/Test-driven_development)
- [Unit testing in .NET](https://learn.microsoft.com/en-us/dotnet/core/testing/)
- [xUnit.net](https://xunit.net/)

# Chapter 5 - Building Your Own Types with Object-Oriented Programming

## Fields
- [Fields (C# programming guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/fields)
- [Access modifiers (C# programming guide)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/access-modifiers)
- [Enumeration types (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/enum)
- [required modifier (C# Reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/required)

## Methods
- [Constructors (C# programming guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/constructors)
- [Methods in C#)](https://learn.microsoft.com/en-us/dotnet/csharp/methods)
- [Deconstructing tuples and other types](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/functional/deconstruct)
- [params keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/params)
- [Calling methods is easier and faster with C# 13 params collections](https://devblogs.microsoft.com/dotnet/csharp13-calling-methods-is-easier-and-faster/)
- [out parameter modifier (C# Reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/out-parameter-modifier)
- [ref (C# Reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/ref)

## Properties
- [Encapsulation of fields using properties](https://stackoverflow.com/questions/1568091/why-use-getters-and-setters-accessors)
- [Properties (C# programming guide)](https://learn.microsoft.com/en-us/dotnet/articles/csharp/properties)
- [Using Tuples in C# to Initialize Properties in the Constructor and to Deconstruct Your Object](https://www.thomasclaudiushuber.com/2021/03/25/csharp-using-tuples-to-initialize-properties/)

## Pattern matching, Records, and Miscellaneous
- [Tutorial: Use pattern matching to build type-driven and data-driven algorithms](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/tutorials/pattern-matching)
- [Comparing struct and class records](https://devblogs.microsoft.com/dotnet/announcing-net-6-release-candidate-2/#record-structs)
- [How do I calculate someone's age based on a DateTime type birthday?](https://stackoverflow.com/questions/9/how-do-i-calculate-someones-age-based-on-a-datetime-type-birthday)

# Chapter 6 - Implementing Interfaces and Inheriting Classes

## Operator overloading, delegates and events
- [Operator (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/operator-overloading)
- [Symbols that can be overloaded](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/statements-expressions-operators/overloadable-operators)
- [Delegates](https://learn.microsoft.com/en-us/dotnet/standard/delegates-lambdas)
- [Events (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/event)
- [How to: Raise and Consume Events](https://learn.microsoft.com/en-us/dotnet/standard/events/how-to-raise-and-consume-events)

## Interfaces and generics
- [Interfaces](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/types/interfaces)
- [Explicit interface implementations](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/interfaces/explicit-interface-implementation)
- [Design decisions for default interface implementations](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/proposals/csharp-8.0/default-interface-methods)
- [Default interface implementations tutorial](https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/tutorials/default-interface-methods-versions)
- [Generics (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/types/generics)

## Memory, reference and value types
- [Reference Types (C# Reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/reference-types)
- [Value Types (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/value-types)
- [Choosing Between Class and Struct](https://learn.microsoft.com/en-us/dotnet/standard/design-guidelines/choosing-between-class-and-struct)
- [Conversation about the .NET type system](https://devblogs.microsoft.com/dotnet/conversation-about-the-net-type-system/)
- [Technical details of the internal memory layout of types in .NET](https://adamsitnik.com/Value-Types-vs-Reference-Types/)
- [Garbage collection](https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/)
- [Finalizers (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/destructors)
- [Finalizers and disposing](https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/unmanaged)
- [IDisposable interface:](https://learn.microsoft.com/en-us/dotnet/standard/garbage-collection/using-objects)

## Null and nullability
- [The inventor of null, Sir Charles Antony Richard Hoare, admits his mistake in a recorded hour-long talk](https://www.infoq.com/presentations/Null-References-The-Billion-Dollar-Mistake-Tony-Hoare)
- [The tweet about achieving 80% annotations in .NET 5](https://twitter.com/terrajobst/status/1296566363880742917)
- [Video to learn how to get rid of null reference exceptions forever](https://learn.microsoft.com/en-us/shows/on-net/this-is-how-you-get-rid-of-null-reference-exceptions-forever)
- [Nullable value types (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/nullable-value-types)
- [Nullable reference types](https://learn.microsoft.com/en-us/dotnet/csharp/nullable-references)
- [Null-conditional operator](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/member-access-operators#null-conditional-operators--and-)
- [Null-coalescing operator](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/null-coalescing-operator)

## Inheritance
- [Inheritance (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/object-oriented/inheritance)

## Language design
- [Let's design a new C# language feature! | .NET Conf 2022](https://www.youtube.com/watch?v=ArN9R_8eL-E)

# Chapter 7 - Packaging and Distributing .NET Types

## .NET versions
The official announcement links are useful because they describe the most important new features in each release.
- [What's new in .NET 8](https://learn.microsoft.com/en-us/dotnet/core/whats-new/dotnet-8)
- [Announcing .NET 7](https://devblogs.microsoft.com/dotnet/announcing-net-7/)
- [Performance Improvements in .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=yNPEdaxkTZw)
- [Announcing .NET 6 — The Fastest .NET Yet](https://devblogs.microsoft.com/dotnet/announcing-net-6/)
- [.NET 5 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-5-0)
- [.NET 5.0 Runtime Highlights](https://codemag.com/Article/2010092/.NET-5.0-Runtime-Highlights)
- [.NET Core 3.1 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1/)
- [.NET Core 3.0 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0/)
- [.NET Core 2.2 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-2/)
- [.NET Core 2.0 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-0/)
- [.NET Core 1.1 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-1/)
- [.NET Core 1.0 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-core-1-0/)

## .NET Standard
- [.NET Standard 2.1 announcement](https://devblogs.microsoft.com/dotnet/announcing-net-standard-2-1/)
- [Future of .NET Standard](https://devblogs.microsoft.com/dotnet/the-future-of-net-standard/)
- [From .NET Standard to .NET 5](https://www.codemag.com/article/2010022)

## .NET API, packages and frameworks
- [Search and browse all .NET APIs](https://learn.microsoft.com/en-us/dotnet/api/)
- [CoreFX README.md](https://github.com/dotnet/corefx/blob/master/Documentation/README.md)
- [How packages and their APIs relate to frameworks](https://gist.github.com/davidfowl/8939f305567e1755412d6dc0b8baf1b7)
- [Currently supported Runtime Identifier (RID) values](https://learn.microsoft.com/en-us/dotnet/articles/core/rid-catalog)
- [System.IO.FileSystem package details](https://www.nuget.org/packages/System.IO.FileSystem/)

## Roslyn, SDKs, and project templates
- [Roslyn compiler](https://github.com/dotnet/roslyn/blob/main/README.md)
- [.NET project SDKs](https://learn.microsoft.com/en-us/dotnet/core/project-sdk/overview)
- [global.json overview](https://learn.microsoft.com/en-us/dotnet/core/tools/global-json)
- [Additional `dotnet new` templates](https://dotnetnew.azurewebsites.net/)
- [Tutorial: Create an item template](https://learn.microsoft.com/en-us/dotnet/core/tutorials/cli-templates-create-item-template)

## Packaging and publishing
- [PDB files](https://www.atmosera.com/blog/pdb-files-what-every-developer-must-know/)
- [The PackageReference format](https://learn.microsoft.com/en-us/nuget/reference/msbuild-targets)
- [NuGet packages](https://www.nuget.org/packages)
- [Announcing NuGet 6.0](https://devblogs.microsoft.com/nuget/announcing-nuget-6/)
- [.NET Core application publishing overview](https://learn.microsoft.com/en-us/dotnet/core/deploying/)
- [How to Deploy .NET apps to Raspberry Pi](https://www.ryadel.com/en/deploy-net-apps-raspberry-pi/)
- [How to solve a circular reference using an interface](https://stackoverflow.com/questions/6928387/how-to-solve-circular-reference)
- [Semantic versioning](http://semver.org)
  
## Decompiling .NET
- [Is it possible to “decompile” a Windows .exe? Or at least view the Assembly?](https://stackoverflow.com/questions/273145/is-it-possible-to-decompile-a-windows-exe-or-at-least-view-the-assembly)
- [IDA Freeware Download Page](https://www.hex-rays.com/ida-free/#download)

## Ahead-of-time (AOT) compilation
- [Native AOT deployment](https://learn.microsoft.com/en-us/dotnet/core/deploying/native-aot/)
- [How to make libraries compatible with native AOT](https://devblogs.microsoft.com/dotnet/creating-aot-compatible-libraries/)
- [ASP.NET Core support for native AOT](https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/#asp-net-core-support-for-native-aot)
- [How to make libraries compatible with native AOT](https://devblogs.microsoft.com/dotnet/creating-aot-compatible-libraries/)

## Porting from .NET Framework to modern .NET
- [Overview of porting from .NET Framework to .NET Core](https://learn.microsoft.com/en-us/dotnet/core/porting/)
- [Upgrading from .NET Framework to .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=yyVUaXT0JoU)
- [What .NET Developers ought to know](https://www.hanselman.com/blog/what-net-developers-ought-to-know-to-start-in-2017)
- [Introducing the .NET Upgrade Assistant Preview](https://devblogs.microsoft.com/dotnet/introducing-the-net-upgrade-assistant-preview/)
- [.NET Upgrade Assistant](https://dotnet.microsoft.com/en-us/platform/upgrade-assistant)
- [Discover cross-platform issues](https://learn.microsoft.com/en-us/dotnet/standard/analyzers/api-analyzer#discover-cross-platform-issues)
- [Amazon Porting Assistant for .NET](https://aws.amazon.com/porting-assistant-dotnet/)

## Preview features
- [Preview Features](https://github.com/dotnet/designs/blob/main/accepted/2021/preview-features/preview-features.md)

# Chapter 8 - Working with Common .NET Types

## Working with numbers
- [Numerics types](https://learn.microsoft.com/en-us/dotnet/standard/numerics)
- [The Half type](https://devblogs.microsoft.com/dotnet/introducing-the-half-type/)
- [nint and nuint types (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/integral-numeric-types#native-sized-integers)
- [nint Struct](https://learn.microsoft.com/en-us/dotnet/api/system.nint)
- [Names for large numbers](https://en.wikipedia.org/wiki/Names_of_large_numbers)

## Working with text and regular expressions
- [String Class](https://learn.microsoft.com/en-us/dotnet/api/system.string)
- [Regex Class](https://learn.microsoft.com/en-us/dotnet/api/system.text.regularexpressions.regex)
- [.NET regular expressions](https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expressions)
- [Regular Expression Language – Quick Reference](https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expression-language-quick-reference)
- [Unicode in regular expressions](https://www.regular-expressions.info/unicode.html)
- [Using a regular expression to split a comma-separated string](https://stackoverflow.com/questions/18144431/regex-to-split-a-csv)
- [To specify a Unicode character, use `\u` followed by four characters specifying the number of the character. For example, `\u00c0` is the À character](https://www.regular-expressions.info)

## Collections
- [Collections and Data Structures](https://learn.microsoft.com/en-us/dotnet/standard/collections)
- [System.Collections Namespace)](https://learn.microsoft.com/en-us/dotnet/api/system.collections)
- [System.Collections.Concurrent Namespace](https://learn.microsoft.com/en-us/dotnet/api/system.collections.concurrent)
- [What types should I use to pass collections in C#?](https://markheath.net/post/passing-collections-csharp)
- [On Abstractions and For-Each Performance in C#](https://www.infoq.com/articles/For-Each-Performance/)

## Spans
- [Span<T>](https://learn.microsoft.com/en-us/dotnet/api/system.span-1)
- [How spans work internally](https://learn.microsoft.com/en-us/archive/msdn-magazine/2018/january/csharp-all-about-span-exploring-a-new-net-mainstay)

## Networking
- [.NET 6 Networking Improvements](https://devblogs.microsoft.com/dotnet/dotnet-6-networking-improvements/)

# Chapter 9 - Working with Files, Streams, and Serialization

## File system, encoding, streams, and serialization
- [File System and the Registry (C# Programming Guide)](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/file-system/)
- [Character encoding in .NET](https://learn.microsoft.com/en-us/dotnet/articles/standard/base-types/character-encoding)
- [How pipelines help with I/O performance](https://devblogs.microsoft.com/dotnet/system-io-pipelines-high-performance-io-in-net/)
- [Serialization (C#)](https://learn.microsoft.com/en-us/dotnet/articles/csharp/programming-guide/concepts/serialization/)
- [Serializing to Files, TextWriters, and XmlWriters](https://learn.microsoft.com/en-us/dotnet/standard/linq/serialize-files-textwriters-xmlwriters)
- [The convenience of System.IO](https://devblogs.microsoft.com/dotnet/the-convenience-of-system-io/)

## JSON
- [The convenience of System.Text.Json](https://devblogs.microsoft.com/dotnet/the-convenience-of-system-text-json/)
- [Newtonsoft Json.NET](https://www.newtonsoft.com/json)
- [System.Text.Json APIs](https://devblogs.microsoft.com/dotnet/try-the-new-system-text-json-apis/)
- [What’s next for System.Text.Json?](https://devblogs.microsoft.com/dotnet/whats-next-for-system-text-json/)
- [What’s new in System.Text.Json in .NET 7](https://devblogs.microsoft.com/dotnet/system-text-json-in-dotnet-7/)
- [Issues solved by the new JSON APIs, including JamesNK's comments](https://github.com/dotnet/corefx/issues/33115)
- [How to migrate from Newtonsoft.Json to System.Text.Json](https://learn.microsoft.com/en-us/dotnet/standard/serialization/system-text-json-migrate-from-newtonsoft-how-to)

# Chapter 10 - Working with Data Using Entity Framework Core

## Legacy EF 6
- [Entity Framework 6.3 and its .NET Core 3.0 and later support](https://devblogs.microsoft.com/dotnet/announcing-ef-core-3-0-and-ef-6-3-general-availability/)

## EF Core
- [EF Core documentation](https://learn.microsoft.com/en-us/ef/core/)
- [Announcing Entity Framework Core 7 RC2: JSON Columns](https://devblogs.microsoft.com/dotnet/announcing-ef7-release-candidate-2/)
- [New features in EF Core 7](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-7.0/whatsnew)
- [New features in EF Core 6](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-6.0/whatsnew)
- [New features in EF Core 5](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-5.0/whatsnew)
- [New features in Entity Framework Core 3.x](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-3.x/)
- [Plans for Entity Framework Core 6.0 revealed as Microsoft admits it is unlikely to match Dapper for performance](https://www.theregister.com/2021/01/19/entity_framework_core_6/)
- [Entity Framework Community Standup - Performance Tuning an EF Core App](https://www.youtube.com/watch?v=VgNFFEqwZPU)

## EF Core database providers
- [EF Core database providers](https://learn.microsoft.com/en-us/ef/core/providers/)
- [Devart database providers](https://www.devart.com/dotconnect/entityframework.html)
- [Document Database Providers for Entity Framework Core](https://github.com/BlueshiftSoftware/EntityFrameworkCore/blob/develop/README.md)

## SQLite
- [Download SQLite](https://www.sqlite.org/download.html)
- [SQL statements supported by SQLite](https://sqlite.org/lang.html)
- [Download SQLiteStudio](http://sqlitestudio.pl)
- [Check the latest EF Core Sqlite NuGet package version](https://www.nuget.org/packages/Microsoft.EntityFrameworkCore.Sqlite/)

## Microsoft SQL Server
- [SQL Server downloads](https://www.microsoft.com/en-us/sql-server/sql-server-downloads)
- [Use Visual Studio Code to create and run Transact-SQL scripts](https://learn.microsoft.com/en-us/sql/tools/visual-studio-code/sql-server-develop-use-vscode)
- [.NET Interactive with SQL!| .NET Notebooks in Visual Studio Code](https://devblogs.microsoft.com/dotnet/net-interactive-with-sql-net-notebooks-in-visual-studio-code/)

## EF Core models
- [EF Core model conventions](https://learn.microsoft.com/en-us/ef/core/modeling/)
- [Data seeding](https://learn.microsoft.com/en-us/ef/core/modeling/data-seeding)
- [Humanizer library](http://humanizr.net)
- [Scaffolding](https://learn.microsoft.com/en-us/ef/core/managing-schemas/scaffolding?tabs=dotnet-core-cli)
- [Deep Dive into Many-to-Many: A Tour of EF Core 5.0](https://channel9.msdn.com/Shows/On-NET/Deep-Dive-into-Many-to-Many-A-Tour-of-EF-Core-50-pt-2)
- [Naming Conventions for Entity Framework Core Tables and Columns](https://github.com/efcore/EFCore.NamingConventions)
- [Table-per-concrete-type (TPC) inheritance mapping](https://learn.microsoft.com/en-gb/ef/core/what-is-new/ef-core-7.0/whatsnew#table-per-concrete-type-tpc-inheritance-mapping)
- [T4 goodness with Entity Framework Core 7 | .NET Conf 2022](https://www.youtube.com/watch?v=PUexkGWErNk)

## EF Core querying and manipulating
- [Filtered include](https://learn.microsoft.com/en-us/ef/core/querying/related-data/eager#filtered-include)
- [Simple logging](https://learn.microsoft.com/en-us/ef/core/logging-events-diagnostics/simple-logging)
- [Query tags](https://learn.microsoft.com/en-us/ef/core/querying/tags)
- [Loading patterns](https://learn.microsoft.com/en-us/ef/core/querying/related-data)
- [Pooling database contexts](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-2.0#dbcontext-pooling)

# Chapter 11 - Querying and Manipulating Data Using LINQ

## LINQ concepts
- [LINQ's INSANE Improvements in .NET 9](https://www.youtube.com/watch?v=xFsSEaa6tjA)
- [LINQ comprehension syntax](https://stackoverflow.com/questions/6229187/linq-why-is-it-called-comprehension-syntax)
- [LINQ in C#](https://learn.microsoft.com/en-us/dotnet/csharp/linq/linq-in-csharp)
- [New LINQ extensions in .NET 6 and benchmarks](https://blog.elmah.io/new-linq-extensions-in-net-6-and-benchmarks/)
- [Expression trees](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/concepts/expression-trees/)

## LINQ providers
- [EF Core LINQ queries no longer evaluated at client](https://learn.microsoft.com/en-us/ef/core/what-is-new/ef-core-3.x/breaking-changes#linq-queries-are-no-longer-evaluated-on-the-client)
- [Parallel LINQ (PLINQ)](https://learn.microsoft.com/en-us/dotnet/standard/parallel-programming/introduction-to-plinq)
- [LINQ to XML Overview (C#)](https://learn.microsoft.com/en-us/dotnet/standard/linq/linq-xml-overview)

## LINQ samples and tools
- 101 LINQ Samples (third-party copies of the original Microsoft document): 
    - https://github.com/tigerbluejay/FullLINQ101Implementations
    - http://linq101.nilzorblog.com/linq101-lambda.php
    - https://jonlabelle.com/snippets/view/csharp/101-linq-query-samples
- [LINQPad](https://www.linqpad.net/)

# Chapter 12 - Introducing Modern Web Development Using .NET

## .NET apps
- [.NET Architecture Guides](https://dotnet.microsoft.com/en-us/learn/dotnet/architecture-guides)

## .NET Content Management Systems
- [Piranha CMS](https://piranhacms.org/)
- [Umbraco CMS](https://umbraco.com/products/umbraco-cms/umbraco-13/)
- [Optimizely Comtent Cloud (CMS 12)](https://docs.developers.optimizely.com/content-cloud)
- [Orchard Core](http://orchardcore.net/)
- [OSS Spotlight - Build websites with a modern ASP.NET Core CMS – Orchard Core](https://www.youtube.com/watch?v=cKhAVWm845o)

## General web development
- [Responsive Web Design with HTML5 and CSS - Third Edition](https://www.packtpub.com/product/responsive-web-design-with-html5-and-css-third-edition/9781839211560)
- [Bootstrap](https://getbootstrap.com/)
- [WebSocket](https://en.wikipedia.org/wiki/WebSocket)
- [MessagePack](https://msgpack.org)
- [WebAssembly](https://webassembly.org)
- [TypeScript](https://www.typescriptlang.org)
- [Content Delivery Network (CDN)](https://en.wikipedia.org/wiki/Content_delivery_network)

## ASP.NET versions and features
The official announcement links are useful because they describe the most important new features in each release.
- [State of ASP.NET Core | .NET Conf 2022](https://www.youtube.com/watch?v=gNyEpkJMmcM)
- [ASP.NET Core 7.0 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-in-net-7/)
- [ASP.NET Core 6.0 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-in-net-6/)
- [ASP.NET Core 5.0 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-in-net-5/)
- [Blazor WebAssembly announcement](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-now-available/)
- [ASP.NET Core 3.1 announcement](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1/)
- [ASP.NET Core 3.0 announcement](https://devblogs.microsoft.com/aspnet/a-first-look-at-changes-coming-in-asp-net-core-3-0/)
- [ASP.NET Core 2.2 announcement](https://devblogs.microsoft.com/aspnet/asp-net-core-2-2-available-today/)
- [ASP.NET Core 2.1 announcement](https://devblogs.microsoft.com/aspnet/asp-net-core-2-1-0-now-available/)
- [ASP.NET Core 2.0 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-2-0/)
- [ASP.NET Core 1.1 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-1-1/)
- [ASP.NET Core 1.0 announcement](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-1-0/)

# Chapter 13 - Building Websites Using ASP.NET Core

## ASP.NET Core
- [ASP.NET Core fundamentals](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/)
- [Static files in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/static-files)
- [HttpContext class](https://learn.microsoft.com/en-us/dotnet/api/system.web.httpcontext)
- [Kestrel web server](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/servers/kestrel)
- [ASP.NET Core hosting environments](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/environments)
- [Free TLS/SSL certificates](https://letsencrypt.org)
- [Performance Improvements in ASP.NET Core 8](https://devblogs.microsoft.com/dotnet/performance-improvements-in-aspnet-core-8/)

## Razor syntax
- [Introducing the new Razor editor in Visual Studio 2022](https://devblogs.microsoft.com/visualstudio/introducing-the-new-razor-editor-in-visual-studio-2022/)
- [Razor syntax reference for ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/mvc/views/razor)
- [Layout in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/mvc/views/layout)
- [Tag Helpers in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/mvc/views/tag-helpers/intro)
- [DbContext Lifetime, Configuration, and Initialization](https://learn.microsoft.com/en-us/ef/core/dbcontext-configuration/#dbcontext-in-dependency-injection-for-aspnet-core)
- [The `<partial>` tag helper](https://learn.microsoft.com/en-us/aspnet/core/mvc/views/tag-helpers/built-in/partial-tag-helper)
- [Visual Studio Code Compact Folders feature](https://github.com/microsoft/vscode-docs/blob/vnext/release-notes/v1_41.md#compact-folders-in-explorer)

## Endpoint routing
- [Simple examples of Run, Map, and Use](https://www.vaughanreid.com/2020/05/using-in-line-middleware-in-asp-net-core/)
- [Automatically visualize your endpoints](https://andrewlock.net/visualizing-asp-net-core-endpoints-using-graphvizonline-and-the-dot-language/)
- [Configuring the HTTP pipeline with middleware](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/middleware)
- [DEEP DIVE: HOW IS THE ASP.NET CORE MIDDLEWARE PIPELINE BUILT?](https://www.stevejgordon.co.uk/how-is-the-asp-net-core-middleware-pipeline-built)

## Security and privacy
- [What’s new with identity in .NET 8](https://devblogs.microsoft.com/dotnet/whats-new-with-identity-in-dotnet-8/)
- [Built-in features for compliance with modern privacy requirements like GDPR](https://learn.microsoft.com/en-us/aspnet/core/security/gdpr)
- [Enable QR code generation for TOTP authenticator apps in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/security/authentication/identity-enable-qrcodes)
- [Scaffold Identity in ASP.NET Core projects](https://learn.microsoft.com/en-us/aspnet/core/security/authentication/scaffold-identity?tabs=netcore-cli)
- [Introduction to authorization in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/security/authorization/introduction)
- [Prevent Cross-Site Request Forgery (XSRF/CSRF) attacks in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/security/anti-request-forgery)

## Miscellaneous
- [Unit test controller logic in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/mvc/controllers/testing)
- [Filters for cross-concern functionality](https://learn.microsoft.com/en-us/aspnet/core/mvc/controllers/filters)
- [Free stock photos for commercial use with no attribution](https://www.pexels.com/)

# Chapter 14 - Building Interactive Web Components Using Blazor

## Blazor hosting models
- [Blazor](https://dotnet.microsoft.com/apps/aspnet/web-apps/blazor)
- [Official list of supported Blazor platforms](https://learn.microsoft.com/en-us/aspnet/core/blazor/supported-platforms)
- [Blazor hosting models](https://learn.microsoft.com/en-us/aspnet/core/blazor/hosting-models)
- [What's new for Blazor in .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=evW4Gj4sHsk)

## Blazor components
- [The reason for needing CSS isolation for Blazor components](https://github.com/dotnet/aspnetcore/issues/10170)
- [OI icons](https://iconify.design/icon-sets/oi/)
- [ASP.NET Core Blazor forms and input components](https://learn.microsoft.com/en-us/aspnet/core/blazor/forms-and-input-components)
- [NavigationManager with Blazor routes](https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing#uri-and-navigation-state-helpers)

## Advanced techniques
- [Implementing offline support for Blazor WebAssembly projects](https://learn.microsoft.com/en-us/aspnet/core/blazor/progressive-web-app#offline-support)
- [Lazy loading assemblies](https://learn.microsoft.com/en-us/aspnet/core/blazor/webassembly-lazy-load-assemblies)
- [Routing in Blazor Apps: Comparing the routing of popular web frameworks like React and Angular with Blazor](https://devblogs.microsoft.com/premier-developer/routing-in-blazor-apps/)

## Other resources
- [Awesome Blazor: A collection of awesome Blazor resources](https://github.com/AdrienTorris/awesome-blazor/blob/master/README.md)
- [Blazor University: Learn the new .NET SPA framework from Microsoft](https://blazor-university.com)
- [Blazor - app building workshop: In this workshop, we will build a complete Blazor app and learn about the various Blazor framework features along the way](https://github.com/dotnet-presentations/blazor-workshop/blob/main/README.md)
- [Carl Franklin's Blazor Train](https://www.youtube.com/playlist?list=PL8h4jt35t1wjvwFnvcB2LlYL4jLRzRmoz)
- [Welcome to PACMAN written in C# and running on Blazor WebAssembly](https://github.com/SteveDunn/PacManBlazor/blob/master/readme.md)

# Chapter 15 - Building and Consuming Web Services

## Web service technologies
- [Media types](http://en.wikipedia.org/wiki/Media_type)
- [WS-* standards](https://en.wikipedia.org/wiki/List_of_web_service_specifications)
- [HTTP OPTIONS method and other HTTP methods](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/OPTIONS)
- [HTTP POST requests](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST)
- [Create web APIs with ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/web-api/)

## Web service routing
- [Design decisions around endpoint routing](https://devblogs.microsoft.com/aspnet/asp-net-core-2-2-0-preview1-endpoint-routing/)
- [Endpoint routing](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/routing)
- [Previous routing system](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/routing)
- [Route constraints](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/routing#route-constraints)
- [Proposed standard for Problem Details for HTTP APIs](https://www.rfc-editor.org/rfc/rfc7807)
- [Implementing problem details](https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.problemdetails)

## Web service clients
- [REST Client](https://github.com/Huachao/vscode-restclient/blob/master/README.md)
- [It is the BaseAddress and DefaultRequestHeaders properties that you should treat with caution with multiple threads](https://medium.com/@nuno.caneco/c-httpclient-should-not-be-disposed-or-should-it-45d2a8f568bc)
- [You're using HttpClient wrong and it is destabilizing your software](https://aspnetmonsters.com/2016/08/2016-08-27-httpclientwrong/)
- [How to initiate HTTP requests](https://learn.microsoft.com/en-us/aspnet/core/fundamentals/http-requests)
- [Issues with the original HttpClient class available in .NET](https://learn.microsoft.com/en-us/dotnet/architecture/microservices/implement-resilient-applications/use-httpclientfactory-to-implement-resilient-http-requests#issues-with-the-original-httpclient-class-available-in-net)
- [HttpClient extension methods for easily working with JSON](https://github.com/dotnet/designs/blob/main/accepted/2020/json-http-extensions/json-http-extensions.md)

## Documenting web services
- [Swagger](https://swagger.io/)
- [Swagger Tools](https://swagger.io/tools/)
- [Swashbuckle for ASP.NET Core](https://github.com/domaindrivendev/Swashbuckle.AspNetCore)
- [How Swagger can support multiple versions of an API](https://stackoverflow.com/questions/30789045/leverage-multipleapiversions-in-swagger-with-attribute-versioning/30789944)
- [Importance of documenting services](https://idratherbewriting.com/learnapidoc/)
- [Benefits of setting version compatibility](https://learn.microsoft.com/en-us/aspnet/core/mvc/compatibility-version)
- [Check latest version of analyzers package](http://www.nuget.org/packages/Microsoft.AspNetCore.Mvc.Api.Analyzers/)

## Securing web services
- [Verifying that the tokens used to call your web APIs are requested with the expected claims](https://learn.microsoft.com/en-us/azure/active-directory/develop/scenario-protected-web-api-verification-scope-app-roles)
- [CORS can be enabled to allow different origin requests](https://learn.microsoft.com/en-us/aspnet/core/security/cors)
- [Common HTTP security headers that you might want to add](https://www.meziantou.net/security-headers-in-asp-net-core.htm)

## Health checks and reliable web services
- [Health checks in ASP.NET Core](https://learn.microsoft.com/en-us/aspnet/core/host-and-deploy/health-checks)
- [How to extend the health check response](https://devblogs.microsoft.com/dotnet/asp-net-core-2-2-0-preview1-healthcheck/)
- [How Polly can make your web services more reliable](https://learn.microsoft.com/en-us/dotnet/architecture/microservices/implement-resilient-applications/implement-http-call-retries-exponential-backoff-polly)
- [Use HttpClientFactory to implement resilient HTTP requests](https://learn.microsoft.com/en-us/dotnet/architecture/microservices/implement-resilient-applications/use-httpclientfactory-to-implement-resilient-http-requests)
- [Redis](https://redis.io)
- [Resilience and chaos engineering](https://devblogs.microsoft.com/dotnet/resilience-and-chaos-engineering/)
- [Dev Tunnels: A Game Changer for Mobile Developers](https://devblogs.microsoft.com/dotnet/dev-tunnels-a-game-changer-for-mobile-developers/)
- [Hello HybridCache! Streamlining Cache Management for ASP.NET Core Applications](https://devblogs.microsoft.com/dotnet/hybrid-cache-is-now-ga/)

# Epilogue

## Next steps on your C# and .NET learning journey
- [Follow the Framework Design Guidelines](https://learn.microsoft.com/en-us/dotnet/standard/design-guidelines/)
- [Follow the code style rules](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/style-rules/)
- [Cloud-Native learning resources for .NET developers](https://devblogs.microsoft.com/dotnet/cloud-native-learning-resources-for-net-developers/)
- [37 App Ideas for Bootcamp Students & Code Newbies](https://dev.to/sylwiavargas/33-app-ideas-for-bootcamp-students-code-newbies-3n28)
- [Just! Build! Websites!](https://github.com/melanierichards/just-build-websites/blob/main/README.md)

## Learn from other Packt books
- [Mobile Development with .NET](https://www.packtpub.com/product/mobile-development-with-net-second-edition/9781800204690)
- [Enterprise Application Development with C# 10 and .NET 6](https://www.packtpub.com/product/enterprise-application-development-with-c-10-and-net-6-second-edition/9781803232973)
- [Software Architecture with C# 10 and .NET 6](https://www.packtpub.com/product/software-architecture-with-c-10-and-net-6-third-edition/9781803235257)
- [An Atypical ASP.NET Core 6 Design Patterns Guide](https://www.packtpub.com/product/an-atypical-aspnet-core-6-design-patterns-guide-second-edition/9781803249841)
- [Customizing ASP.NET Core 6.0](https://www.packtpub.com/product/customizing-aspnet-core-60-second-edition/9781803233604)
- [ASP.NET Core 5 Secure Coding Cookbook](https://www.packtpub.com/product/aspnet-core-5-secure-coding-cookbook/9781801071567)
- [ASP.NET Core 5 and React](https://www.packtpub.com/product/asp-net-core-5-and-react-second-edition/9781800206168)
- [ASP.NET Core 6 and Angular](https://www.packtpub.com/product/aspnet-core-6-and-angular-fifth-edition/9781803239705)
- [ASP.NET Core and Vue.js](https://www.packtpub.com/product/aspnet-core-and-vuejs/9781800206694)
- [Practical Microservices with Dapr and .NET](https://www.packtpub.com/product/practical-microservices-with-dapr-and-net/9781800568372)
- [Web Development with Blazor](https://www.packtpub.com/product/web-development-with-blazor-second-edition/9781803241494)
- [Building Blazor WebAssembly Applications with gRPC](https://www.packtpub.com/product/building-blazor-webassembly-applications-with-grpc/9781804610558)
