**C# language versions and features**

If you already have some familiarity with older versions of C# and are excited to find out about the new features in the most recent versions of C#, then I have made it easier for you to jump around by listing language versions and their important new features below, along with the chapter number and topic title where you can learn about them.

- [Project COOL](#project-cool)
- [C# 1, February 2002](#c-1-february-2002)
- [C# 1.2, 2003](#c-12-2003)
- [C# 2, 2005](#c-2-2005)
- [C# 3, 2007](#c-3-2007)
- [C# 4, 2010](#c-4-2010)
- [C# 5, 2012](#c-5-2012)
- [C# 6, 2015](#c-6-2015)
- [C# 7, March 2017](#c-7-march-2017)
- [C# 7.1, August 2017](#c-71-august-2017)
- [C# 7.2, November 2017](#c-72-november-2017)
- [C# 7.3, May 2018](#c-73-may-2018)
- [C# 8, September 2019](#c-8-september-2019)
- [C# 9, November 2020](#c-9-november-2020)
- [C# 10, November 2021](#c-10-november-2021)
- [C# 11, November 2022](#c-11-november-2022)
- [C# 12, November 2023](#c-12-november-2023)
- [C# 13, November 2024](#c-13-november-2024)


# Project COOL

Before the first release of C#, it had the codename **C-like Object-Oriented Language (COOL)**.

# C# 1, February 2002

Included all the important features of a statically typed object-oriented modern language, as you will see throughout *Chapters 2* to *6*.

# C# 1.2, 2003

A few minor improvements, like automatic disposal at the end of `foreach` statements, was released with Visual Studio .NET 2003.

# C# 2, 2005

Enabled strong data typing using generics, to improve code performance and reduce type errors, including the topics listed in *Table 2.1*:

Feature|Chapter|Topic
---|---|---
Partial classes|5|Splitting classes using partial
Nullable value types|6|Making a value type nullable
Generics|6|Making types more reusable with generics

*Table 2.1: Features of C# 2 covered in this book*

# C# 3, 2007

Enabled declarative coding with **Language INtegrated Queries (LINQ)** and related features like anonymous types and lambda expressions, including the topics listed in *Table 2.2*:

Feature|Chapter|Topic
---|---|---
Implicitly typed local variables|2|Inferring the type of a local variable
Partial methods|5|Partial methods
LINQ|11|All topics in *Chapter 11, Querying and Manipulating Data Using LINQ*

*Table 2.2: Features of C# 3 covered in this book*

# C# 4, 2010

Improved interoperability with dynamic languages like F# and Python, including the topics listed in *Table 2.3*:

Feature|Chapter|Topic
---|---|---
Dynamic types|2|Storing dynamic types
Named/optional arguments|5|Optional parameters and named arguments

*Table 2.3: Features of C# 3 covered in this book*

# C# 5, 2012

Simplified asynchronous operation support by automatically implementing complex state machines while writing what looks like synchronous statements, including the topics listed in *Table 2.4*:

Feature|Chapter|Topic
---|---|---
Simplified asynchronous tasks|2|Understanding `async` and `await`

*Table 2.4: Features of C# 5 covered in this book*

# C# 6, 2015

Focused on minor refinements to the language, including the topics listed in *Table 2.5*:

Feature|Chapter|Topic
---|---|---
`static using` imports|2|Simplifying the usage of the console
Interpolated strings|2|Displaying output to the user
Expression-bodied members|5|Defining read-only properties

*Table 2.5: Features of C# 6 covered in this book*

# C# 7, March 2017

Added functional language features like tuples and pattern matching, as well as minor refinements to the language, including the topics listed in *Table 2.6*:

Feature|Chapter|Topic
---|---|---
Binary literals and digit separators|2|Storing whole numbers
Pattern matching|3|Pattern matching with the `if` statement
`out` variables|5|Controlling how parameters are passed
Tuples|5|Combining multiple values with tuples
Local functions|6|Defining local functions

*Table 2.6: Features of C# 7 covered in this book*

# C# 7.1, August 2017

Focused on minor refinements to the language, including the topics listed in *Table 2.7*:

Feature|Chapter|Topic
---|---|---
`async Main`|2|Improving responsiveness for console apps
Default literal expressions|5|Setting fields with default literals
Inferred tuple element names|5|Inferring tuple names

*Table 2.7: Features of C# 7.1 covered in this book*

# C# 7.2, November 2017
Focused on minor refinements to the language, including the topics listed in *Table 2.8*:

Feature|Chapter|Topic
---|---|---
Leading underscores in numeric literals|2|Storing whole numbers
Non-trailing named arguments|5|Optional parameters and named arguments
`private protected` access modifier|5|Understanding access modifiers
You can test == and != with tuple types|5|Comparing tuples

*Table 2.8: Features of C# 7.2 covered in this book*

# C# 7.3, May 2018

Focused on performance-oriented safe code, which improved `ref` variables, pointers, and `stackalloc`. These features are advanced and rarely needed by most developers, so they are not covered in this book.

# C# 8, September 2019

Introduced a major change to the language related to `null` handling, including the topics listed in *Table 2.9*:

Feature|Chapter|Topic
---|---|---
Switch expressions|3|Simplifying switch statements with switch expressions
Nullable reference types|6|Making a reference type nullable
Default interface methods|6|Understanding the default interface methods

*Table 2.9: Features of C# 8 covered in this book*

# C# 9, November 2020
Introduced record types, refinements to pattern matching, and minimal-code projects, including the topics listed in *Table 2.10*:

Feature|Chapter|Topic
---|---|---
Minimal-code console apps|1|Understanding top-level programs
Target-typed new expressions|2|Using target-typed new expressions to instantiate objects
Enhanced pattern matching|5|Pattern matching with objects
Records|5|Working with records

*Table 2.10: Features of C# 9 covered in this book*

# C# 10, November 2021

Focused on features that minimize the amount of code needed in common scenarios, including the topics listed in *Table 2.11*:

Feature|Chapter|Topic
---|---|---
Global namespace imports|2|Importing namespaces
Constant string literals|2|Formatting using interpolated strings
File-scoped namespaces|5|Simplifying namespace declarations
Record structs|6|Working with record struct types
`ArgumentNullException.ThrowIfNull`|6|Checking for `null` in method parameters

*Table 2.11: Features of C# 10 covered in this book*

# C# 11, November 2022

Focused on features that simplify your code, including the topics listed in *Table 2.12*:

Feature|Chapter|Topic
---|---|---
Raw string literals|2|Understanding raw string literals
Line breaks in interpolated string expressions|2|Formatting using interpolated strings
Required properties|5|Requiring properties to be set during instantiation

*Table 2.12: Features of C# 11 covered in this book*

# C# 12, November 2023

Focused on features that simplify your code and improving performance, including the topics listed in *Table 2.13*:

Feature|Chapter|Topic
---|---|---
Inline arrays|3|Understanding inline arrays
Default lambda parameters|4|Lambda expressions with default parameter values
New exception guard clauses|4|Throwing exceptions using guard clauses
Aliasing any type|5|Renaming a type with a using alias
Primary constructors|5|Defining a primary constructor
Interceptors|7|Method interceptors

*Table 2.13: Features of C# 12 mentioned in this book*

# C# 13, November 2024

Focused on features that simplify your code and improving performance, including the topics listed in *Table 2.14*:

Feature|Chapter|Topic
---|---|---
2-4x faster exceptions|3|Handling exceptions
Partial properties|5|Partial properties
params collection expression support|5|Passing a variable number of parameters

*Table 2.14: Features of C# 13 mentioned in this book*

> **More Information**, The history of C#: https://learn.microsoft.com/en-us/dotnet/csharp/whats-new/csharp-version-history
